/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheManager;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteFuture;

public class GridCacheManagerAdapter<K, V>
implements GridCacheManager<K, V> {
    protected GridCacheContext cctx;
    protected IgniteLogger log;
    protected final AtomicBoolean starting = new AtomicBoolean(false);

    @Override
    public final void start(GridCacheContext<K, V> cctx) throws IgniteCheckedException {
        if (!this.starting.compareAndSet(false, true)) assert (false) : "Method start is called more than once for manager: " + this;
        assert (cctx != null);
        this.cctx = cctx;
        this.log = cctx.logger(this.getClass());
        this.start0();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    protected IgniteLogger log() {
        return this.log;
    }

    protected GridCacheContext<K, V> context() {
        return this.cctx;
    }

    protected void start0() throws IgniteCheckedException {
    }

    @Override
    public final void stop(boolean cancel, boolean destroy) {
        if (!this.starting.get()) {
            return;
        }
        this.stop0(cancel, destroy);
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    protected void stop0(boolean cancel, boolean destroy) {
    }

    @Override
    public final void onKernalStart() throws IgniteCheckedException {
        this.onKernalStart0();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug(this.kernalStartInfo());
        }
    }

    @Override
    public final void onKernalStop(boolean cancel) {
        if (!this.starting.get()) {
            return;
        }
        this.onKernalStop0(cancel);
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug(this.kernalStopInfo());
        }
    }

    protected void onKernalStart0() throws IgniteCheckedException {
    }

    protected void onKernalStop0(boolean cancel) {
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) {
    }

    @Override
    public void printMemoryStats() {
    }

    protected String startInfo() {
        return "Cache manager started: " + this.cctx.name();
    }

    protected String stopInfo() {
        return "Cache manager stopped: " + this.cctx.name();
    }

    protected String kernalStartInfo() {
        return "Cache manager received onKernalStart() callback: " + this.cctx.name();
    }

    protected String kernalStopInfo() {
        return "Cache manager received onKernalStop() callback: " + this.cctx.name();
    }

    public String toString() {
        return S.toString(GridCacheManagerAdapter.class, this);
    }
}

