/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryField;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.binary.BinaryFieldImpl;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.processors.cache.GridCacheDefaultAffinityKeyMapper;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class CacheDefaultBinaryAffinityKeyMapper
extends GridCacheDefaultAffinityKeyMapper {
    private static final long serialVersionUID = 0L;
    private CacheObjectBinaryProcessorImpl proc;
    private Map<String, String> typeNameAffFields = new HashMap<String, String>();
    private volatile transient Map<Integer, BinaryField> typeIdAffFields;

    public CacheDefaultBinaryAffinityKeyMapper(@Nullable CacheKeyConfiguration[] cacheKeyCfgs) {
        if (!F.isEmpty(cacheKeyCfgs)) {
            for (CacheKeyConfiguration cacheKeyCfg : cacheKeyCfgs) {
                this.typeNameAffFields.put(cacheKeyCfg.getTypeName(), cacheKeyCfg.getAffinityKeyFieldName());
            }
        }
    }

    @Override
    public Object affinityKey(Object key) {
        try {
            key = this.proc.toBinary(key, false);
        }
        catch (IgniteException e) {
            U.error(this.log, "Failed to marshal key to binary: " + key, e);
        }
        if (key instanceof BinaryObject) {
            Object res;
            assert (key instanceof BinaryObjectEx) : "All BinaryObject implementations must implement " + BinaryObjectEx.class.getName() + ": " + key.getClass().getName();
            BinaryObjectEx key0 = (BinaryObjectEx)key;
            BinaryField affField = this.affinityKeyField(key0.typeId());
            if (affField != null && (res = affField.value(key0)) != null) {
                return res;
            }
            return key;
        }
        return super.affinityKey(key);
    }

    @Nullable
    public BinaryField affinityKeyField(String typeName) {
        int typeId = this.proc.typeId(typeName);
        return this.affinityKeyField(typeId);
    }

    @Nullable
    public BinaryField affinityKeyField(int typeId) {
        BinaryField res;
        Map<Integer, BinaryField> typeIdAffFields0 = this.typeIdAffFields;
        if (typeIdAffFields0 == null) {
            typeIdAffFields0 = new HashMap<Integer, BinaryField>();
            for (Map.Entry<String, String> entry : this.typeNameAffFields.entrySet()) {
                String typeName = entry.getKey();
                String affFieldName = entry.getValue();
                int curTypeId = this.proc.typeId(typeName);
                BinaryFieldImpl field = this.proc.binaryContext().createField(curTypeId, affFieldName);
                typeIdAffFields0.put(curTypeId, field);
            }
            this.typeIdAffFields = typeIdAffFields0;
        }
        if ((res = typeIdAffFields0.get(typeId)) == null) {
            res = this.proc.affinityKeyField(typeId);
        }
        return res;
    }

    @Override
    public void ignite(Ignite ignite) {
        super.ignite(ignite);
        if (ignite != null) {
            IgniteKernal kernal = (IgniteKernal)ignite;
            this.proc = (CacheObjectBinaryProcessorImpl)kernal.context().cacheObjects();
        }
    }
}

