/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.transaction;

import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.api.transaction.TransactionInfo;

@Controller(value="/management/v1/transactions/")
@Tag(name="transactions")
public interface TransactionApi {
    @Operation(summary="Retrieve all in progress transactions", description="Fetches all in progress transactions.")
    @ApiResponse(responseCode="200", description="Successfully retrieved in progress transactions.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=TransactionInfo.class)))})
    @Get
    public CompletableFuture<Collection<TransactionInfo>> transactions();

    @Operation(summary="Retrieve transaction state", description="Fetches the current state of a specific transaction identified by transactionId.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved the transaction state.", content={@Content(mediaType="application/json", schema=@Schema(implementation=TransactionInfo.class))}), @ApiResponse(responseCode="404", description="Transaction not found.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class))})})
    @Get(value="/{transactionId}")
    public CompletableFuture<TransactionInfo> transaction(@Schema(name="transactionId", description="The unique identifier of the transaction.", requiredMode=Schema.RequiredMode.REQUIRED) UUID var1);

    @Operation(summary="Kill transaction.", description="Kills a specific transaction identified by transactionId.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully killed the transaction.", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Transaction not found.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Transaction is in an illegal state.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Problem.class))})})
    @Delete(value="/{transactionId}")
    public CompletableFuture<Void> killTransaction(@Schema(name="transactionId", description="The unique identifier of the transaction.", requiredMode=Schema.RequiredMode.REQUIRED) UUID var1);
}

