/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.errors;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.security.config.TokenCookieConfiguration;
import io.micronaut.security.errors.PriorToLoginPersistence;
import jakarta.inject.Singleton;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Optional;

@Requires(property="micronaut.security.redirect.prior-to-login", value="true")
@Singleton
public class CookiePriorToLoginPersistence
implements PriorToLoginPersistence {
    private static final String COOKIE_NAME = "ORIGINAL_URI";
    private final CookieConfiguration cookieConfiguration;

    public CookiePriorToLoginPersistence(@Nullable TokenCookieConfiguration cookieConfiguration) {
        this.cookieConfiguration = cookieConfiguration;
    }

    @Override
    public void onUnauthorized(HttpRequest<?> request, MutableHttpResponse<?> response) {
        Cookie cookie = Cookie.of((String)COOKIE_NAME, (String)request.getUri().toString());
        this.configure(cookie, request);
        cookie.maxAge((TemporalAmount)Duration.ofMinutes(5L));
        response.cookie(cookie);
    }

    @Override
    public Optional<URI> getOriginalUri(HttpRequest<?> request, MutableHttpResponse<?> response) {
        Optional uri = request.getCookies().get((CharSequence)COOKIE_NAME, URI.class);
        if (uri.isPresent()) {
            Cookie cookie = Cookie.of((String)COOKIE_NAME, (String)"");
            this.configure(cookie, request);
            cookie.maxAge(0L);
            response.cookie(cookie);
        }
        return uri;
    }

    protected void configure(Cookie cookie, HttpRequest<?> request) {
        if (this.cookieConfiguration != null) {
            cookie.configure(this.cookieConfiguration, request.isSecure());
        } else {
            cookie.secure(request.isSecure()).httpOnly(true);
            cookie.path("/");
        }
    }
}

