/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class MetadataDef<M extends Metadata> {
    public final Class<M> metadataClass;
    public final Class<? extends MetadataHandler<M>> handlerClass;
    public final ImmutableList<Method> methods;

    private MetadataDef(Class<M> metadataClass, Class<? extends MetadataHandler<M>> handlerClass, Method ... methods) {
        this.metadataClass = metadataClass;
        this.handlerClass = handlerClass;
        this.methods = (ImmutableList)Arrays.stream(methods).sorted(Comparator.comparing(Method::getName)).collect(ImmutableList.toImmutableList());
        SortedMap<String, Method> handlerMethods = MetadataHandler.handlerMethods(handlerClass);
        Preconditions.checkArgument((this.methods.size() == handlerMethods.size() ? 1 : 0) != 0, (String)"handlerMethods.length = methods.length", this.methods, handlerMethods);
        Pair.forEach(this.methods, handlerMethods.values(), (method, handlerMethod) -> {
            List<Class<?>> methodTypes = Arrays.asList(method.getParameterTypes());
            List<Class<?>> handlerTypes = Arrays.asList(handlerMethod.getParameterTypes());
            Preconditions.checkArgument((methodTypes.size() + 2 == handlerTypes.size() ? 1 : 0) != 0, (String)"methodTypes.size + 2 == handlerTypes.size", (Object)handlerMethod, methodTypes, handlerTypes);
            Preconditions.checkArgument((boolean)RelNode.class.isAssignableFrom(handlerTypes.get(0)), (String)"RelNode.assignableFrom(handlerType[0])", (Object)handlerMethod, handlerTypes);
            Preconditions.checkArgument((RelMetadataQuery.class == handlerTypes.get(1) ? 1 : 0) != 0, (String)"handlerTypes[1] == RelMetadataQuery", (Object)handlerMethod, handlerTypes);
            Preconditions.checkArgument((boolean)methodTypes.equals(Util.skip(handlerTypes, 2)), (String)"methodTypes == handlerTypes.skip(2)", (Object)handlerMethod, methodTypes, handlerTypes);
        });
    }

    public static <M extends Metadata> MetadataDef<M> of(Class<M> metadataClass, Class<? extends MetadataHandler<M>> handlerClass, Method ... methods) {
        return new MetadataDef<M>(metadataClass, handlerClass, methods);
    }
}

