/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Preconditions;
import com.google.uzaygezen.core.BigIntegerMath;
import com.google.uzaygezen.core.BitVector;
import com.google.uzaygezen.core.MathUtils;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.lang3.ArrayUtils;

public class LongArrayBitVector
implements BitVector {
    private final long[] data;
    private final int size;
    private static final int BYTE = 8;
    private static final int WORD = 64;
    private static final int BYTES_IN_WORD = 8;

    private LongArrayBitVector(long[] data, int size) {
        assert ((size + 64 - 1) / 64 == data.length);
        this.data = data;
        this.size = size;
        assert (this.checkSanity());
    }

    public LongArrayBitVector(int size) {
        this(new long[(size + 64 - 1) / 64], size);
    }

    public static LongArrayBitVector of(long value, int size) {
        LongArrayBitVector result = new LongArrayBitVector(size);
        result.copyFrom(value);
        return result;
    }

    public static LongArrayBitVector of(BitVector bitvector) {
        LongArrayBitVector result = new LongArrayBitVector(bitvector.size());
        result.copyFrom(bitvector);
        return result;
    }

    public static LongArrayBitVector concat(Iterable<BitVector> bitVectors) {
        int size = 0;
        for (BitVector bv : bitVectors) {
            size += bv.size();
        }
        long[] data = new long[(size + 64 - 1) / 64];
        int i = 0;
        for (BitVector bv : bitVectors) {
            LongArrayBitVector.copy(LongArrayBitVector.toPotentiallySharedLongArray(bv), 0, data, i, bv.size());
            i += bv.size();
        }
        return new LongArrayBitVector(data, size);
    }

    public static LongArrayBitVector concat(BitVector ... bits) {
        return LongArrayBitVector.concat(Arrays.asList(bits));
    }

    private void checkRange(int low, int high, int ... values) {
        for (int v : values) {
            if (v >= low && v <= high) continue;
            throw new IndexOutOfBoundsException("index " + v + " should be in [" + low + ".." + high + "]");
        }
    }

    private boolean checkSanity() {
        return (this.size & 0x3F) == 0 || (this.data[this.data.length - 1] & -1L << this.size) == 0L;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public void set(int bitIndex) {
        this.checkRange(0, this.size - 1, bitIndex);
        int n = bitIndex / 64;
        this.data[n] = this.data[n] | 1L << bitIndex;
        assert (this.checkSanity());
    }

    @Override
    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    @Override
    public void set(int fromIndex, int toIndex) {
        this.checkRange(0, this.size, fromIndex, toIndex);
        int fromBucket = fromIndex / 64;
        int toBucket = toIndex / 64;
        if (fromBucket == toBucket) {
            if (fromBucket != this.data.length) {
                int n = fromBucket;
                this.data[n] = this.data[n] | (1L << toIndex) - (1L << fromIndex);
            } else {
                assert (fromIndex == toIndex);
                assert (toIndex == this.size);
            }
        } else {
            int n = fromBucket;
            this.data[n] = this.data[n] | -(1L << fromIndex);
            if (toBucket != this.data.length) {
                int n2 = toBucket;
                this.data[n2] = this.data[n2] | (1L << toIndex) - 1L;
            } else assert (toIndex == this.size);
            Arrays.fill(this.data, fromBucket + 1, toBucket, -1L);
        }
        assert (this.checkSanity());
    }

    @Override
    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    @Override
    public boolean get(int bitIndex) {
        this.checkRange(0, this.size - 1, bitIndex);
        return (this.data[bitIndex / 64] & 1L << bitIndex) != 0L;
    }

    @Override
    public void copyFromSection(BitVector src, int fromIndex) {
        this.checkRange(0, src.size() - this.size, fromIndex);
        this.clear();
        this.copyFromSection(LongArrayBitVector.toPotentiallySharedLongArray(src), fromIndex);
        assert (this.checkSanity());
    }

    @Override
    public void copySectionFrom(int offset, BitVector src) {
        this.checkRange(0, this.size - src.size(), offset);
        this.copySectionFrom(offset, LongArrayBitVector.toPotentiallySharedLongArray(src), src.size());
        assert (this.checkSanity());
    }

    public LongArrayBitVector slice(int from, int to) {
        Preconditions.checkArgument((0 <= from && from <= to && to <= this.size ? 1 : 0) != 0);
        long[] newData = new long[(to - from + 64 - 1) / 64];
        LongArrayBitVector.copy(this.data, from, newData, 0, to - from);
        return new LongArrayBitVector(newData, to - from);
    }

    public LongArrayBitVector[] slice(int ... widths) {
        LongArrayBitVector[] result = new LongArrayBitVector[widths.length];
        int widthsSum = 0;
        for (int i = 0; i < widths.length; ++i) {
            Preconditions.checkArgument((widths[i] >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((widthsSum + widths[i] <= this.size ? 1 : 0) != 0);
            long[] newData = new long[(widths[i] + 64 - 1) / 64];
            LongArrayBitVector.copy(this.data, widthsSum, newData, 0, widths[i]);
            result[i] = new LongArrayBitVector(newData, widths[i]);
            widthsSum += widths[i];
        }
        return result;
    }

    @Override
    public int length() {
        int i = this.data.length;
        while (--i >= 0 && this.data[i] == 0L) {
        }
        if (i < 0) {
            return 0;
        }
        return 64 * (i + 1) - Long.numberOfLeadingZeros(this.data[i]);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Arrays.fill(this.data, 0L);
    }

    @Override
    public void clear(int bitIndex) {
        this.checkRange(0, this.size - 1, bitIndex);
        int n = bitIndex / 64;
        this.data[n] = this.data[n] & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
        assert (this.checkSanity());
    }

    @Override
    public void clear(int fromIndex, int toIndex) {
        this.checkRange(0, this.size, fromIndex, toIndex);
        int fromBucket = fromIndex / 64;
        int toBucket = toIndex / 64;
        if (fromBucket == toBucket) {
            if (fromBucket != this.data.length) {
                int n = fromBucket;
                this.data[n] = this.data[n] & ((1L << toIndex) - (1L << fromIndex) ^ 0xFFFFFFFFFFFFFFFFL);
            } else {
                assert (fromIndex == toIndex);
                assert (toIndex == this.size);
            }
        } else {
            assert (fromIndex != this.size);
            int n = fromBucket;
            this.data[n] = this.data[n] & (-(1L << fromIndex) ^ 0xFFFFFFFFFFFFFFFFL);
            if (toBucket != this.data.length) {
                int n2 = toBucket;
                this.data[n2] = this.data[n2] & ((1L << toIndex) - 1L ^ 0xFFFFFFFFFFFFFFFFL);
            } else assert (toIndex == this.size);
            Arrays.fill(this.data, fromBucket + 1, toBucket, 0L);
        }
        assert (this.checkSanity());
    }

    @Override
    public int cardinality() {
        int result = 0;
        for (int i = 0; i < this.data.length; ++i) {
            result += Long.bitCount(this.data[i]);
        }
        return result;
    }

    @Override
    public void flip(int bitIndex) {
        this.checkRange(0, this.size - 1, bitIndex);
        int n = bitIndex / 64;
        this.data[n] = this.data[n] ^ 1L << bitIndex;
        assert (this.checkSanity());
    }

    @Override
    public void flip(int fromIndex, int toIndex) {
        this.checkRange(0, this.size, fromIndex, toIndex);
        int fromBucket = fromIndex / 64;
        int toBucket = toIndex / 64;
        if (fromBucket == toBucket) {
            if (fromBucket != this.data.length) {
                int n = fromBucket;
                this.data[n] = this.data[n] ^ (1L << toIndex) - (1L << fromIndex);
            } else {
                assert (fromIndex == toIndex);
                assert (toIndex == this.size);
            }
        } else {
            int n = fromBucket;
            this.data[n] = this.data[n] ^ -(1L << fromIndex);
            if (toBucket != this.data.length) {
                int n2 = toBucket;
                this.data[n2] = this.data[n2] ^ (1L << toIndex) - 1L;
            } else assert (toIndex == this.size);
            ++fromBucket;
            while (fromBucket < toBucket) {
                int n3 = fromBucket++;
                this.data[n3] = this.data[n3] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        assert (this.checkSanity());
    }

    @Override
    public boolean intersects(BitVector set) {
        return this.intersects(LongArrayBitVector.toPotentiallySharedLongArray(set));
    }

    @Override
    public int nextSetBit(int fromIndex) {
        Preconditions.checkArgument((fromIndex >= 0 ? 1 : 0) != 0);
        if (fromIndex >= this.size) {
            return -1;
        }
        int fromBucket = fromIndex / 64;
        long word = this.data[fromBucket] & -(1L << fromIndex);
        while (word == 0L && ++fromBucket < this.data.length) {
            word = this.data[fromBucket];
        }
        if (fromBucket == this.data.length) {
            return -1;
        }
        int result = 64 * fromBucket + Long.numberOfTrailingZeros(word);
        assert (0 <= result & result < this.size);
        return result;
    }

    @Override
    public int nextClearBit(int fromIndex) {
        Preconditions.checkArgument((fromIndex >= 0 ? 1 : 0) != 0);
        if (fromIndex >= this.size) {
            return -1;
        }
        int fromBucket = fromIndex / 64;
        long word = this.data[fromBucket] & -(1L << fromIndex);
        while (word == -1L && ++fromBucket < this.data.length) {
            word = this.data[fromBucket];
        }
        if (fromBucket == this.data.length) {
            return -1;
        }
        int result = 64 * fromBucket + Long.numberOfTrailingZeros(word ^ 0xFFFFFFFFFFFFFFFFL);
        return result >= this.size ? -1 : result;
    }

    @Override
    public boolean increment() {
        int i;
        for (i = 0; i < this.data.length && this.data[i] == -1L; ++i) {
            this.data[i] = 0L;
        }
        if (i == this.data.length) {
            Arrays.fill(this.data, -1L);
            assert (this.checkSanity());
            return false;
        }
        if (i == this.data.length - 1 && this.data[i] == (1L << this.size) - 1L) {
            Arrays.fill(this.data, -1L);
            this.data[i] = (1L << this.size) - 1L;
            assert (this.checkSanity());
            return false;
        }
        int n = i;
        this.data[n] = this.data[n] + 1L;
        assert (this.checkSanity());
        return true;
    }

    public boolean decrement() {
        int i;
        for (i = 0; i < this.data.length && this.data[i] == 0L; ++i) {
            this.data[i] = -1L;
        }
        if (i == this.data.length) {
            Arrays.fill(this.data, 0L);
            assert (this.checkSanity());
            return false;
        }
        int n = i;
        this.data[n] = this.data[n] - 1L;
        assert (this.checkSanity());
        return true;
    }

    @Override
    public void andNot(BitVector o) {
        Preconditions.checkArgument((this.size == o.size() ? 1 : 0) != 0);
        this.andNot(LongArrayBitVector.toPotentiallySharedLongArray(o));
        assert (this.checkSanity());
    }

    @Override
    public void and(BitVector o) {
        Preconditions.checkArgument((this.size == o.size() ? 1 : 0) != 0);
        this.and(LongArrayBitVector.toPotentiallySharedLongArray(o));
        assert (this.checkSanity());
    }

    @Override
    public void or(BitVector o) {
        Preconditions.checkArgument((this.size == o.size() ? 1 : 0) != 0);
        this.or(LongArrayBitVector.toPotentiallySharedLongArray(o));
        assert (this.checkSanity());
    }

    @Override
    public void xor(BitVector o) {
        Preconditions.checkArgument((this.size == o.size() ? 1 : 0) != 0);
        this.xor(LongArrayBitVector.toPotentiallySharedLongArray(o));
        assert (this.checkSanity());
    }

    @Override
    public void rotate(int count) {
        long[] old = Arrays.copyOf(this.data, this.data.length);
        count = (count % this.size + this.size) % this.size;
        LongArrayBitVector.copy(old, 0, this.data, this.size - count, count);
        LongArrayBitVector.copy(old, count, this.data, 0, this.size - count);
        assert (this.checkSanity());
    }

    @Override
    public void grayCode() {
        int i;
        if (this.size == 0) {
            return;
        }
        for (i = 0; i < this.data.length - 1; ++i) {
            int n = i;
            this.data[n] = this.data[n] ^ this.data[i] >>> 1;
            if ((this.data[i + 1] & 1L) == 0L) continue;
            int n2 = i;
            this.data[n2] = this.data[n2] ^ Long.MIN_VALUE;
        }
        int n = i;
        this.data[n] = this.data[n] ^ this.data[i] >>> 1;
        assert (this.checkSanity());
    }

    @Override
    public void grayCodeInverse() {
        boolean last = false;
        int i = this.data.length;
        while (--i >= 0) {
            int n = i;
            this.data[n] = this.data[n] ^ this.data[i] >>> 1;
            int n2 = i;
            this.data[n2] = this.data[n2] ^ this.data[i] >>> 2;
            int n3 = i;
            this.data[n3] = this.data[n3] ^ this.data[i] >>> 4;
            int n4 = i;
            this.data[n4] = this.data[n4] ^ this.data[i] >>> 8;
            int n5 = i;
            this.data[n5] = this.data[n5] ^ this.data[i] >>> 16;
            int n6 = i;
            this.data[n6] = this.data[n6] ^ this.data[i] >>> 32;
            if (last) {
                this.data[i] = this.data[i] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            last = (this.data[i] & 1L) != 0L;
        }
        assert (this.checkSanity());
    }

    @Override
    public void smallerEvenAndGrayCode() {
        if (!this.decrement()) {
            return;
        }
        this.data[0] = this.data[0] & 0xFFFFFFFFFFFFFFFEL;
        this.grayCode();
        assert (this.checkSanity());
    }

    @Override
    public int lowestDifferentBit() {
        int i;
        if (this.size == 0) {
            return 0;
        }
        boolean last = (this.data[0] & 1L) != 0L;
        for (i = 0; i < this.data.length && this.data[i] == (last ? -1L : 0L); ++i) {
        }
        if (i == this.data.length) {
            return 0;
        }
        int result = 64 * i + Long.numberOfTrailingZeros(last ? this.data[i] ^ 0xFFFFFFFFFFFFFFFFL : this.data[i]);
        return result >= this.size ? 0 : result;
    }

    @Override
    public boolean areAllLowestBitsClear(int bitCount) {
        int i;
        this.checkRange(0, this.size, bitCount);
        int bucket = bitCount / 64;
        for (i = 0; i < bucket && this.data[i] == 0L; ++i) {
        }
        return i == bucket && (this.size == 0 || (this.data[i] & (1L << bitCount) - 1L) == 0L);
    }

    @Override
    public void grayCodeRank(BitVector mu, BitVector w) {
        Preconditions.checkArgument((mu.size() == w.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((this.size == mu.cardinality() ? 1 : 0) != 0);
        this.clear();
        int j = 0;
        if (mu.size() == 0) {
            assert (this.checkSanity());
            return;
        }
        int i = mu.nextSetBit(0);
        while (i >= 0) {
            if (w.get(i)) {
                this.set(j);
            }
            ++j;
            i = i + 1 < mu.size() ? mu.nextSetBit(i + 1) : -1;
        }
        assert (this.checkSanity());
    }

    @Override
    public void grayCodeRankInverse(BitVector mu, BitVector known, BitVector r) {
        Preconditions.checkArgument((this.size == mu.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((this.size == known.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((r.size() == mu.cardinality() ? 1 : 0) != 0);
        Preconditions.checkArgument((!known.intersects(mu) ? 1 : 0) != 0);
        this.clear();
        int j = r.size() - 1;
        boolean previous = false;
        for (int i = this.size - 1; i >= 0; --i) {
            boolean current;
            boolean bl = current = mu.get(i) ? r.get(j--) : previous ^ known.get(i);
            if (current) {
                this.set(i);
            }
            previous = current;
        }
    }

    @Override
    public void copyFrom(BitVector from) {
        Preconditions.checkArgument((this.size == from.size() ? 1 : 0) != 0);
        this.copyFrom(LongArrayBitVector.toPotentiallySharedLongArray(from));
        assert (this.checkSanity());
    }

    @Override
    public void copyFrom(BitSet from) {
        Preconditions.checkArgument((this.size >= from.length() ? 1 : 0) != 0);
        this.clear();
        int i = from.nextSetBit(0);
        while (i >= 0) {
            this.set(i);
            i = from.nextSetBit(i + 1);
        }
        assert (this.checkSanity());
    }

    @Override
    public LongArrayBitVector clone() {
        return new LongArrayBitVector(Arrays.copyOf(this.data, this.data.length), this.size);
    }

    @Override
    public BitSet toBitSet() {
        BitSet result = new BitSet(this.size);
        if (this.size != 0) {
            int i = this.nextSetBit(0);
            while (i != -1) {
                result.set(i);
                i = this.nextSetBit(i + 1);
            }
        }
        return result;
    }

    @Override
    public long toLong() {
        if (this.size == 0) {
            return 0L;
        }
        return this.data[0];
    }

    @Override
    public long toExactLong() {
        Preconditions.checkState((this.size - this.length() <= 64 ? 1 : 0) != 0);
        return this.toLong();
    }

    @Override
    public void copyFrom(long d) {
        Preconditions.checkArgument((64 - Long.numberOfLeadingZeros(d) <= this.size ? 1 : 0) != 0);
        this.clear();
        if (this.size > 0) {
            this.data[0] = d;
        }
    }

    @Override
    public long[] toLongArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public byte[] toBigEndianByteArray() {
        int n = MathUtils.bitCountToByteCount(this.size);
        byte[] a = new byte[n];
        long x = 0L;
        int wordIndex = -1;
        int i = 0;
        while (i < n) {
            if ((i & 7) == 0) {
                assert (x == 0L);
                x = this.data[++wordIndex];
            }
            a[n - ++i] = (byte)(x & 0xFFL);
            x >>>= 8;
        }
        assert (x == 0L);
        assert (wordIndex == this.data.length - 1);
        return a;
    }

    @Override
    public BigInteger toBigInteger() {
        return new BigInteger(this.isEmpty() ? 0 : 1, this.toBigEndianByteArray());
    }

    @Override
    public void copyFrom(long[] array) {
        Preconditions.checkArgument((this.data.length == array.length ? 1 : 0) != 0);
        System.arraycopy(array, 0, this.data, 0, this.data.length);
        assert (this.checkSanity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFromBigEndian(byte[] array) {
        ArrayUtils.reverse((byte[])array);
        try {
            this.copyFrom(array);
        }
        finally {
            ArrayUtils.reverse((byte[])array);
        }
        assert (this.checkSanity());
    }

    public void copyFrom(byte[] array) {
        Preconditions.checkArgument(((this.size + 8 - 1) / 8 == array.length ? 1 : 0) != 0);
        this.clear();
        for (int i = 0; i < array.length; ++i) {
            int n = i / 8;
            this.data[n] = this.data[n] | ((long)array[i] & 0xFFL) << i % 8 * 8;
        }
        assert (this.checkSanity());
    }

    @Override
    public void copyFrom(BigInteger s) {
        byte[] array = BigIntegerMath.nonnegativeBigIntegerToBigEndianByteArrayForBitSize(s, this.size);
        this.copyFromBigEndian(array);
    }

    @Override
    public int hashCode() {
        long h = 1234L;
        int i = this.data.length;
        while (--i >= 0) {
            h ^= this.data[i] * (long)(i + 1);
        }
        return this.size + 31 * (int)(h >> 32 ^ h);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BitVector)) {
            return false;
        }
        BitVector other = (BitVector)o;
        return this.size == other.size() && Arrays.equals(this.data, LongArrayBitVector.toPotentiallySharedLongArray(other));
    }

    private void checkSize(BitVector other) {
        if (other.size() != this.size()) {
            throw new IllegalArgumentException("Sizes are not equal. this:" + this.size + " other:" + other.size());
        }
    }

    @Override
    public int compareTo(BitVector o) {
        this.checkSize(o);
        return this.compareTo(LongArrayBitVector.toPotentiallySharedLongArray(o));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[LongArrayBitVector: size=");
        sb.append(Integer.toString(this.size));
        sb.append(" 0x");
        if (this.size > 0) {
            sb.append(String.format("%X", this.data[this.data.length - 1]));
        } else {
            sb.append("0");
        }
        int i = this.data.length - 1;
        while (--i >= 0) {
            sb.append(String.format("%016X", this.data[i]));
        }
        sb.append("]");
        return sb.toString();
    }

    private static long[] toPotentiallySharedLongArray(BitVector vector) {
        if (vector instanceof LongArrayBitVector) {
            return ((LongArrayBitVector)vector).data;
        }
        return vector.toLongArray();
    }

    private void copyFromSection(long[] src, int fromIndex) {
        LongArrayBitVector.copy(src, fromIndex, this.data, 0, this.size);
    }

    private void copySectionFrom(int offset, long[] src, int srcSize) {
        LongArrayBitVector.copy(src, 0, this.data, offset, srcSize);
    }

    private void andNot(long[] other) {
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] & (other[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    private void and(long[] other) {
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] & other[i];
        }
    }

    private void or(long[] other) {
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] | other[i];
        }
    }

    private void xor(long[] other) {
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] ^ other[i];
        }
    }

    @Override
    private int compareTo(long[] other) {
        int cmp;
        int i = this.data.length;
        while (--i >= 0 && this.data[i] == other[i]) {
        }
        if (i == -1) {
            cmp = 0;
        } else {
            long x = this.data[i] + Long.MIN_VALUE;
            long y = other[i] + Long.MIN_VALUE;
            cmp = Long.compare(x, y);
            assert (cmp != 0);
        }
        return cmp;
    }

    private boolean intersects(long[] other) {
        for (int i = 0; i < this.data.length; ++i) {
            if ((this.data[i] & other[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    private static void copy(long[] source, int srcIndex, long[] destination, int destIndex, int length) {
        while (length > 0) {
            int toCopy = length;
            toCopy = Math.min(toCopy, LongArrayBitVector.left(srcIndex));
            toCopy = Math.min(toCopy, LongArrayBitVector.left(destIndex));
            int fromBucket = srcIndex / 64;
            int toBucket = destIndex / 64;
            long w = LongArrayBitVector.mask(toCopy) << srcIndex & source[fromBucket];
            int n = toBucket;
            destination[n] = destination[n] & (LongArrayBitVector.mask(toCopy) << destIndex ^ 0xFFFFFFFFFFFFFFFFL);
            int n2 = toBucket;
            destination[n2] = destination[n2] | w >>> srcIndex << destIndex;
            srcIndex += toCopy;
            destIndex += toCopy;
            length -= toCopy;
        }
    }

    private static int left(int index) {
        return (index + 64) / 64 * 64 - index;
    }

    private static long mask(int k) {
        if (k == 64) {
            return -1L;
        }
        return (1L << k) - 1L;
    }
}

