/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tx.message.PartitionEnlistmentMessage;
import org.apache.ignite.internal.tx.message.TxFinishReplicaRequest;
import org.apache.ignite.internal.tx.message.TxFinishReplicaRequestBuilder;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;

class TxFinishReplicaRequestDeserializer
implements MessageDeserializer<TxFinishReplicaRequest> {
    private final TxFinishReplicaRequestBuilder msg;

    TxFinishReplicaRequestDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.txFinishReplicaRequest();
    }

    public Class<TxFinishReplicaRequest> klass() {
        return TxFinishReplicaRequest.class;
    }

    public TxFinishReplicaRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                boolean tmp = reader.readBoolean("commit");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commit(tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("commitPartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitPartitionId((ReplicationGroupIdMessage)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readHybridTimestamp("commitTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitTimestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readBoxedLong("enlistmentConsistencyToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.enlistmentConsistencyToken((Long)tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groupId((ReplicationGroupIdMessage)tmp);
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readMap("groups", MessageCollectionItemType.MSG, MessageCollectionItemType.MSG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groups((Map<ReplicationGroupIdMessage, PartitionEnlistmentMessage>)tmp);
                reader.incrementState();
            }
            case 6: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 7: {
                Object tmp = reader.readUuid("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txId((UUID)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxFinishReplicaRequest.class);
    }
}

