/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.ResetPeerRequestBuilder;
import org.apache.ignite.raft.jraft.rpc.ResetPeerRequestSerializer;

public class ResetPeerRequestImpl
implements CliRequests.ResetPeerRequest,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 1007;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final Collection<String> newPeersList;
    @IgniteToStringInclude
    private final Collection<String> oldPeersList;
    @IgniteToStringInclude
    private final String peerId;

    private ResetPeerRequestImpl(String groupId, Collection<String> newPeersList, Collection<String> oldPeersList, String peerId) {
        this.groupId = groupId;
        this.newPeersList = newPeersList;
        this.oldPeersList = oldPeersList;
        this.peerId = peerId;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public Collection<String> newPeersList() {
        return this.newPeersList;
    }

    @Override
    public Collection<String> oldPeersList() {
        return this.oldPeersList;
    }

    @Override
    public String peerId() {
        return this.peerId;
    }

    public MessageSerializer serializer() {
        return ResetPeerRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(ResetPeerRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 1007;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ResetPeerRequestImpl otherMessage = (ResetPeerRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.newPeersList, otherMessage.newPeersList) && Objects.equals(this.oldPeersList, otherMessage.oldPeersList) && Objects.equals(this.peerId, otherMessage.peerId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.groupId, this.newPeersList, this.oldPeersList, this.peerId);
        return result;
    }

    public ResetPeerRequestImpl clone() {
        try {
            return (ResetPeerRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ResetPeerRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ResetPeerRequestBuilder {
        private String groupId;
        private Collection<String> newPeersList;
        private Collection<String> oldPeersList;
        private String peerId;

        private Builder() {
        }

        @Override
        public ResetPeerRequestBuilder groupId(String groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ResetPeerRequestBuilder newPeersList(Collection<String> newPeersList) {
            Objects.requireNonNull(newPeersList, "newPeersList is not marked @Nullable");
            this.newPeersList = newPeersList;
            return this;
        }

        @Override
        public ResetPeerRequestBuilder oldPeersList(Collection<String> oldPeersList) {
            this.oldPeersList = oldPeersList;
            return this;
        }

        @Override
        public ResetPeerRequestBuilder peerId(String peerId) {
            Objects.requireNonNull(peerId, "peerId is not marked @Nullable");
            this.peerId = peerId;
            return this;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public Collection<String> newPeersList() {
            return this.newPeersList;
        }

        @Override
        public Collection<String> oldPeersList() {
            return this.oldPeersList;
        }

        @Override
        public String peerId() {
            return this.peerId;
        }

        @Override
        public CliRequests.ResetPeerRequest build() {
            return new ResetPeerRequestImpl(Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.newPeersList, "newPeersList is not marked @Nullable"), this.oldPeersList, Objects.requireNonNull(this.peerId, "peerId is not marked @Nullable"));
        }
    }
}

