/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.serialize;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.serialize.JdkSerializer;
import io.micronaut.core.serialize.exceptions.SerializationException;
import io.micronaut.core.type.Argument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;

public interface ObjectSerializer {
    public static final ObjectSerializer JDK = new JdkSerializer();

    public void serialize(@Nullable Object var1, OutputStream var2) throws SerializationException;

    public <T> Optional<T> deserialize(@Nullable InputStream var1, Class<T> var2) throws SerializationException;

    default public <T> Optional<T> deserialize(@Nullable InputStream inputStream, Argument<T> requiredType) throws SerializationException {
        return this.deserialize(inputStream, requiredType.getType());
    }

    default public Optional<byte[]> serialize(@Nullable Object object) throws SerializationException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.serialize(object, outputStream);
        return Optional.of(outputStream.toByteArray());
    }

    default public <T> Optional<T> deserialize(@Nullable byte[] bytes, Class<T> requiredType) throws SerializationException {
        Optional<T> optional;
        if (bytes == null) {
            return Optional.empty();
        }
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        try {
            optional = this.deserialize((InputStream)input, requiredType);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SerializationException("I/O error occurred during deserialization: " + e.getMessage(), e);
            }
        }
        input.close();
        return optional;
    }

    default public <T> Optional<T> deserialize(@Nullable byte[] bytes, Argument<T> requiredType) throws SerializationException {
        return this.deserialize(bytes, requiredType.getType());
    }

    default public Optional<Object> deserialize(@Nullable byte[] bytes) throws SerializationException {
        if (bytes == null) {
            return Optional.empty();
        }
        return this.deserialize(bytes, Object.class);
    }
}

