/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.TxStateMeta;
import org.apache.ignite.internal.tx.impl.PlacementDriverHelper;
import org.apache.ignite.internal.tx.impl.TxManagerImpl;
import org.apache.ignite.internal.tx.impl.TxMessageSender;
import org.apache.ignite.internal.tx.impl.VolatileTxStateMetaStorage;
import org.apache.ignite.internal.tx.message.CleanupReplicatedInfo;
import org.apache.ignite.internal.tx.message.CleanupReplicatedInfoMessage;
import org.apache.ignite.internal.tx.message.TxCleanupMessageErrorResponse;
import org.apache.ignite.internal.tx.message.TxCleanupMessageResponse;
import org.apache.ignite.internal.tx.message.TxMessageGroup;
import org.apache.ignite.internal.util.CompletableFutures;
import org.jetbrains.annotations.Nullable;

public class TxCleanupRequestSender {
    private final PlacementDriverHelper placementDriverHelper;
    private final TxMessageSender txMessageSender;
    private final ConcurrentMap<UUID, CleanupContext> writeIntentsReplicated = new ConcurrentHashMap<UUID, CleanupContext>();
    private final VolatileTxStateMetaStorage txStateVolatileStorage;

    public TxCleanupRequestSender(TxMessageSender txMessageSender, PlacementDriverHelper placementDriverHelper, VolatileTxStateMetaStorage txStateVolatileStorage) {
        this.txMessageSender = txMessageSender;
        this.placementDriverHelper = placementDriverHelper;
        this.txStateVolatileStorage = txStateVolatileStorage;
    }

    public void start() {
        this.txMessageSender.messagingService().addMessageHandler(TxMessageGroup.class, (msg, sender, correlationId) -> {
            if (msg instanceof TxCleanupMessageResponse && correlationId == null) {
                assert (!(msg instanceof TxCleanupMessageErrorResponse)) : "Cleanup error response is not expected here.";
                CleanupReplicatedInfoMessage result = ((TxCleanupMessageResponse)msg).result();
                assert (result != null) : "Result for the cleanup response cannot be null.";
                this.onCleanupReplicated(result.asCleanupReplicatedInfo());
            }
        });
    }

    private void onCleanupReplicated(CleanupReplicatedInfo info) {
        CleanupContext ctx = this.writeIntentsReplicated.computeIfPresent(info.txId(), (uuid, cleanupContext) -> {
            cleanupContext.partitions.removeAll(info.partitions());
            return cleanupContext;
        });
        if (ctx != null && ctx.partitions.isEmpty()) {
            this.markTxnCleanupReplicated(info.txId(), ctx.txState, ctx.commitPartitionId);
            this.writeIntentsReplicated.remove(info.txId());
        }
    }

    private void markTxnCleanupReplicated(UUID txId, TxState state, TablePartitionId commitPartitionId) {
        long cleanupCompletionTimestamp = System.currentTimeMillis();
        this.txStateVolatileStorage.updateMeta(txId, oldMeta -> new TxStateMeta(oldMeta == null ? state : oldMeta.txState(), oldMeta == null ? null : oldMeta.txCoordinatorId(), commitPartitionId, oldMeta == null ? null : oldMeta.commitTimestamp(), oldMeta == null ? null : oldMeta.initialVacuumObservationTimestamp(), cleanupCompletionTimestamp));
    }

    public CompletableFuture<Void> cleanup(TablePartitionId commitPartitionId, String node, UUID txId) {
        return this.sendCleanupMessageWithRetries(commitPartitionId, false, null, txId, node, null);
    }

    public CompletableFuture<Void> cleanup(TablePartitionId commitPartitionId, Map<TablePartitionId, String> enlistedPartitions, boolean commit, @Nullable HybridTimestamp commitTimestamp, UUID txId) {
        this.writeIntentsReplicated.put(txId, new CleanupContext(commitPartitionId, enlistedPartitions.keySet(), commit ? TxState.COMMITTED : TxState.ABORTED));
        HashMap<String, Set<TablePartitionId>> partitions = new HashMap<String, Set<TablePartitionId>>();
        enlistedPartitions.forEach((partitionId, nodeId) -> partitions.computeIfAbsent((String)nodeId, node -> new HashSet()).add(partitionId));
        return this.cleanupPartitions(commitPartitionId, partitions, commit, commitTimestamp, txId);
    }

    public CompletableFuture<Void> cleanup(TablePartitionId commitPartitionId, Collection<TablePartitionId> partitionIds, boolean commit, @Nullable HybridTimestamp commitTimestamp, UUID txId) {
        this.writeIntentsReplicated.put(txId, new CleanupContext(commitPartitionId, new HashSet<TablePartitionId>(partitionIds), commit ? TxState.COMMITTED : TxState.ABORTED));
        return this.placementDriverHelper.findPrimaryReplicas(partitionIds).thenCompose(partitionData -> {
            this.cleanupPartitionsWithoutPrimary(commitPartitionId, commit, commitTimestamp, txId, partitionData.partitionsWithoutPrimary);
            return this.cleanupPartitions(commitPartitionId, partitionData.partitionsByNode, commit, commitTimestamp, txId);
        });
    }

    private void cleanupPartitionsWithoutPrimary(TablePartitionId commitPartitionId, boolean commit, @Nullable HybridTimestamp commitTimestamp, UUID txId, Set<TablePartitionId> noPrimaryFound) {
        this.placementDriverHelper.awaitPrimaryReplicas(noPrimaryFound).thenCompose(partitionsByNode -> this.cleanupPartitions(commitPartitionId, (Map<String, Set<TablePartitionId>>)partitionsByNode, commit, commitTimestamp, txId));
    }

    private CompletableFuture<Void> cleanupPartitions(TablePartitionId commitPartitionId, Map<String, Set<TablePartitionId>> partitionsByNode, boolean commit, @Nullable HybridTimestamp commitTimestamp, UUID txId) {
        ArrayList<CompletableFuture<Void>> cleanupFutures = new ArrayList<CompletableFuture<Void>>();
        for (Map.Entry<String, Set<TablePartitionId>> entry : partitionsByNode.entrySet()) {
            String node = entry.getKey();
            Set<TablePartitionId> nodePartitions = entry.getValue();
            cleanupFutures.add(this.sendCleanupMessageWithRetries(commitPartitionId, commit, commitTimestamp, txId, node, nodePartitions));
        }
        return CompletableFuture.allOf(cleanupFutures.toArray(new CompletableFuture[0]));
    }

    private CompletableFuture<Void> sendCleanupMessageWithRetries(TablePartitionId commitPartitionId, boolean commit, @Nullable HybridTimestamp commitTimestamp, UUID txId, String node, @Nullable Collection<TablePartitionId> partitions) {
        return ((CompletableFuture)this.txMessageSender.cleanup(node, partitions, txId, commit, commitTimestamp).handle((networkMessage, throwable) -> {
            if (throwable != null) {
                if (TxManagerImpl.TransactionFailureHandler.isRecoverable(throwable)) {
                    if (partitions == null) {
                        return this.sendCleanupMessageWithRetries(commitPartitionId, commit, commitTimestamp, txId, node, partitions);
                    }
                    return this.cleanup(commitPartitionId, partitions, commit, commitTimestamp, txId);
                }
                return CompletableFuture.failedFuture(throwable);
            }
            return CompletableFutures.nullCompletedFuture();
        })).thenCompose(v -> v);
    }

    private static class CleanupContext {
        private final TablePartitionId commitPartitionId;
        private final Set<TablePartitionId> partitions;
        private final TxState txState;

        private CleanupContext(TablePartitionId commitPartitionId, Set<TablePartitionId> partitions, TxState txState) {
            this.commitPartitionId = commitPartitionId;
            this.partitions = partitions;
            this.txState = txState;
        }
    }
}

