/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.ClusterIdSupplier;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.OutNetworkObject;
import org.apache.ignite.internal.network.handshake.ChannelAlreadyExistsException;
import org.apache.ignite.internal.network.handshake.HandshakeException;
import org.apache.ignite.internal.network.handshake.HandshakeManager;
import org.apache.ignite.internal.network.netty.ChannelCreationListener;
import org.apache.ignite.internal.network.netty.ChannelEventLoopsSource;
import org.apache.ignite.internal.network.netty.ChannelKey;
import org.apache.ignite.internal.network.netty.HandshakeHandler;
import org.apache.ignite.internal.network.netty.MessageHandler;
import org.apache.ignite.internal.network.netty.NettySender;
import org.apache.ignite.internal.network.netty.NettyUtils;
import org.apache.ignite.internal.network.netty.PipelineUtils;
import org.apache.ignite.internal.network.recovery.DescriptorAcquiry;
import org.apache.ignite.internal.network.recovery.HandshakeManagerUtils;
import org.apache.ignite.internal.network.recovery.RecoveryDescriptor;
import org.apache.ignite.internal.network.recovery.RecoveryDescriptorProvider;
import org.apache.ignite.internal.network.recovery.StaleIdDetector;
import org.apache.ignite.internal.network.recovery.message.HandshakeFinishMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeRejectedMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeRejectionReason;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessage;
import org.apache.ignite.internal.network.recovery.message.ProbeMessage;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class RecoveryClientHandshakeManager
implements HandshakeManager {
    private static final IgniteLogger LOG = Loggers.forClass(RecoveryClientHandshakeManager.class);
    private static final NetworkMessagesFactory MESSAGE_FACTORY = new NetworkMessagesFactory();
    private final ClusterNode localNode;
    private final RecoveryDescriptorProvider recoveryDescriptorProvider;
    private final ChannelEventLoopsSource channelEventLoopsSource;
    private final StaleIdDetector staleIdDetector;
    private final ClusterIdSupplier clusterIdSupplier;
    private final BooleanSupplier stopping;
    private final short connectionId;
    private final CompletableFuture<NettySender> localHandshakeCompleteFuture = new CompletableFuture();
    private final CompletableFuture<CompletionStage<NettySender>> masterHandshakeCompleteFuture = new CompletableFuture();
    private ClusterNode remoteNode;
    private ChannelHandlerContext ctx;
    private Channel channel;
    private HandshakeHandler handler;
    private RecoveryDescriptor recoveryDescriptor;
    private final FailureManager failureManager;

    public RecoveryClientHandshakeManager(ClusterNode localNode, short connectionId, RecoveryDescriptorProvider recoveryDescriptorProvider, ChannelEventLoopsSource channelEventLoopsSource, StaleIdDetector staleIdDetector, ClusterIdSupplier clusterIdSupplier, ChannelCreationListener channelCreationListener, BooleanSupplier stopping, FailureManager failureManager) {
        this.localNode = localNode;
        this.connectionId = connectionId;
        this.recoveryDescriptorProvider = recoveryDescriptorProvider;
        this.channelEventLoopsSource = channelEventLoopsSource;
        this.staleIdDetector = staleIdDetector;
        this.clusterIdSupplier = clusterIdSupplier;
        this.stopping = stopping;
        this.failureManager = failureManager;
        this.localHandshakeCompleteFuture.whenComplete((nettySender, throwable) -> {
            if (throwable != null) {
                this.releaseResources();
                this.masterHandshakeCompleteFuture.complete(this.localHandshakeCompleteFuture);
                return;
            }
            channelCreationListener.handshakeFinished((NettySender)nettySender);
        });
    }

    private void releaseResources() {
        assert (this.ctx.executor().inEventLoop()) : "Release resources called outside of event loop";
        RecoveryDescriptor desc = this.recoveryDescriptor;
        if (desc != null) {
            desc.release(this.ctx);
        }
    }

    @Override
    public void onInit(ChannelHandlerContext handlerContext) {
        this.ctx = handlerContext;
        this.channel = handlerContext.channel();
        this.handler = (HandshakeHandler)this.ctx.handler();
    }

    @Override
    public void onConnectionOpen() {
        this.sendProbeToServer();
    }

    private void sendProbeToServer() {
        ProbeMessage probe = MESSAGE_FACTORY.probeMessage().build();
        NettyUtils.toCompletableFuture(this.channel.writeAndFlush((Object)new OutNetworkObject(probe, List.of(), false))).whenComplete((res, ex) -> {
            if (ex != null) {
                if (ex instanceof IOException) {
                    LOG.debug("Could not send a probe message via {}", ex, new Object[]{this.channel});
                } else {
                    LOG.info("Could not send a probe message via {}", ex, new Object[]{this.channel});
                }
            }
        });
    }

    @Override
    public void onMessage(NetworkMessage message) {
        if (message instanceof HandshakeRejectedMessage) {
            this.onHandshakeRejectedMessage((HandshakeRejectedMessage)message);
            return;
        }
        if (message instanceof HandshakeStartMessage) {
            this.onHandshakeStartMessage((HandshakeStartMessage)message);
            return;
        }
        assert (this.recoveryDescriptor != null) : "Wrong client handshake flow, message is " + String.valueOf(message);
        assert (this.recoveryDescriptor.holderChannel() == this.channel) : "Expected " + String.valueOf(this.channel) + " but was " + String.valueOf(this.recoveryDescriptor.holderChannel()) + ", message is " + String.valueOf(message);
        if (message instanceof HandshakeFinishMessage) {
            HandshakeFinishMessage msg = (HandshakeFinishMessage)message;
            long receivedCount = msg.receivedCount();
            this.recoveryDescriptor.acknowledge(receivedCount);
            if (this.recoveryDescriptor.unacknowledgedCount() == 0) {
                this.finishHandshake();
                return;
            }
            List<OutNetworkObject> networkMessages = this.recoveryDescriptor.unacknowledgedMessages();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resending on handshake: {}", new Object[]{networkMessages.stream().map(OutNetworkObject::networkMessage).collect(Collectors.toList())});
            }
            for (OutNetworkObject networkMessage : networkMessages) {
                this.channel.write((Object)networkMessage);
            }
            this.channel.flush();
            return;
        }
        assert (this.recoveryDescriptor.holderChannel() == this.channel) : "Expected " + String.valueOf(this.channel) + " but was " + String.valueOf(this.recoveryDescriptor.holderChannel()) + ", message is " + String.valueOf(message);
        if (this.recoveryDescriptor.unacknowledgedCount() == 0) {
            this.finishHandshake();
        }
        this.ctx.fireChannelRead((Object)message);
    }

    private void onHandshakeStartMessage(HandshakeStartMessage handshakeStartMessage) {
        if (this.possiblyRejectHandshakeStart(handshakeStartMessage)) {
            return;
        }
        this.remoteNode = handshakeStartMessage.serverNode().asClusterNode();
        ChannelKey channelKey = new ChannelKey(this.remoteNode.name(), this.remoteNode.id(), this.connectionId);
        HandshakeManagerUtils.switchEventLoopIfNeeded(this.channel, channelKey, this.channelEventLoopsSource, () -> this.proceedAfterSavingIds(handshakeStartMessage));
    }

    private void proceedAfterSavingIds(HandshakeStartMessage handshakeStartMessage) {
        RecoveryDescriptor descriptor = this.recoveryDescriptorProvider.getRecoveryDescriptor(this.remoteNode.name(), this.remoteNode.id(), this.connectionId);
        while (!descriptor.tryAcquire(this.ctx, this.localHandshakeCompleteFuture)) {
            DescriptorAcquiry competitorAcquiry;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to acquire recovery descriptor during handshake, it is held by: {}.", new Object[]{descriptor.holderDescription()});
            }
            if ((competitorAcquiry = descriptor.holder()) == null) continue;
            this.completeMasterFutureWithCompetitorHandshakeFuture(competitorAcquiry);
            return;
        }
        if (this.possiblyRejectHandshakeStart(handshakeStartMessage)) {
            descriptor.release(this.ctx);
            return;
        }
        this.recoveryDescriptor = descriptor;
        this.handshake(this.recoveryDescriptor);
    }

    private boolean possiblyRejectHandshakeStart(HandshakeStartMessage message) {
        if (this.staleIdDetector.isIdStale(message.serverNode().id())) {
            this.handleStaleServerId(message);
            return true;
        }
        if (RecoveryClientHandshakeManager.clusterIdMismatch(message.serverClusterId(), this.clusterIdSupplier.clusterId())) {
            this.handleClusterIdMismatch(message);
            return true;
        }
        if (this.stopping.getAsBoolean()) {
            this.handleRefusalToEstablishConnectionDueToStopping(message);
            return true;
        }
        return false;
    }

    private void completeMasterFutureWithCompetitorHandshakeFuture(DescriptorAcquiry competitorAcquiry) {
        this.masterHandshakeCompleteFuture.complete(competitorAcquiry.handshakeCompleteFuture());
        this.localHandshakeCompleteFuture.completeExceptionally(new HandshakeException("Stepping aside to allow an incoming handshake from " + this.remoteNode.name() + " to finish."));
    }

    private static boolean clusterIdMismatch(@Nullable UUID serverClusterId, @Nullable UUID clientClusterId) {
        return serverClusterId != null && clientClusterId != null && !serverClusterId.equals(clientClusterId);
    }

    private void handleStaleServerId(HandshakeStartMessage msg) {
        String message = msg.serverNode().name() + ":" + String.valueOf(msg.serverNode().id()) + " is stale, server should be restarted so that clients can connect";
        this.sendRejectionMessageAndFailHandshake(message, HandshakeRejectionReason.STALE_LAUNCH_ID, HandshakeException::new);
    }

    private void handleClusterIdMismatch(HandshakeStartMessage msg) {
        String message = msg.serverNode().name() + ":" + String.valueOf(msg.serverNode().id()) + " belongs to cluster " + String.valueOf(msg.serverClusterId()) + " which is different from this one " + String.valueOf(this.clusterIdSupplier.clusterId()) + ", connection rejected; should CMG/MG repair be finished?";
        this.sendRejectionMessageAndFailHandshake(message, HandshakeRejectionReason.CLUSTER_ID_MISMATCH, HandshakeException::new);
    }

    private void handleRefusalToEstablishConnectionDueToStopping(HandshakeStartMessage msg) {
        String message = msg.serverNode().name() + ":" + String.valueOf(msg.serverNode().id()) + " tried to establish a connection with " + this.localNode.name() + ", but it's stopping";
        this.sendRejectionMessageAndFailHandshake(message, HandshakeRejectionReason.STOPPING, m -> new NodeStoppingException());
    }

    private void sendRejectionMessageAndFailHandshake(String message, HandshakeRejectionReason rejectionReason, Function<String, Exception> exceptionFactory) {
        HandshakeManagerUtils.sendRejectionMessageAndFailHandshake(message, rejectionReason, this.channel, this.localHandshakeCompleteFuture, exceptionFactory);
    }

    private void onHandshakeRejectedMessage(HandshakeRejectedMessage msg) {
        boolean ignorable;
        boolean bl = ignorable = this.stopping.getAsBoolean() || !msg.reason().critical();
        if (ignorable) {
            LOG.debug("Handshake rejected by server: {}", new Object[]{msg.message()});
        } else {
            LOG.warn("Handshake rejected by server: {}", new Object[]{msg.message()});
        }
        if (msg.reason() == HandshakeRejectionReason.CLINCH) {
            this.giveUpClinch();
        } else {
            this.localHandshakeCompleteFuture.completeExceptionally(new HandshakeException(msg.message()));
        }
        if (!ignorable) {
            this.failureManager.process(new FailureContext(FailureType.CRITICAL_ERROR, (Throwable)new HandshakeException("Handshake rejected by server: " + msg.message())));
        }
    }

    private void giveUpClinch() {
        RecoveryDescriptor descriptor = this.recoveryDescriptorProvider.getRecoveryDescriptor(this.remoteNode.name(), this.remoteNode.id(), this.connectionId);
        DescriptorAcquiry myAcquiry = descriptor.holder();
        assert (myAcquiry != null);
        assert (myAcquiry.channel() != null);
        assert (myAcquiry.channel() == this.ctx.channel()) : "Expected the descriptor to be held by current channel " + String.valueOf(this.ctx.channel()) + ", but it's held by another channel " + String.valueOf(myAcquiry.channel());
        descriptor.release(this.ctx);
        myAcquiry.markClinchResolved();
        DescriptorAcquiry competitorAcquiry = descriptor.holder();
        if (competitorAcquiry != null) {
            this.completeMasterFutureWithCompetitorHandshakeFuture(competitorAcquiry);
        } else {
            this.localHandshakeCompleteFuture.completeExceptionally(new ChannelAlreadyExistsException(this.remoteNode.name()));
        }
    }

    @Override
    public CompletableFuture<NettySender> localHandshakeFuture() {
        return this.localHandshakeCompleteFuture;
    }

    @Override
    public CompletionStage<NettySender> finalHandshakeFuture() {
        return this.masterHandshakeCompleteFuture.thenCompose(Function.identity());
    }

    private void handshake(RecoveryDescriptor descriptor) {
        PipelineUtils.afterHandshake(this.ctx.pipeline(), descriptor, this.createMessageHandler(), MESSAGE_FACTORY);
        HandshakeStartResponseMessage response = MESSAGE_FACTORY.handshakeStartResponseMessage().clientNode(HandshakeManagerUtils.clusterNodeToMessage(this.localNode)).receivedCount(descriptor.receivedCount()).connectionId(this.connectionId).build();
        ChannelFuture sendFuture = this.ctx.channel().writeAndFlush((Object)new OutNetworkObject(response, Collections.emptyList(), false));
        NettyUtils.toCompletableFuture(sendFuture).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                this.localHandshakeCompleteFuture.completeExceptionally(new HandshakeException("Failed to send handshake response: " + throwable.getMessage(), (Throwable)throwable));
            }
        });
    }

    private MessageHandler createMessageHandler() {
        return this.handler.createMessageHandler(this.remoteNode, this.connectionId);
    }

    protected void finishHandshake() {
        this.ctx.pipeline().remove((ChannelHandler)this.handler);
        this.masterHandshakeCompleteFuture.complete(this.localHandshakeCompleteFuture);
        this.localHandshakeCompleteFuture.complete(new NettySender(this.channel, this.remoteNode.id(), this.remoteNode.name(), this.connectionId, this.recoveryDescriptor));
    }

    @TestOnly
    void setRemoteNode(ClusterNode remoteNode) {
        this.remoteNode = remoteNode;
    }
}

