/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.marshaller.reflection;

import java.util.List;
import org.apache.ignite.internal.marshaller.Marshaller;
import org.apache.ignite.internal.marshaller.MarshallerReader;
import org.apache.ignite.internal.marshaller.MarshallerSchema;
import org.apache.ignite.internal.marshaller.MarshallerWriter;
import org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.marshaller.KvMarshaller;
import org.apache.ignite.internal.schema.marshaller.reflection.ObjectStatistics;
import org.apache.ignite.internal.schema.marshaller.reflection.RowReader;
import org.apache.ignite.internal.schema.marshaller.reflection.RowWriter;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.schema.row.RowAssembler;
import org.apache.ignite.lang.MarshallerException;
import org.apache.ignite.table.mapper.Mapper;
import org.jetbrains.annotations.Nullable;

public class KvMarshallerImpl<K, V>
implements KvMarshaller<K, V> {
    private final SchemaDescriptor schema;
    private final Marshaller keyMarsh;
    private final Marshaller valMarsh;
    private final Class<K> keyClass;
    private final Class<V> valClass;
    private final int[] keyPositions;
    private final int[] valPositions;

    public KvMarshallerImpl(SchemaDescriptor schema, MarshallersProvider marshallers, Mapper<K> keyMapper, Mapper<V> valueMapper) {
        this.schema = schema;
        this.keyClass = keyMapper.targetType();
        this.valClass = valueMapper.targetType();
        MarshallerSchema marshallerSchema = schema.marshallerSchema();
        this.keyMarsh = marshallers.getKeysMarshaller(marshallerSchema, keyMapper, true, false);
        this.valMarsh = marshallers.getValuesMarshaller(marshallerSchema, valueMapper, true, false);
        this.keyPositions = schema.keyColumns().stream().mapToInt(Column::positionInRow).toArray();
        this.valPositions = schema.valueColumns().stream().mapToInt(Column::positionInRow).toArray();
    }

    @Override
    public int schemaVersion() {
        return this.schema.version();
    }

    @Override
    public Row marshal(K key) throws MarshallerException {
        assert (this.keyClass.isInstance(key));
        RowAssembler asm = this.createAssembler(key);
        this.keyMarsh.writeObject(key, (MarshallerWriter)new RowWriter(asm));
        return Row.wrapKeyOnlyBinaryRow(this.schema, asm.build());
    }

    @Override
    public Row marshal(K key, @Nullable V val) throws MarshallerException {
        assert (this.keyClass.isInstance(key));
        assert (val == null || this.valClass.isInstance(val));
        List<Column> columns = this.schema.columns();
        RowAssembler asm = this.createAssembler(key, val);
        RowWriter writer = new RowWriter(asm);
        for (Column column : columns) {
            if (column.positionInKey() >= 0) {
                this.keyMarsh.writeField(key, (MarshallerWriter)writer, column.positionInKey());
                continue;
            }
            this.valMarsh.writeField(val, (MarshallerWriter)writer, column.positionInValue());
        }
        return Row.wrapBinaryRow(this.schema, asm.build());
    }

    @Override
    public K unmarshalKeyOnly(Row row) throws MarshallerException {
        assert (row.elementCount() == this.keyPositions.length) : "Number of key columns does not match";
        Object o = this.keyMarsh.readObject((MarshallerReader)new RowReader(row), null);
        assert (this.keyClass.isInstance(o));
        return (K)o;
    }

    @Override
    public K unmarshalKey(Row row) throws MarshallerException {
        Object o = this.keyMarsh.readObject((MarshallerReader)new RowReader(row, this.keyPositions), null);
        assert (this.keyClass.isInstance(o));
        return (K)o;
    }

    @Override
    @Nullable
    public V unmarshalValue(Row row) throws MarshallerException {
        Object o = this.valMarsh.readObject((MarshallerReader)new RowReader(row, this.valPositions), null);
        assert (o == null || this.valClass.isInstance(o));
        return (V)o;
    }

    @Override
    @Nullable
    public Object value(Object obj, int fldIdx) {
        Column column = this.schema.column(fldIdx);
        return column.positionInKey() >= 0 ? this.keyMarsh.value(obj, column.positionInKey()) : this.valMarsh.value(obj, column.positionInValue());
    }

    private RowAssembler createAssembler(Object key) throws MarshallerException {
        try {
            return ObjectStatistics.createAssembler(this.schema, this.keyMarsh, key);
        }
        catch (Throwable e) {
            throw new MarshallerException(e.getMessage(), e);
        }
    }

    private RowAssembler createAssembler(Object key, @Nullable Object val) throws MarshallerException {
        try {
            return ObjectStatistics.createAssembler(this.schema, this.keyMarsh, this.valMarsh, key, val);
        }
        catch (Throwable e) {
            throw new MarshallerException(e.getMessage(), e);
        }
    }
}

