/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.descriptors.ConsistencyMode;
import org.apache.ignite.internal.catalog.events.AlterZoneEventParameters;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.DropZoneEventParameters;
import org.apache.ignite.internal.causality.RevisionListenerRegistry;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyEventListener;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.configuration.SystemDistributedConfiguration;
import org.apache.ignite.internal.configuration.utils.SystemDistributedConfigurationPropertyHolder;
import org.apache.ignite.internal.distributionzones.DataNodesMapSerializer;
import org.apache.ignite.internal.distributionzones.DistributionZonesUtil;
import org.apache.ignite.internal.distributionzones.LogicalTopologySetSerializer;
import org.apache.ignite.internal.distributionzones.Node;
import org.apache.ignite.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite.internal.distributionzones.NodesAttributesSerializer;
import org.apache.ignite.internal.distributionzones.TopologyAugmentationMapSerializer;
import org.apache.ignite.internal.distributionzones.causalitydatanodes.CausalityDataNodesEngine;
import org.apache.ignite.internal.distributionzones.events.HaZoneTopologyUpdateEvent;
import org.apache.ignite.internal.distributionzones.events.HaZoneTopologyUpdateEventParams;
import org.apache.ignite.internal.distributionzones.rebalance.DistributionZoneRebalanceEngine;
import org.apache.ignite.internal.distributionzones.utils.CatalogAlterZoneEventListener;
import org.apache.ignite.internal.event.AbstractEventProducer;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.event.EventParameters;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.EntryEvent;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.Revisions;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.metastorage.dsl.CompoundCondition;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Iif;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.metastorage.dsl.SimpleCondition;
import org.apache.ignite.internal.metastorage.dsl.StatementResult;
import org.apache.ignite.internal.metastorage.dsl.Statements;
import org.apache.ignite.internal.metastorage.dsl.Update;
import org.apache.ignite.internal.metastorage.exceptions.CompactedException;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.thread.StripedScheduledThreadPoolExecutor;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.TestOnly;

public class DistributionZoneManager
extends AbstractEventProducer<HaZoneTopologyUpdateEvent, HaZoneTopologyUpdateEventParams>
implements IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(DistributionZoneManager.class);
    private final MetaStorageManager metaStorageManager;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final LogicalTopologyService logicalTopologyService;
    private final StripedScheduledThreadPoolExecutor executor;
    private final Map<Integer, ZoneState> zonesState = new ConcurrentHashMap<Integer, ZoneState>();
    private final LogicalTopologyEventListener topologyEventListener = new LogicalTopologyEventListener(){

        public void onNodeJoined(LogicalNode joinedNode, LogicalTopologySnapshot newTopology) {
            DistributionZoneManager.this.updateLogicalTopologyInMetaStorage(newTopology);
        }

        public void onNodeLeft(LogicalNode leftNode, LogicalTopologySnapshot newTopology) {
            DistributionZoneManager.this.updateLogicalTopologyInMetaStorage(newTopology);
        }

        public void onTopologyLeap(LogicalTopologySnapshot newTopology) {
            DistributionZoneManager.this.updateLogicalTopologyInMetaStorage(newTopology);
        }
    };
    private final ConcurrentSkipListMap<Long, Set<NodeWithAttributes>> logicalTopologyByRevision = new ConcurrentSkipListMap();
    private Map<UUID, NodeWithAttributes> nodesAttributes = new ConcurrentHashMap<UUID, NodeWithAttributes>();
    private final WatchListener topologyWatchListener;
    private final DistributionZoneRebalanceEngine rebalanceEngine;
    private final CausalityDataNodesEngine causalityDataNodesEngine;
    private final CatalogManager catalogManager;
    private final ScheduledExecutorService rebalanceScheduler;
    private final SystemDistributedConfigurationPropertyHolder<Integer> partitionDistributionResetTimeoutConfiguration;

    public DistributionZoneManager(String nodeName, RevisionListenerRegistry registry, MetaStorageManager metaStorageManager, LogicalTopologyService logicalTopologyService, CatalogManager catalogManager, ScheduledExecutorService rebalanceScheduler, SystemDistributedConfiguration systemDistributedConfiguration) {
        this.metaStorageManager = metaStorageManager;
        this.logicalTopologyService = logicalTopologyService;
        this.catalogManager = catalogManager;
        this.topologyWatchListener = this.createMetastorageTopologyListener();
        this.rebalanceScheduler = rebalanceScheduler;
        this.executor = DistributionZonesUtil.createZoneManagerExecutor(Math.min(Runtime.getRuntime().availableProcessors() * 3, 20), NamedThreadFactory.create((String)nodeName, (String)"dst-zones-scheduler", (IgniteLogger)LOG));
        this.rebalanceEngine = new DistributionZoneRebalanceEngine(this.busyLock, metaStorageManager, this, catalogManager);
        this.causalityDataNodesEngine = new CausalityDataNodesEngine(this.busyLock, registry, metaStorageManager, this.zonesState, this, catalogManager);
        this.partitionDistributionResetTimeoutConfiguration = new SystemDistributedConfigurationPropertyHolder(systemDistributedConfiguration, this::onUpdatePartitionDistributionResetBusy, "partitionDistributionResetTimeout", (Object)0, Integer::parseInt);
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            this.partitionDistributionResetTimeoutConfiguration.init();
            this.registerCatalogEventListenersOnStartManagerBusy();
            this.logicalTopologyService.addEventListener(this.topologyEventListener);
            this.metaStorageManager.registerPrefixWatch(DistributionZonesUtil.zonesLogicalTopologyPrefix(), this.topologyWatchListener);
            CompletableFuture recoveryFinishFuture = this.metaStorageManager.recoveryFinishedFuture();
            assert (recoveryFinishFuture.isDone());
            long recoveryRevision = ((Revisions)recoveryFinishFuture.join()).revision();
            this.restoreGlobalStateFromLocalMetastorage(recoveryRevision);
            int catalogVersion = this.catalogManager.latestCatalogVersion();
            return CompletableFuture.allOf(this.createOrRestoreZonesStates(recoveryRevision, catalogVersion), this.restoreLogicalTopologyChangeEventAndStartTimers(recoveryRevision, catalogVersion)).thenComposeAsync(notUsed -> this.rebalanceEngine.startAsync(catalogVersion), (Executor)componentContext.executor());
        });
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        this.zonesState.values().forEach(ZoneState::stopTimers);
        this.rebalanceEngine.stop();
        this.logicalTopologyService.removeEventListener(this.topologyEventListener);
        this.metaStorageManager.unregisterWatch(this.topologyWatchListener);
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.executor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.rebalanceScheduler, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Set<String>> dataNodes(long causalityToken, int catalogVersion, int zoneId) {
        return this.causalityDataNodesEngine.dataNodes(causalityToken, catalogVersion, zoneId);
    }

    private CompletableFuture<Void> onUpdateScaleUpBusy(AlterZoneEventParameters parameters) {
        int zoneId = parameters.zoneDescriptor().id();
        int newScaleUp = parameters.zoneDescriptor().dataNodesAutoAdjustScaleUp();
        long causalityToken = parameters.causalityToken();
        if (newScaleUp == 0) {
            return this.saveDataNodesToMetaStorageOnScaleUp(zoneId, causalityToken);
        }
        ZoneState zoneState = this.zonesState.get(zoneId);
        if (newScaleUp != Integer.MAX_VALUE) {
            Optional<Long> highestRevision = zoneState.highestRevision(true);
            assert (highestRevision.isEmpty() || causalityToken >= highestRevision.get()) : IgniteStringFormatter.format((String)"Expected causalityToken that is greater or equal to already seen meta storage events: highestRevision={}, causalityToken={}", (Object[])new Object[]{highestRevision.orElse(null), causalityToken});
            zoneState.rescheduleScaleUp(newScaleUp, () -> this.saveDataNodesToMetaStorageOnScaleUp(zoneId, causalityToken), zoneId);
        } else {
            zoneState.stopScaleUp();
        }
        return CompletableFutures.nullCompletedFuture();
    }

    private void onUpdatePartitionDistributionResetBusy(int partitionDistributionResetTimeoutSeconds, long causalityToken) {
        CompletableFuture recoveryFuture = this.metaStorageManager.recoveryFinishedFuture();
        assert (recoveryFuture.isDone());
        if (((Revisions)recoveryFuture.join()).revision() >= causalityToken) {
            return;
        }
        long updateTimestamp = this.timestampByRevision(causalityToken);
        if (updateTimestamp == -1L) {
            return;
        }
        for (Map.Entry<Integer, ZoneState> zoneStateEntry : this.zonesState.entrySet()) {
            int zoneId = zoneStateEntry.getKey();
            CatalogZoneDescriptor zoneDescriptor = this.catalogManager.zone(zoneId, updateTimestamp);
            if (zoneDescriptor == null || zoneDescriptor.consistencyMode() != ConsistencyMode.HIGH_AVAILABILITY) continue;
            ZoneState zoneState = zoneStateEntry.getValue();
            if (partitionDistributionResetTimeoutSeconds != Integer.MAX_VALUE) {
                Optional<Long> highestRevision = zoneState.highestRevision();
                assert (highestRevision.isEmpty() || causalityToken >= highestRevision.get()) : IgniteStringFormatter.format((String)"Expected causalityToken that is greater or equal to already seen meta storage events: highestRevision={}, causalityToken={}", (Object[])new Object[]{highestRevision.orElse(null), causalityToken});
                zoneState.reschedulePartitionDistributionReset(partitionDistributionResetTimeoutSeconds, () -> this.fireTopologyReduceLocalEvent(causalityToken, zoneId), zoneId);
                continue;
            }
            zoneState.stopPartitionDistributionReset();
        }
    }

    private CompletableFuture<Void> onUpdateScaleDownBusy(AlterZoneEventParameters parameters) {
        int zoneId = parameters.zoneDescriptor().id();
        int newScaleDown = parameters.zoneDescriptor().dataNodesAutoAdjustScaleDown();
        long causalityToken = parameters.causalityToken();
        if (newScaleDown == 0) {
            return this.saveDataNodesToMetaStorageOnScaleDown(zoneId, causalityToken);
        }
        ZoneState zoneState = this.zonesState.get(zoneId);
        if (newScaleDown != Integer.MAX_VALUE) {
            Optional<Long> highestRevision = zoneState.highestRevision(false);
            assert (highestRevision.isEmpty() || causalityToken >= highestRevision.get()) : IgniteStringFormatter.format((String)"Expected causalityToken that is greater or equal to already seen meta storage events: highestRevision={}, causalityToken={}", (Object[])new Object[]{highestRevision.orElse(null), causalityToken});
            zoneState.rescheduleScaleDown(newScaleDown, () -> this.saveDataNodesToMetaStorageOnScaleDown(zoneId, causalityToken), zoneId);
        } else {
            zoneState.stopScaleDown();
        }
        return CompletableFutures.nullCompletedFuture();
    }

    private CompletableFuture<Void> onUpdateFilter(AlterZoneEventParameters parameters) {
        int zoneId = parameters.zoneDescriptor().id();
        long causalityToken = parameters.causalityToken();
        return this.saveDataNodesToMetaStorageOnScaleUp(zoneId, causalityToken);
    }

    private CompletableFuture<Void> restoreZoneStateBusy(CatalogZoneDescriptor zone, long causalityToken) {
        int zoneId = zone.id();
        Entry zoneDataNodesLocalMetaStorage = this.metaStorageManager.getLocally(DistributionZonesUtil.zoneDataNodesKey(zoneId), causalityToken);
        if (zoneDataNodesLocalMetaStorage.value() == null) {
            return this.onCreateZone(zone, causalityToken);
        }
        Entry topologyAugmentationMapLocalMetaStorage = this.metaStorageManager.getLocally(DistributionZonesUtil.zoneTopologyAugmentation(zoneId), causalityToken);
        ConcurrentSkipListMap<Object, Object> topologyAugmentationMap = topologyAugmentationMapLocalMetaStorage.value() == null ? new ConcurrentSkipListMap() : TopologyAugmentationMapSerializer.deserialize(topologyAugmentationMapLocalMetaStorage.value());
        ZoneState zoneState = new ZoneState(this.executor, topologyAugmentationMap);
        ZoneState prevZoneState = this.zonesState.putIfAbsent(zoneId, zoneState);
        assert (prevZoneState == null) : "Zone's state was created twice [zoneId = " + zoneId + "]";
        return CompletableFutures.nullCompletedFuture();
    }

    private CompletableFuture<Void> onCreateZone(CatalogZoneDescriptor zone, long causalityToken) {
        int zoneId = zone.id();
        ConcurrentSkipListMap<Long, Augmentation> topologyAugmentationMap = new ConcurrentSkipListMap<Long, Augmentation>();
        ZoneState zoneState = new ZoneState(this.executor, topologyAugmentationMap);
        ZoneState prevZoneState = this.zonesState.putIfAbsent(zoneId, zoneState);
        assert (prevZoneState == null) : "Zone's state was created twice [zoneId = " + zoneId + "]";
        Set<Node> dataNodes = this.logicalTopology(causalityToken).stream().map(NodeWithAttributes::node).collect(Collectors.toSet());
        this.causalityDataNodesEngine.onCreateZoneState(causalityToken, zone);
        return this.initDataNodesAndTriggerKeysInMetaStorage(zoneId, causalityToken, dataNodes);
    }

    private CompletableFuture<Void> restoreTimers(int catalogVersion) {
        ArrayList futures = new ArrayList();
        for (CatalogZoneDescriptor zone : this.catalogManager.zones(catalogVersion)) {
            ZoneState zoneState = this.zonesState.get(zone.id());
            Optional<Long> maxScaleUpRevisionOptional = zoneState.highestRevision(true);
            Optional<Long> maxScaleDownRevisionOptional = zoneState.highestRevision(false);
            maxScaleUpRevisionOptional.ifPresent(maxScaleUpRevision -> futures.add(this.scheduleTimers(zone, true, false, (long)maxScaleUpRevision)));
            maxScaleDownRevisionOptional.ifPresent(maxScaleDownRevision -> futures.add(this.scheduleTimers(zone, false, true, (long)maxScaleDownRevision)));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> initDataNodesAndTriggerKeysInMetaStorage(int zoneId, long revision, Set<Node> dataNodes) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            CompoundCondition triggerKeyCondition = DistributionZonesUtil.conditionForZoneCreation(zoneId);
            Update dataNodesAndTriggerKeyUpd = DistributionZonesUtil.updateDataNodesAndTriggerKeys(zoneId, revision, DataNodesMapSerializer.serialize(DistributionZonesUtil.toDataNodesMap(dataNodes)));
            Iif iif = Statements.iif((Condition)triggerKeyCondition, (Update)dataNodesAndTriggerKeyUpd, (Update)Operations.ops((Operation[])new Operation[0]).yield(false));
            CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)this.metaStorageManager.invoke(iif).thenApply(StatementResult::getAsBoolean)).whenComplete((invokeResult, e) -> {
                if (e != null) {
                    LOG.error("Failed to update zones' dataNodes value [zoneId = {}, dataNodes = {}, revision = {}]", e, new Object[]{zoneId, dataNodes, revision});
                } else if (invokeResult.booleanValue()) {
                    LOG.info("Update zones' dataNodes value [zoneId = {}, dataNodes = {}, revision = {}]", new Object[]{zoneId, dataNodes, revision});
                } else {
                    LOG.debug("Failed to update zones' dataNodes value [zoneId = {}, dataNodes = {}, revision = {}]", new Object[]{zoneId, dataNodes, revision});
                }
            })).thenCompose(ignored -> CompletableFutures.nullCompletedFuture());
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> removeTriggerKeysAndDataNodes(int zoneId, long revision) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            SimpleCondition triggerKeyCondition = DistributionZonesUtil.conditionForZoneRemoval(zoneId);
            Update removeKeysUpd = DistributionZonesUtil.deleteDataNodesAndTriggerKeys(zoneId, revision);
            Iif iif = Statements.iif((Condition)triggerKeyCondition, (Update)removeKeysUpd, (Update)Operations.ops((Operation[])new Operation[0]).yield(false));
            CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)this.metaStorageManager.invoke(iif).thenApply(StatementResult::getAsBoolean)).whenComplete((invokeResult, e) -> {
                if (e != null) {
                    LOG.error("Failed to delete zone's dataNodes keys [zoneId = {}, revision = {}]", e, new Object[]{zoneId, revision});
                } else if (invokeResult.booleanValue()) {
                    LOG.info("Delete zone's dataNodes keys [zoneId = {}, revision = {}]", new Object[]{zoneId, revision});
                } else {
                    LOG.debug("Failed to delete zone's dataNodes keys [zoneId = {}, revision = {}]", new Object[]{zoneId, revision});
                }
            })).thenCompose(ignored -> CompletableFutures.nullCompletedFuture());
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLogicalTopologyInMetaStorage(LogicalTopologySnapshot newTopology) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            Update update;
            SimpleCondition condition;
            Set logicalTopology = newTopology.nodes();
            if (newTopology.version() == 1L) {
                condition = Conditions.notExists((ByteArray)DistributionZonesUtil.zonesLogicalTopologyVersionKey()).or((Condition)Conditions.value((ByteArray)DistributionZonesUtil.zonesLogicalTopologyClusterIdKey()).ne(ByteUtils.uuidToBytes((UUID)newTopology.clusterId())));
                update = DistributionZonesUtil.updateLogicalTopologyAndVersionAndClusterId(newTopology);
            } else {
                condition = Conditions.value((ByteArray)DistributionZonesUtil.zonesLogicalTopologyVersionKey()).lt(ByteUtils.longToBytesKeepingOrder((long)newTopology.version()));
                update = DistributionZonesUtil.updateLogicalTopologyAndVersion(newTopology);
            }
            Iif iff = Statements.iif((Condition)condition, (Update)update, (Update)Operations.ops((Operation[])new Operation[0]).yield(false));
            this.metaStorageManager.invoke(iff).whenComplete((res, e) -> {
                if (e != null) {
                    LOG.error("Failed to update distribution zones' logical topology and version keys [topology = {}, version = {}]", e, new Object[]{Arrays.toString(logicalTopology.toArray()), newTopology.version()});
                } else if (res.getAsBoolean()) {
                    LOG.info("Distribution zones' logical topology and version keys were updated [topology = {}, version = {}]", new Object[]{Arrays.toString(logicalTopology.toArray()), newTopology.version()});
                } else {
                    LOG.info("Failed to update distribution zones' logical topology and version keys [topology = {}, version = {}]", new Object[]{Arrays.toString(logicalTopology.toArray()), newTopology.version()});
                }
            });
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void restoreGlobalStateFromLocalMetastorage(long recoveryRevision) {
        Entry lastHandledTopologyEntry = this.metaStorageManager.getLocally(DistributionZonesUtil.zonesLastHandledTopology(), recoveryRevision);
        Entry nodeAttributesEntry = this.metaStorageManager.getLocally(DistributionZonesUtil.zonesNodesAttributes(), recoveryRevision);
        if (lastHandledTopologyEntry.value() != null) {
            assert (nodeAttributesEntry.value() != null);
            this.logicalTopologyByRevision.put(recoveryRevision, DistributionZonesUtil.deserializeLogicalTopologySet(lastHandledTopologyEntry.value()));
            this.nodesAttributes = DistributionZonesUtil.deserializeNodesAttributes(nodeAttributesEntry.value());
        }
        assert (lastHandledTopologyEntry.value() == null || this.logicalTopology(recoveryRevision).equals(DistributionZonesUtil.deserializeLogicalTopologySet(lastHandledTopologyEntry.value()))) : "Initial value of logical topology was changed after initialization from the Meta Storage manager.";
        assert (nodeAttributesEntry.value() == null || this.nodesAttributes.equals(DistributionZonesUtil.deserializeNodesAttributes(nodeAttributesEntry.value()))) : "Initial value of nodes' attributes was changed after initialization from the Meta Storage manager.";
    }

    private WatchListener createMetastorageTopologyListener() {
        return evt -> {
            if (!this.busyLock.enterBusy()) {
                return CompletableFuture.failedFuture((Throwable)new NodeStoppingException());
            }
            try {
                assert (evt.entryEvents().size() == 2 || evt.entryEvents().size() == 3) : "Expected an event with logical topology, its version and maybe clusterId entries but was events with keys: " + String.valueOf(evt.entryEvents().stream().map(DistributionZoneManager::entryKeyAsString).collect(Collectors.toList()));
                Set<NodeWithAttributes> newLogicalTopology = null;
                long revision = 0L;
                for (EntryEvent event : evt.entryEvents()) {
                    Entry e = event.newEntry();
                    if (Arrays.equals(e.key(), DistributionZonesUtil.zonesLogicalTopologyVersionKey().bytes())) {
                        revision = e.revision();
                        continue;
                    }
                    if (!Arrays.equals(e.key(), DistributionZonesUtil.zonesLogicalTopologyKey().bytes())) continue;
                    byte[] newLogicalTopologyBytes = e.value();
                    newLogicalTopology = DistributionZonesUtil.deserializeLogicalTopologySet(newLogicalTopologyBytes);
                }
                assert (newLogicalTopology != null) : "The event doesn't contain logical topology";
                assert (revision > 0L) : "The event doesn't contain logical topology version";
                int catalogVersion = this.catalogManager.latestCatalogVersion();
                CompletableFuture<Void> completableFuture = this.onLogicalTopologyUpdate(newLogicalTopology, revision, catalogVersion);
                return completableFuture;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        };
    }

    private static String entryKeyAsString(EntryEvent entry) {
        return entry.newEntry() == null ? "null" : new String(entry.newEntry().key(), StandardCharsets.UTF_8);
    }

    private CompletableFuture<Void> onLogicalTopologyUpdate(Set<NodeWithAttributes> newLogicalTopology, long revision, int catalogVersion) {
        Set<NodeWithAttributes> currentLogicalTopology = this.logicalTopology(revision);
        Set<Node> removedNodes = currentLogicalTopology.stream().filter(node -> !newLogicalTopology.contains(node)).map(NodeWithAttributes::node).collect(Collectors.toSet());
        Set<Node> addedNodes = newLogicalTopology.stream().filter(node -> !currentLogicalTopology.contains(node)).map(NodeWithAttributes::node).collect(Collectors.toSet());
        HashSet<Integer> zoneIds = new HashSet<Integer>();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        this.logicalTopologyByRevision.put(revision, newLogicalTopology);
        for (CatalogZoneDescriptor zone : this.catalogManager.zones(catalogVersion)) {
            int zoneId = zone.id();
            this.updateLocalTopologyAugmentationMap(addedNodes, removedNodes, revision, zoneId);
            futures.add(this.scheduleTimers(zone, !addedNodes.isEmpty(), !removedNodes.isEmpty(), revision));
            zoneIds.add(zone.id());
        }
        newLogicalTopology.forEach(n -> this.nodesAttributes.put(n.nodeId(), (NodeWithAttributes)n));
        futures.add(this.saveRecoverableStateToMetastorage(zoneIds, revision, newLogicalTopology));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private void updateLocalTopologyAugmentationMap(Set<Node> addedNodes, Set<Node> removedNodes, long revision, int zoneId) {
        if (!addedNodes.isEmpty()) {
            this.zonesState.get(zoneId).nodesToAddToDataNodes(addedNodes, revision);
        }
        if (!removedNodes.isEmpty()) {
            this.zonesState.get(zoneId).nodesToRemoveFromDataNodes(removedNodes, revision);
        }
    }

    private CompletableFuture<Void> saveRecoverableStateToMetastorage(Set<Integer> zoneIds, long revision, Set<NodeWithAttributes> newLogicalTopology) {
        Operation[] puts = new Operation[3 + zoneIds.size()];
        puts[0] = Operations.put((ByteArray)DistributionZonesUtil.zonesNodesAttributes(), (byte[])NodesAttributesSerializer.serialize(this.nodesAttributes()));
        puts[1] = Operations.put((ByteArray)DistributionZonesUtil.zonesRecoverableStateRevision(), (byte[])ByteUtils.longToBytesKeepingOrder((long)revision));
        puts[2] = Operations.put((ByteArray)DistributionZonesUtil.zonesLastHandledTopology(), (byte[])LogicalTopologySetSerializer.serialize(newLogicalTopology));
        int i = 3;
        for (Integer zoneId : zoneIds) {
            puts[i++] = Operations.put((ByteArray)DistributionZonesUtil.zoneTopologyAugmentation(zoneId), (byte[])TopologyAugmentationMapSerializer.serialize(this.zonesState.get(zoneId).topologyAugmentationMap()));
        }
        Iif iif = Statements.iif((Condition)DistributionZonesUtil.conditionForRecoverableStateChanges(revision), (Update)Operations.ops((Operation[])puts).yield(true), (Update)Operations.ops((Operation[])new Operation[0]).yield(false));
        return ((CompletableFuture)((CompletableFuture)this.metaStorageManager.invoke(iif).thenApply(StatementResult::getAsBoolean)).whenComplete((invokeResult, e) -> {
            if (e != null) {
                if (!ExceptionUtils.hasCauseOrSuppressed((Throwable)e, (Class[])new Class[]{NodeStoppingException.class})) {
                    LOG.error("Failed to update recoverable state for distribution zone manager [revision = {}]", e, new Object[]{revision});
                }
            } else if (invokeResult.booleanValue()) {
                LOG.info("Update recoverable state for distribution zone manager [revision = {}]", new Object[]{revision});
            } else {
                LOG.debug("Failed to update recoverable states for distribution zone manager [revision = {}]", new Object[]{revision});
            }
        })).thenCompose(ignored -> CompletableFutures.nullCompletedFuture());
    }

    private CompletableFuture<Void> scheduleTimers(CatalogZoneDescriptor zone, boolean nodesAdded, boolean nodesRemoved, long revision) {
        int autoAdjust = zone.dataNodesAutoAdjust();
        int autoAdjustScaleDown = zone.dataNodesAutoAdjustScaleDown();
        int autoAdjustScaleUp = zone.dataNodesAutoAdjustScaleUp();
        int partitionReset = (Integer)this.partitionDistributionResetTimeoutConfiguration.currentValue();
        int zoneId = zone.id();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        if ((nodesAdded || nodesRemoved) && autoAdjust != Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Data nodes auto adjust is not supported.");
        }
        if (nodesAdded) {
            if (autoAdjustScaleUp == 0) {
                futures.add(this.saveDataNodesToMetaStorageOnScaleUp(zoneId, revision));
            }
            if (autoAdjustScaleUp != Integer.MAX_VALUE) {
                this.zonesState.get(zoneId).rescheduleScaleUp(autoAdjustScaleUp, () -> this.saveDataNodesToMetaStorageOnScaleUp(zoneId, revision), zoneId);
            }
        }
        if (nodesRemoved) {
            if (zone.consistencyMode() == ConsistencyMode.HIGH_AVAILABILITY && partitionReset != Integer.MAX_VALUE) {
                this.zonesState.get(zoneId).reschedulePartitionDistributionReset(partitionReset, () -> this.fireTopologyReduceLocalEvent(revision, zoneId), zoneId);
            }
            if (autoAdjustScaleDown == 0) {
                futures.add(this.saveDataNodesToMetaStorageOnScaleDown(zoneId, revision));
            }
            if (autoAdjustScaleDown != Integer.MAX_VALUE) {
                this.zonesState.get(zoneId).rescheduleScaleDown(autoAdjustScaleDown, () -> this.saveDataNodesToMetaStorageOnScaleDown(zoneId, revision), zoneId);
            }
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private long timestampByRevision(long revision) {
        try {
            return this.metaStorageManager.timestampByRevisionLocally(revision).longValue();
        }
        catch (CompactedException e) {
            if (revision > 1L) {
                LOG.warn("Unable to retrieve timestamp by revision because of meta storage compaction, [revision={}].", new Object[]{revision});
            }
            return -1L;
        }
    }

    private void fireTopologyReduceLocalEvent(long revision, int zoneId) {
        this.fireEvent(HaZoneTopologyUpdateEvent.TOPOLOGY_REDUCED, (EventParameters)new HaZoneTopologyUpdateEventParams(zoneId, revision)).exceptionally(th -> {
            LOG.error("Error during the local " + HaZoneTopologyUpdateEvent.TOPOLOGY_REDUCED.name() + " event processing", th);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Void> saveDataNodesToMetaStorageOnScaleUp(int zoneId, long revision) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            ZoneState zoneState = this.zonesState.get(zoneId);
            if (zoneState == null) {
                CompletableFuture completableFuture = CompletableFutures.nullCompletedFuture();
                return completableFuture;
            }
            Set<ByteArray> keysToGetFromMs = Set.of(DistributionZonesUtil.zoneDataNodesKey(zoneId), DistributionZonesUtil.zoneScaleUpChangeTriggerKey(zoneId), DistributionZonesUtil.zoneScaleDownChangeTriggerKey(zoneId));
            CompletionStage completionStage = ((CompletableFuture)this.metaStorageManager.getAll(keysToGetFromMs).thenCompose(values -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                if (values.containsValue(null)) {
                    return CompletableFutures.nullCompletedFuture();
                }
                Map<Node, Integer> dataNodesFromMetaStorage = DistributionZonesUtil.extractDataNodes((Entry)values.get(DistributionZonesUtil.zoneDataNodesKey(zoneId)));
                long scaleUpTriggerRevision = DistributionZonesUtil.extractChangeTriggerRevision((Entry)values.get(DistributionZonesUtil.zoneScaleUpChangeTriggerKey(zoneId)));
                long scaleDownTriggerRevision = DistributionZonesUtil.extractChangeTriggerRevision((Entry)values.get(DistributionZonesUtil.zoneScaleDownChangeTriggerKey(zoneId)));
                if (revision <= scaleUpTriggerRevision) {
                    LOG.debug("Revision of the event is less than the scale up revision from the metastorage [zoneId = {}, revision = {}, scaleUpTriggerRevision = {}]", new Object[]{zoneId, revision, scaleUpTriggerRevision});
                    return CompletableFutures.nullCompletedFuture();
                }
                List<Node> deltaToAdd = zoneState.nodesToBeAddedToDataNodes(scaleUpTriggerRevision, revision);
                HashMap<Node, Integer> newDataNodes = new HashMap<Node, Integer>(dataNodesFromMetaStorage);
                deltaToAdd.forEach(n -> newDataNodes.merge((Node)n, 1, Integer::sum));
                deltaToAdd.forEach(n -> newDataNodes.put((Node)n, (Integer)newDataNodes.remove(n)));
                newDataNodes.entrySet().removeIf(e -> (Integer)e.getValue() == 0);
                Update dataNodesAndTriggerKeyUpd = DistributionZonesUtil.updateDataNodesAndScaleUpTriggerKey(zoneId, revision, DataNodesMapSerializer.serialize(newDataNodes));
                Iif iif = Statements.iif((Condition)DistributionZonesUtil.triggerScaleUpScaleDownKeysCondition(scaleUpTriggerRevision, scaleDownTriggerRevision, zoneId), (Update)dataNodesAndTriggerKeyUpd, (Update)Operations.ops((Operation[])new Operation[0]).yield(false));
                return ((CompletableFuture)this.metaStorageManager.invoke(iif).thenApply(StatementResult::getAsBoolean)).thenCompose(invokeResult -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                    if (!invokeResult.booleanValue()) {
                        LOG.debug("Updating data nodes for a zone after scale up has not succeeded [zoneId = {}, dataNodes = {}, revision = {}]", new Object[]{zoneId, newDataNodes, revision});
                        return this.saveDataNodesToMetaStorageOnScaleUp(zoneId, revision);
                    }
                    LOG.info("Updating data nodes for a zone after scale up has succeeded [zoneId = {}, dataNodes = {}, revision = {}]", new Object[]{zoneId, newDataNodes, revision});
                    zoneState.cleanUp(Math.min(scaleDownTriggerRevision, revision));
                    return CompletableFutures.nullCompletedFuture();
                }));
            }))).whenComplete((v, e) -> {
                if (e != null) {
                    LOG.warn("Failed to update zones' dataNodes value after scale up [zoneId = {}, revision = {}]", e, new Object[]{zoneId, revision});
                }
            });
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Void> saveDataNodesToMetaStorageOnScaleDown(int zoneId, long revision) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            ZoneState zoneState = this.zonesState.get(zoneId);
            if (zoneState == null) {
                CompletableFuture completableFuture = CompletableFutures.nullCompletedFuture();
                return completableFuture;
            }
            Set<ByteArray> keysToGetFromMs = Set.of(DistributionZonesUtil.zoneDataNodesKey(zoneId), DistributionZonesUtil.zoneScaleUpChangeTriggerKey(zoneId), DistributionZonesUtil.zoneScaleDownChangeTriggerKey(zoneId));
            CompletionStage completionStage = ((CompletableFuture)this.metaStorageManager.getAll(keysToGetFromMs).thenCompose(values -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                if (values.containsValue(null)) {
                    return CompletableFutures.nullCompletedFuture();
                }
                Map<Node, Integer> dataNodesFromMetaStorage = DistributionZonesUtil.extractDataNodes((Entry)values.get(DistributionZonesUtil.zoneDataNodesKey(zoneId)));
                long scaleUpTriggerRevision = DistributionZonesUtil.extractChangeTriggerRevision((Entry)values.get(DistributionZonesUtil.zoneScaleUpChangeTriggerKey(zoneId)));
                long scaleDownTriggerRevision = DistributionZonesUtil.extractChangeTriggerRevision((Entry)values.get(DistributionZonesUtil.zoneScaleDownChangeTriggerKey(zoneId)));
                if (revision <= scaleDownTriggerRevision) {
                    LOG.debug("Revision of the event is less than the scale down revision from the metastorage [zoneId = {}, revision = {}, scaleUpTriggerRevision = {}]", new Object[]{zoneId, revision, scaleDownTriggerRevision});
                    return CompletableFutures.nullCompletedFuture();
                }
                List<Node> deltaToRemove = zoneState.nodesToBeRemovedFromDataNodes(scaleDownTriggerRevision, revision);
                HashMap<Node, Integer> newDataNodes = new HashMap<Node, Integer>(dataNodesFromMetaStorage);
                deltaToRemove.forEach(n -> newDataNodes.merge((Node)n, -1, Integer::sum));
                newDataNodes.entrySet().removeIf(e -> (Integer)e.getValue() == 0);
                Update dataNodesAndTriggerKeyUpd = DistributionZonesUtil.updateDataNodesAndScaleDownTriggerKey(zoneId, revision, DataNodesMapSerializer.serialize(newDataNodes));
                Iif iif = Statements.iif((Condition)DistributionZonesUtil.triggerScaleUpScaleDownKeysCondition(scaleUpTriggerRevision, scaleDownTriggerRevision, zoneId), (Update)dataNodesAndTriggerKeyUpd, (Update)Operations.ops((Operation[])new Operation[0]).yield(false));
                return ((CompletableFuture)this.metaStorageManager.invoke(iif).thenApply(StatementResult::getAsBoolean)).thenCompose(invokeResult -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                    if (!invokeResult.booleanValue()) {
                        LOG.debug("Updating data nodes for a zone after scale down has not succeeded [zoneId = {}, dataNodes = {}, revision = {}]", new Object[]{zoneId, newDataNodes, revision});
                        return this.saveDataNodesToMetaStorageOnScaleDown(zoneId, revision);
                    }
                    LOG.info("Updating data nodes for a zone after scale down has succeeded [zoneId = {}, dataNodes = {}, revision = {}]", new Object[]{zoneId, newDataNodes, revision});
                    zoneState.cleanUp(Math.min(scaleUpTriggerRevision, revision));
                    return CompletableFutures.nullCompletedFuture();
                }));
            }))).whenComplete((v, e) -> {
                if (e != null) {
                    LOG.warn("Failed to update zones' dataNodes value after scale down [zoneId = {}]", e, new Object[]{zoneId});
                }
            });
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public Map<UUID, NodeWithAttributes> nodesAttributes() {
        return this.nodesAttributes;
    }

    @TestOnly
    public Map<Integer, ZoneState> zonesState() {
        return this.zonesState;
    }

    public Set<NodeWithAttributes> logicalTopology() {
        return this.logicalTopology(Long.MAX_VALUE);
    }

    public Set<NodeWithAttributes> logicalTopology(long revision) {
        assert (revision >= 0L) : revision;
        Map.Entry<Long, Set<NodeWithAttributes>> entry = this.logicalTopologyByRevision.floorEntry(revision);
        return entry != null ? entry.getValue() : Collections.emptySet();
    }

    private void registerCatalogEventListenersOnStartManagerBusy() {
        this.catalogManager.listen((Event)CatalogEvent.ZONE_CREATE, parameters -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.onCreateZone(parameters.zoneDescriptor(), parameters.causalityToken()).thenApply(ignored -> false)));
        this.catalogManager.listen((Event)CatalogEvent.ZONE_DROP, parameters -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.onDropZoneBusy((DropZoneEventParameters)parameters).thenApply(ignored -> false)));
        this.catalogManager.listen((Event)CatalogEvent.ZONE_ALTER, (EventListener)new ManagerCatalogAlterZoneEventListener());
    }

    private CompletableFuture<Void> createOrRestoreZonesStates(long recoveryRevision, int catalogVersion) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (CatalogZoneDescriptor zone : this.catalogManager.zones(catalogVersion)) {
            futures.add(this.restoreZoneStateBusy(zone, recoveryRevision));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private CompletableFuture<Void> restoreLogicalTopologyChangeEventAndStartTimers(long recoveryRevision, int catalogVersion) {
        Entry topologyEntry = this.metaStorageManager.getLocally(DistributionZonesUtil.zonesLogicalTopologyKey(), recoveryRevision);
        if (topologyEntry.value() != null) {
            Set<NodeWithAttributes> newLogicalTopology = DistributionZonesUtil.deserializeLogicalTopologySet(topologyEntry.value());
            long topologyRevision = topologyEntry.revision();
            Entry lastUpdateRevisionEntry = this.metaStorageManager.getLocally(DistributionZonesUtil.zonesRecoverableStateRevision(), recoveryRevision);
            if (lastUpdateRevisionEntry.value() == null || topologyRevision > ByteUtils.bytesToLongKeepingOrder((byte[])lastUpdateRevisionEntry.value())) {
                return this.onLogicalTopologyUpdate(newLogicalTopology, recoveryRevision, catalogVersion);
            }
            return this.restoreTimers(catalogVersion);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    private CompletableFuture<Void> onDropZoneBusy(DropZoneEventParameters parameters) {
        int zoneId = parameters.zoneId();
        long causalityToken = parameters.causalityToken();
        ZoneState zoneState = this.zonesState.get(zoneId);
        zoneState.stopTimers();
        return this.removeTriggerKeysAndDataNodes(zoneId, causalityToken).thenRun(() -> {
            this.causalityDataNodesEngine.onDelete(causalityToken, zoneId);
            this.zonesState.remove(zoneId);
        });
    }

    public static class ZoneState {
        private ScheduledFuture<?> scaleUpTask;
        private ScheduledFuture<?> scaleDownTask;
        private ScheduledFuture<?> partitionDistributionResetTask;
        private long scaleUpTaskDelay;
        private long scaleDownTaskDelay;
        private long partitionDistributionResetTaskDelay;
        private final ConcurrentSkipListMap<Long, Augmentation> topologyAugmentationMap;
        private final StripedScheduledThreadPoolExecutor executor;

        ZoneState(StripedScheduledThreadPoolExecutor executor) {
            this.executor = executor;
            this.topologyAugmentationMap = new ConcurrentSkipListMap();
        }

        ZoneState(StripedScheduledThreadPoolExecutor executor, ConcurrentSkipListMap<Long, Augmentation> topologyAugmentationMap) {
            this.executor = executor;
            this.topologyAugmentationMap = topologyAugmentationMap;
        }

        public ConcurrentSkipListMap<Long, Augmentation> topologyAugmentationMap() {
            return this.topologyAugmentationMap;
        }

        public synchronized void rescheduleScaleUp(long delay, Runnable runnable, int zoneId) {
            this.stopScaleUp();
            this.scaleUpTask = this.executor.schedule(runnable, delay, TimeUnit.SECONDS, zoneId);
            this.scaleUpTaskDelay = delay;
        }

        public synchronized void rescheduleScaleDown(long delay, Runnable runnable, int zoneId) {
            this.stopScaleDown();
            this.scaleDownTask = this.executor.schedule(runnable, delay, TimeUnit.SECONDS, zoneId);
            this.scaleDownTaskDelay = delay;
        }

        public synchronized void reschedulePartitionDistributionReset(long delay, Runnable runnable, int zoneId) {
            this.stopPartitionDistributionReset();
            this.partitionDistributionResetTask = this.executor.schedule(runnable, delay, TimeUnit.SECONDS, zoneId);
            this.partitionDistributionResetTaskDelay = delay;
        }

        synchronized void stopTimers() {
            if (this.scaleUpTask != null) {
                this.scaleUpTask.cancel(false);
            }
            if (this.scaleDownTask != null) {
                this.scaleDownTask.cancel(false);
            }
            if (this.partitionDistributionResetTask != null) {
                this.partitionDistributionResetTask.cancel(false);
            }
        }

        synchronized void stopScaleUp() {
            if (this.scaleUpTask != null && this.scaleUpTaskDelay > 0L) {
                this.scaleUpTask.cancel(false);
            }
        }

        synchronized void stopScaleDown() {
            if (this.scaleDownTask != null && this.scaleDownTaskDelay > 0L) {
                this.scaleDownTask.cancel(false);
            }
        }

        synchronized void stopPartitionDistributionReset() {
            if (this.partitionDistributionResetTask != null && this.partitionDistributionResetTaskDelay > 0L) {
                this.partitionDistributionResetTask.cancel(false);
            }
        }

        List<Node> nodesToBeAddedToDataNodes(long scaleUpRevision, long revision) {
            return this.accumulateNodes(scaleUpRevision, revision, true);
        }

        List<Node> nodesToBeRemovedFromDataNodes(long scaleDownRevision, long revision) {
            return this.accumulateNodes(scaleDownRevision, revision, false);
        }

        void nodesToAddToDataNodes(Set<Node> nodes, long revision) {
            this.topologyAugmentationMap.put(revision, new Augmentation(nodes, true));
        }

        void nodesToRemoveFromDataNodes(Set<Node> nodes, long revision) {
            this.topologyAugmentationMap.put(revision, new Augmentation(nodes, false));
        }

        private List<Node> accumulateNodes(long fromKey, long toKey, boolean addition) {
            return this.topologyAugmentationMap.subMap((Object)fromKey, false, (Object)toKey, true).values().stream().filter(a -> a.addition == addition).flatMap(a -> a.nodes.stream()).collect(Collectors.toList());
        }

        private void cleanUp(long toKey) {
            this.topologyAugmentationMap.headMap((Object)toKey, true).clear();
        }

        Optional<Long> highestRevision(boolean addition) {
            return this.topologyAugmentationMap().entrySet().stream().filter(e -> ((Augmentation)e.getValue()).addition == addition).max(Map.Entry.comparingByKey()).map(Map.Entry::getKey);
        }

        Optional<Long> highestRevision() {
            return this.topologyAugmentationMap().keySet().stream().max(Comparator.naturalOrder());
        }

        @TestOnly
        public synchronized ScheduledFuture<?> scaleUpTask() {
            return this.scaleUpTask;
        }

        @TestOnly
        public synchronized ScheduledFuture<?> scaleDownTask() {
            return this.scaleDownTask;
        }

        @TestOnly
        public synchronized ScheduledFuture<?> partitionDistributionResetTask() {
            return this.partitionDistributionResetTask;
        }
    }

    private class ManagerCatalogAlterZoneEventListener
    extends CatalogAlterZoneEventListener {
        private ManagerCatalogAlterZoneEventListener() {
            super((CatalogService)DistributionZoneManager.this.catalogManager);
        }

        @Override
        protected CompletableFuture<Void> onAutoAdjustScaleUpUpdate(AlterZoneEventParameters parameters, int oldAutoAdjustScaleUp) {
            return (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)DistributionZoneManager.this.busyLock, () -> DistributionZoneManager.this.onUpdateScaleUpBusy(parameters));
        }

        @Override
        protected CompletableFuture<Void> onAutoAdjustScaleDownUpdate(AlterZoneEventParameters parameters, int oldAutoAdjustScaleDown) {
            return (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)DistributionZoneManager.this.busyLock, () -> DistributionZoneManager.this.onUpdateScaleDownBusy(parameters));
        }

        @Override
        protected CompletableFuture<Void> onFilterUpdate(AlterZoneEventParameters parameters, String oldFilter) {
            return (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)DistributionZoneManager.this.busyLock, () -> DistributionZoneManager.this.onUpdateFilter(parameters));
        }
    }

    public static class Augmentation {
        private final Set<Node> nodes;
        private final boolean addition;

        public Augmentation(Set<Node> nodes, boolean addition) {
            this.nodes = Collections.unmodifiableSet(nodes);
            this.addition = addition;
        }

        public boolean addition() {
            return this.addition;
        }

        public Set<Node> nodes() {
            return this.nodes;
        }
    }
}

