/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.placementdriver.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.placementdriver.message.LeaseGrantedMessage;
import org.apache.ignite.internal.placementdriver.message.LeaseGrantedMessageBuilder;
import org.apache.ignite.internal.placementdriver.message.LeaseGrantedMessageSerializer;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class LeaseGrantedMessageImpl
implements LeaseGrantedMessage,
Cloneable {
    public static final short GROUP_TYPE = 11;
    public static final short TYPE = 0;
    @IgniteToStringInclude
    private final boolean force;
    @IgniteToStringInclude
    private ReplicationGroupId groupId;
    private byte[] groupIdByteArray;
    @IgniteToStringInclude
    private final HybridTimestamp leaseExpirationTime;
    @IgniteToStringInclude
    private final HybridTimestamp leaseStartTime;

    private LeaseGrantedMessageImpl(boolean force, ReplicationGroupId groupId, byte[] groupIdByteArray, HybridTimestamp leaseExpirationTime, HybridTimestamp leaseStartTime) {
        this.force = force;
        if (groupId == null && groupIdByteArray == null) {
            throw new NullPointerException("groupId is not marked @Nullable");
        }
        this.groupId = groupId;
        this.groupIdByteArray = groupIdByteArray;
        this.leaseExpirationTime = leaseExpirationTime;
        this.leaseStartTime = leaseStartTime;
    }

    @Override
    public boolean force() {
        return this.force;
    }

    byte[] groupIdByteArray() {
        return this.groupIdByteArray;
    }

    @Override
    public ReplicationGroupId groupId() {
        return this.groupId;
    }

    @Override
    public HybridTimestamp leaseExpirationTime() {
        return this.leaseExpirationTime;
    }

    @Override
    public HybridTimestamp leaseStartTime() {
        return this.leaseStartTime;
    }

    public MessageSerializer serializer() {
        return LeaseGrantedMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 11;
    }

    public String toString() {
        return S.toString(LeaseGrantedMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LeaseGrantedMessageImpl otherMessage = (LeaseGrantedMessageImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.leaseExpirationTime, otherMessage.leaseExpirationTime) && Objects.equals(this.leaseStartTime, otherMessage.leaseStartTime) && this.force == otherMessage.force;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.force, this.groupId, this.leaseExpirationTime, this.leaseStartTime);
        return result;
    }

    public LeaseGrantedMessageImpl clone() {
        try {
            return (LeaseGrantedMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static LeaseGrantedMessageBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject groupIdByteArraymo = marshaller.marshal((Object)this.groupId);
        usedDescriptors.addAll((IntCollection)groupIdByteArraymo.usedDescriptorIds());
        this.groupIdByteArray = groupIdByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.groupId = (ReplicationGroupId)marshaller.unmarshal(this.groupIdByteArray, descriptorsObj);
        this.groupIdByteArray = null;
    }

    private static class Builder
    implements LeaseGrantedMessageBuilder {
        private boolean force;
        private ReplicationGroupId groupId;
        private byte[] groupIdByteArray;
        private HybridTimestamp leaseExpirationTime;
        private HybridTimestamp leaseStartTime;

        private Builder() {
        }

        @Override
        public LeaseGrantedMessageBuilder force(boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public LeaseGrantedMessageBuilder groupId(ReplicationGroupId groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public LeaseGrantedMessageBuilder groupIdByteArray(byte[] groupIdByteArray) {
            this.groupIdByteArray = groupIdByteArray;
            return this;
        }

        @Override
        public LeaseGrantedMessageBuilder leaseExpirationTime(HybridTimestamp leaseExpirationTime) {
            Objects.requireNonNull(leaseExpirationTime, "leaseExpirationTime is not marked @Nullable");
            this.leaseExpirationTime = leaseExpirationTime;
            return this;
        }

        @Override
        public LeaseGrantedMessageBuilder leaseStartTime(HybridTimestamp leaseStartTime) {
            Objects.requireNonNull(leaseStartTime, "leaseStartTime is not marked @Nullable");
            this.leaseStartTime = leaseStartTime;
            return this;
        }

        @Override
        public boolean force() {
            return this.force;
        }

        @Override
        public ReplicationGroupId groupId() {
            return this.groupId;
        }

        @Override
        public byte[] groupIdByteArray() {
            return this.groupIdByteArray;
        }

        @Override
        public HybridTimestamp leaseExpirationTime() {
            return this.leaseExpirationTime;
        }

        @Override
        public HybridTimestamp leaseStartTime() {
            return this.leaseStartTime;
        }

        @Override
        public LeaseGrantedMessage build() {
            return new LeaseGrantedMessageImpl(this.force, this.groupId, this.groupIdByteArray, Objects.requireNonNull(this.leaseExpirationTime, "leaseExpirationTime is not marked @Nullable"), Objects.requireNonNull(this.leaseStartTime, "leaseStartTime is not marked @Nullable"));
        }
    }
}

