/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.exception.handler.replacement;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.JsonExceptionHandler;
import jakarta.inject.Singleton;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.constants.HttpCode;
import org.apache.ignite.internal.rest.problem.HttpProblemResponse;

@Singleton
@Replaces(value=JsonExceptionHandler.class)
@Requires(classes={JsonProcessingException.class, ExceptionHandler.class})
public class JsonExceptionHandlerReplacement
implements ExceptionHandler<JsonProcessingException, HttpResponse<? extends Problem>> {
    public HttpResponse<? extends Problem> handle(HttpRequest request, JsonProcessingException exception) {
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.BAD_REQUEST).title("Invalid JSON").detail(exception.getMessage()));
    }
}

