/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.configuration.schemas.table;

import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.configuration.validation.Immutable;

/**
 * SQL index configuration.
 */
@Config
public class TableIndexConfigurationSchema {
    /** Index name. */
    @Value
    @Immutable
    public String name;

    /** Index type name. */
    @Value
    public String type;

    /** Has default value flag. */
    @Value(hasDefault = true)
    public boolean uniq = false;

    /** Columns configuration for sorted indexes. */
    @NamedConfigValue
    public IndexColumnConfigurationSchema columns;

    /** Columns names for hash indexes. */
    @Value(hasDefault = true)
    public String[] colNames = new String[0];

    /** Expression for PartialIndex: PARTIAL indexes. */
    @Value(hasDefault = true)
    public String expr = "";

    /** Affinity column names for PrimaryKey. */
    @Value(hasDefault = true)
    public String[] affinityColumns = new String[0];
}
