/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.verify.ValidateIndexesClosure;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskArg;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskResult;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorValidateIndexesTask
extends VisorMultiNodeTask<VisorValidateIndexesTaskArg, VisorValidateIndexesTaskResult, VisorValidateIndexesJobResult> {
    private static final long serialVersionUID = 0L;

    @Nullable
    protected VisorValidateIndexesTaskResult reduce0(List<ComputeJobResult> list) throws IgniteException {
        HashMap<UUID, IgniteException> exceptions = new HashMap<UUID, IgniteException>();
        HashMap<UUID, Object> jobResults = new HashMap<UUID, Object>();
        for (ComputeJobResult res : list) {
            if (res.getException() != null) {
                exceptions.put(res.getNode().id(), res.getException());
                continue;
            }
            jobResults.put(res.getNode().id(), res.getData());
        }
        return new VisorValidateIndexesTaskResult(jobResults, exceptions);
    }

    protected VisorJob<VisorValidateIndexesTaskArg, VisorValidateIndexesJobResult> job(VisorValidateIndexesTaskArg arg) {
        return new VisorValidateIndexesJob(arg, this.debug);
    }

    protected Collection<UUID> jobNodes(VisorTaskArgument<VisorValidateIndexesTaskArg> arg) {
        HashSet nodeIds;
        Collection srvNodes = this.ignite.cluster().forServers().nodes();
        ArrayList<UUID> ret = new ArrayList<UUID>(srvNodes.size());
        VisorValidateIndexesTaskArg taskArg = (VisorValidateIndexesTaskArg)arg.getArgument();
        HashSet hashSet = nodeIds = taskArg.getNodes() != null ? new HashSet(taskArg.getNodes()) : null;
        if (nodeIds == null) {
            for (ClusterNode node : srvNodes) {
                ret.add(node.id());
            }
        } else {
            for (ClusterNode node : srvNodes) {
                if (!nodeIds.contains(node.id())) continue;
                ret.add(node.id());
            }
        }
        return ret;
    }

    private static class VisorValidateIndexesJob
    extends VisorJob<VisorValidateIndexesTaskArg, VisorValidateIndexesJobResult> {
        private static final long serialVersionUID = 0L;

        protected VisorValidateIndexesJob(@Nullable VisorValidateIndexesTaskArg arg, boolean debug) {
            super((Object)arg, debug);
        }

        protected VisorValidateIndexesJobResult run(@Nullable VisorValidateIndexesTaskArg arg) throws IgniteException {
            try {
                ValidateIndexesClosure clo = new ValidateIndexesClosure(arg.getCaches(), arg.getCheckFirst(), arg.getCheckThrough(), arg.\u0441heckCrc(), arg.checkSizes());
                this.ignite.context().resource().injectGeneric((Object)clo);
                return clo.call();
            }
            catch (Exception e) {
                throw new IgniteException((Throwable)e);
            }
        }

        public String toString() {
            return S.toString(VisorValidateIndexesJob.class, (Object)((Object)this));
        }
    }
}

