/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.mvcc.MvccQueryTracker;
import org.apache.ignite.internal.processors.query.h2.H2PooledConnection;
import org.apache.ignite.internal.processors.query.h2.H2QueryInfo;
import org.apache.ignite.internal.processors.query.h2.H2ResultSetIterator;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;

public class H2FieldsIterator
extends H2ResultSetIterator<List<?>> {
    private static final long serialVersionUID = 0L;
    private transient MvccQueryTracker mvccTracker;
    private final H2PooledConnection conn;

    public H2FieldsIterator(ResultSet data, MvccQueryTracker mvccTracker, H2PooledConnection conn, int pageSize, IgniteLogger log, IgniteH2Indexing h2, H2QueryInfo qryInfo) throws IgniteCheckedException {
        super(data, pageSize, log, h2, qryInfo);
        assert (conn != null);
        this.mvccTracker = mvccTracker;
        this.conn = conn;
    }

    @Override
    protected List<?> createRow() {
        ArrayList res = new ArrayList(this.row.length);
        Collections.addAll(res, this.row);
        return res;
    }

    @Override
    public void onClose() throws IgniteCheckedException {
        try {
            super.onClose();
        }
        finally {
            this.conn.close();
            if (this.mvccTracker != null) {
                this.mvccTracker.onDone();
            }
        }
    }
}

