/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cluster.DistributedConfigurationUtils;
import org.apache.ignite.internal.processors.configuration.distributed.DistributePropertyListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedChangeableProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationLifecycleListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedPropertyDispatcher;
import org.apache.ignite.internal.processors.configuration.distributed.SimpleDistributedProperty;
import org.apache.ignite.internal.processors.metastorage.ReadableDistributedMetaStorage;
import org.apache.ignite.internal.util.future.GridFutureAdapter;

public class DistributedSqlConfiguration {
    private static final String PROPERTY_UPDATE_MESSAGE = "SQL parameter '%s' was changed from '%s' to '%s'";
    public static final HashSet<String> DFLT_DISABLED_FUNCS = (HashSet)Arrays.stream(new String[]{"FILE_READ", "FILE_WRITE", "CSVWRITE", "CSVREAD", "MEMORY_FREE", "MEMORY_USED", "LOCK_MODE", "LINK_SCHEMA", "SESSION_ID", "CANCEL_SESSION"}).collect(Collectors.toSet());
    private final SimpleDistributedProperty<HashSet<String>> disabledSqlFuncs = new SimpleDistributedProperty("sql.disabledFunctions");

    public DistributedSqlConfiguration(final GridKernalContext ctx, final IgniteLogger log) {
        ctx.internalSubscriptionProcessor().registerDistributedConfigurationListener(new DistributedConfigurationLifecycleListener(){

            public void onReadyToRegister(DistributedPropertyDispatcher dispatcher) {
                DistributedSqlConfiguration.this.disabledSqlFuncs.addListener(DistributedConfigurationUtils.makeUpdateListener((String)DistributedSqlConfiguration.PROPERTY_UPDATE_MESSAGE, (IgniteLogger)log));
                dispatcher.registerProperties((DistributedChangeableProperty[])new SimpleDistributedProperty[]{DistributedSqlConfiguration.this.disabledSqlFuncs});
            }

            public void onReadyToWrite() {
                if (ReadableDistributedMetaStorage.isSupported((GridKernalContext)ctx)) {
                    DistributedConfigurationUtils.setDefaultValue((DistributedProperty)DistributedSqlConfiguration.this.disabledSqlFuncs, DFLT_DISABLED_FUNCS, (IgniteLogger)log);
                } else {
                    log.warning("Distributed metastorage is not supported. All distributed SQL configuration parameters are unavailable.");
                    DistributedSqlConfiguration.this.disabledSqlFuncs.localUpdate(null);
                }
            }
        });
    }

    public Set<String> disabledFunctions() {
        HashSet<String> ret = (HashSet<String>)this.disabledSqlFuncs.get();
        return ret != null ? ret : DFLT_DISABLED_FUNCS;
    }

    public GridFutureAdapter<?> disabledFunctions(HashSet<String> disabledFuncs) throws IgniteCheckedException {
        return this.disabledSqlFuncs.propagateAsync(disabledFuncs);
    }

    public void listenDisabledFunctions(DistributePropertyListener<HashSet<String>> lsnr) {
        this.disabledSqlFuncs.addListener(lsnr);
    }
}

