/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.RollbackRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryInfoCollection;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheCompoundIdentityFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturnCompletableWrapper;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUpdateTxResult;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridCacheTxRecoveryFuture;
import org.apache.ignite.internal.processors.cache.distributed.GridCacheTxRecoveryRequest;
import org.apache.ignite.internal.processors.cache.distributed.GridCacheTxRecoveryResponse;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxRemoteAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxOnePhaseCommitAckRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxRemote;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridInvokeValue;
import org.apache.ignite.internal.processors.cache.distributed.dht.PartitionUpdateCountersMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxRemote;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.msg.PartitionCountersNeighborcastRequest;
import org.apache.ignite.internal.processors.cache.mvcc.msg.PartitionCountersNeighborcastResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxRemoteEx;
import org.apache.ignite.internal.processors.cache.transactions.PartitionCountersNeighborcastFuture;
import org.apache.ignite.internal.processors.cache.transactions.TxCounters;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.EnlistOperation;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.transactions.IgniteTxHeuristicCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxOptimisticCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFutureCancelledException;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class IgniteTxHandler {
    private IgniteLogger log;
    private final IgniteLogger txPrepareMsgLog;
    private final IgniteLogger txFinishMsgLog;
    private final IgniteLogger txRecoveryMsgLog;
    private GridCacheSharedContext<?, ?> ctx;

    private void processNearTxPrepareRequest(UUID nearNodeId, GridNearTxPrepareRequest req) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.TX_NEAR_PREPARE_REQ, MTC.span()));){
            ClusterNode nearNode;
            if (this.txPrepareMsgLog.isDebugEnabled()) {
                this.txPrepareMsgLog.debug("Received near prepare request [txId=" + req.version() + ", node=" + nearNodeId + ']');
            }
            if ((nearNode = this.ctx.node(nearNodeId)) == null) {
                if (this.txPrepareMsgLog.isDebugEnabled()) {
                    this.txPrepareMsgLog.debug("Received near prepare from node that left grid (will ignore) [txId=" + req.version() + ", node=" + nearNodeId + ']');
                }
                return;
            }
            this.processNearTxPrepareRequest0(nearNode, req);
        }
    }

    private IgniteInternalFuture<GridNearTxPrepareResponse> processNearTxPrepareRequest0(ClusterNode nearNode, GridNearTxPrepareRequest req) {
        IgniteInternalFuture<GridNearTxPrepareResponse> fut;
        if (req.firstClientRequest() && req.allowWaitTopologyFuture()) {
            do {
                if (!this.waitForExchangeFuture(nearNode, req)) continue;
                return new GridFinishedFuture<GridNearTxPrepareResponse>();
            } while ((fut = this.prepareNearTx(nearNode, req)) == null);
        } else {
            fut = this.prepareNearTx(nearNode, req);
        }
        assert (req.txState() != null || fut == null || fut.error() != null || this.ctx.tm().tx(req.version()) == null && this.ctx.tm().nearTx(req.version()) == null);
        return fut;
    }

    public IgniteTxHandler(GridCacheSharedContext ctx) {
        this.ctx = ctx;
        this.log = ctx.logger(IgniteTxHandler.class);
        this.txRecoveryMsgLog = ctx.logger("org.apache.ignite.cache.msg.tx.recovery");
        this.txPrepareMsgLog = ctx.logger("org.apache.ignite.cache.msg.tx.prepare");
        this.txFinishMsgLog = ctx.logger("org.apache.ignite.cache.msg.tx.finish");
        ctx.io().addCacheHandler(0, GridNearTxPrepareRequest.class, new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processNearTxPrepareRequest(nodeId, (GridNearTxPrepareRequest)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridNearTxPrepareResponse.class, new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processNearTxPrepareResponse(nodeId, (GridNearTxPrepareResponse)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridNearTxFinishRequest.class, new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processNearTxFinishRequest(nodeId, (GridNearTxFinishRequest)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridNearTxFinishResponse.class, new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processNearTxFinishResponse(nodeId, (GridNearTxFinishResponse)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridDhtTxPrepareRequest.class, new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processDhtTxPrepareRequest(nodeId, (GridDhtTxPrepareRequest)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridDhtTxPrepareResponse.class, new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processDhtTxPrepareResponse(nodeId, (GridDhtTxPrepareResponse)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridDhtTxFinishRequest.class, new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processDhtTxFinishRequest(nodeId, (GridDhtTxFinishRequest)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridDhtTxOnePhaseCommitAckRequest.class, new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processDhtTxOnePhaseCommitAckRequest(nodeId, (GridDhtTxOnePhaseCommitAckRequest)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridDhtTxFinishResponse.class, new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processDhtTxFinishResponse(nodeId, (GridDhtTxFinishResponse)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridCacheTxRecoveryRequest.class, new CI2<UUID, GridCacheTxRecoveryRequest>(){

            @Override
            public void apply(UUID nodeId, GridCacheTxRecoveryRequest req) {
                IgniteTxHandler.this.processCheckPreparedTxRequest(nodeId, req);
            }
        });
        ctx.io().addCacheHandler(0, GridCacheTxRecoveryResponse.class, new CI2<UUID, GridCacheTxRecoveryResponse>(){

            @Override
            public void apply(UUID nodeId, GridCacheTxRecoveryResponse res) {
                IgniteTxHandler.this.processCheckPreparedTxResponse(nodeId, res);
            }
        });
        ctx.io().addCacheHandler(0, PartitionCountersNeighborcastRequest.class, new CI2<UUID, PartitionCountersNeighborcastRequest>(){

            @Override
            public void apply(UUID nodeId, PartitionCountersNeighborcastRequest req) {
                IgniteTxHandler.this.processPartitionCountersRequest(nodeId, req);
            }
        });
        ctx.io().addCacheHandler(0, PartitionCountersNeighborcastResponse.class, new CI2<UUID, PartitionCountersNeighborcastResponse>(){

            @Override
            public void apply(UUID nodeId, PartitionCountersNeighborcastResponse res) {
                IgniteTxHandler.this.processPartitionCountersResponse(nodeId, res);
            }
        });
    }

    public IgniteInternalFuture<GridNearTxPrepareResponse> prepareColocatedTx(final GridNearTxLocal locTx, final GridNearTxPrepareRequest req) {
        req.txState(locTx.txState());
        IgniteInternalFuture<GridNearTxPrepareResponse> fut = locTx.prepareAsyncLocal(req);
        return fut.chain(new C1<IgniteInternalFuture<GridNearTxPrepareResponse>, GridNearTxPrepareResponse>(){

            @Override
            public GridNearTxPrepareResponse apply(IgniteInternalFuture<GridNearTxPrepareResponse> f) {
                try {
                    return f.get();
                }
                catch (Exception e) {
                    locTx.setRollbackOnly();
                    if (!X.hasCause((Throwable)e, IgniteTxOptimisticCheckedException.class) && !X.hasCause((Throwable)e, IgniteFutureCancelledException.class)) {
                        U.error(IgniteTxHandler.this.log, "Failed to prepare DHT transaction: " + locTx, e);
                    }
                    return new GridNearTxPrepareResponse(req.partition(), req.version(), req.futureId(), req.miniId(), req.version(), req.version(), null, e, null, req.onePhaseCommit(), req.deployInfo() != null);
                }
            }
        });
    }

    private IgniteTxEntry unmarshal(@Nullable Collection<IgniteTxEntry> entries) throws IgniteCheckedException {
        if (entries == null) {
            return null;
        }
        IgniteTxEntry firstEntry = null;
        for (IgniteTxEntry e : entries) {
            e.unmarshal(this.ctx, false, this.ctx.deploy().globalLoader());
            if (firstEntry != null) continue;
            firstEntry = e;
        }
        return firstEntry;
    }

    public IgniteInternalFuture<GridNearTxPrepareResponse> prepareNearTxLocal(GridNearTxLocal originTx, GridNearTxPrepareRequest req) {
        req.cloneEntries();
        return this.prepareNearTx(originTx, this.ctx.localNode(), req);
    }

    @Nullable
    private IgniteInternalFuture<GridNearTxPrepareResponse> prepareNearTx(ClusterNode nearNode, GridNearTxPrepareRequest req) {
        return this.prepareNearTx(null, nearNode, req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private IgniteInternalFuture<GridNearTxPrepareResponse> prepareNearTx(GridNearTxLocal originTx, ClusterNode nearNode, GridNearTxPrepareRequest req) {
        IgniteTxEntry firstEntry;
        try {
            IgniteTxEntry firstWrite = this.unmarshal(req.writes());
            IgniteTxEntry firstRead = this.unmarshal(req.reads());
            firstEntry = firstWrite != null ? firstWrite : firstRead;
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<GridNearTxPrepareResponse>(e);
        }
        GridDhtTxLocal tx = null;
        GridCacheVersion mappedVer = this.ctx.tm().mappedVersion(req.version());
        if (mappedVer != null) {
            tx = (GridDhtTxLocal)this.ctx.tm().tx(mappedVer);
            if (tx == null) {
                U.warn(this.log, "Missing local transaction for mapped near version [nearVer=" + req.version() + ", mappedVer=" + mappedVer + ']');
            } else if (req.concurrency() == TransactionConcurrency.PESSIMISTIC) {
                tx.nearFutureId(req.futureId());
            }
        } else {
            GridDhtPartitionTopology top = null;
            if (req.firstClientRequest()) {
                GridDhtTopologyFuture topFut;
                assert (firstEntry != null) : req;
                assert (req.concurrency() == TransactionConcurrency.OPTIMISTIC) : req;
                assert (nearNode.isClient()) : nearNode;
                top = firstEntry.context().topology();
                top.readLock();
                if (req.allowWaitTopologyFuture() && !(topFut = top.topologyVersionFuture()).isDone()) {
                    top.readUnlock();
                    return null;
                }
            }
            try {
                if (top != null) {
                    boolean retry = false;
                    GridDhtTopologyFuture topFut = top.topologyVersionFuture();
                    if (!req.allowWaitTopologyFuture() && !topFut.isDone()) {
                        retry = true;
                        if (this.txPrepareMsgLog.isDebugEnabled()) {
                            this.txPrepareMsgLog.debug("Topology change is in progress, need remap transaction [txId=" + req.version() + ", node=" + nearNode.id() + ", reqTopVer=" + req.topologyVersion() + ", locTopVer=" + top.readyTopologyVersion() + ", req=" + req + ']');
                        }
                    }
                    if (!retry && this.needRemap(req.topologyVersion(), top.readyTopologyVersion(), req)) {
                        retry = true;
                        if (this.txPrepareMsgLog.isDebugEnabled()) {
                            this.txPrepareMsgLog.debug("Topology version mismatch for near prepare, need remap transaction [txId=" + req.version() + ", node=" + nearNode.id() + ", reqTopVer=" + req.topologyVersion() + ", locTopVer=" + top.readyTopologyVersion() + ", req=" + req + ']');
                        }
                    }
                    if (retry) {
                        GridNearTxPrepareResponse res = new GridNearTxPrepareResponse(req.partition(), req.version(), req.futureId(), req.miniId(), req.version(), req.version(), null, null, top.lastTopologyChangeVersion(), req.onePhaseCommit(), req.deployInfo() != null);
                        try {
                            this.ctx.io().send(nearNode, (GridCacheMessage)res, req.policy());
                            if (this.txPrepareMsgLog.isDebugEnabled()) {
                                this.txPrepareMsgLog.debug("Sent remap response for near prepare [txId=" + req.version() + ", node=" + nearNode.id() + ']');
                            }
                        }
                        catch (ClusterTopologyCheckedException ignored) {
                            if (this.txPrepareMsgLog.isDebugEnabled()) {
                                this.txPrepareMsgLog.debug("Failed to send remap response for near prepare, node failed [txId=" + req.version() + ", node=" + nearNode.id() + ']');
                            }
                        }
                        catch (IgniteCheckedException e) {
                            U.error(this.txPrepareMsgLog, "Failed to send remap response for near prepare [txId=" + req.version() + ", node=" + nearNode.id() + ", req=" + req + ']', e);
                        }
                        GridFinishedFuture<GridNearTxPrepareResponse> gridFinishedFuture = new GridFinishedFuture<GridNearTxPrepareResponse>(res);
                        return gridFinishedFuture;
                    }
                    assert (topFut.isDone());
                }
                tx = new GridDhtTxLocal(this.ctx, req.topologyVersion(), nearNode.id(), req.version(), req.futureId(), req.miniId(), req.threadId(), req.implicitSingle(), req.implicitSingle(), req.system(), req.explicitLock(), req.policy(), req.concurrency(), req.isolation(), req.timeout(), req.isInvalidate(), true, req.onePhaseCommit(), req.txSize(), req.transactionNodes(), req.subjectId(), req.taskNameHash(), req.txLabel(), originTx);
                tx = this.ctx.tm().onCreated(null, tx);
                if (tx != null) {
                    tx.topologyVersion(req.topologyVersion());
                } else {
                    U.warn(this.log, "Failed to create local transaction (was transaction rolled back?) [xid=" + req.version() + ", req=" + req + ']');
                }
            }
            finally {
                if (tx != null) {
                    req.txState(tx.txState());
                }
                if (top != null) {
                    top.readUnlock();
                }
            }
        }
        if (tx != null) {
            req.txState(tx.txState());
            if (req.explicitLock()) {
                tx.explicitLock(true);
            }
            tx.transactionNodes(req.transactionNodes());
            if (req.near()) {
                tx.nearOnOriginatingNode(true);
            }
            if (req.onePhaseCommit()) {
                assert (req.last()) : req;
                tx.onePhaseCommit(true);
            }
            if (req.needReturnValue()) {
                tx.needReturnValue(true);
            }
            IgniteInternalFuture<GridNearTxPrepareResponse> fut = tx.prepareAsync(req);
            if (tx.isRollbackOnly() && !tx.commitOnPrepare() && tx.state() != TransactionState.ROLLED_BACK && tx.state() != TransactionState.ROLLING_BACK) {
                tx.rollbackDhtLocalAsync();
            }
            final GridDhtTxLocal tx0 = tx;
            fut.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> txFut) {
                    block2: {
                        try {
                            txFut.get();
                        }
                        catch (IgniteCheckedException e) {
                            tx0.setRollbackOnly();
                            if (X.hasCause((Throwable)e, IgniteTxOptimisticCheckedException.class) || X.hasCause((Throwable)e, IgniteFutureCancelledException.class) || IgniteTxHandler.this.ctx.kernalContext().isStopping()) break block2;
                            U.error(IgniteTxHandler.this.log, "Failed to prepare DHT transaction: " + tx0, e);
                        }
                    }
                }
            });
            return fut;
        }
        return new GridFinishedFuture<GridNearTxPrepareResponse>((GridNearTxPrepareResponse)null);
    }

    private boolean waitForExchangeFuture(ClusterNode node, GridNearTxPrepareRequest req) {
        assert (req.firstClientRequest()) : req;
        GridDhtPartitionsExchangeFuture topFut = this.ctx.exchange().lastTopologyFuture();
        if (!topFut.isDone()) {
            IgniteThread thread;
            Thread curThread = Thread.currentThread();
            if (curThread instanceof IgniteThread && (thread = (IgniteThread)curThread).cachePoolThread()) {
                this.ctx.time().waitAsync(topFut, req.timeout(), (e, timedOut) -> {
                    if (e != null || timedOut.booleanValue()) {
                        this.sendResponseOnTimeoutOrError((IgniteCheckedException)e, topFut, node, req);
                        return;
                    }
                    this.ctx.kernalContext().closure().runLocalWithThreadPolicy(thread, () -> {
                        try {
                            this.processNearTxPrepareRequest0(node, req);
                        }
                        finally {
                            this.ctx.io().onMessageProcessed(req);
                        }
                    });
                });
                return true;
            }
            try {
                if (req.timeout() > 0L) {
                    topFut.get(req.timeout());
                } else {
                    topFut.get();
                }
            }
            catch (IgniteFutureTimeoutCheckedException e2) {
                this.sendResponseOnTimeoutOrError(null, topFut, node, req);
                return true;
            }
            catch (IgniteCheckedException e3) {
                U.error(this.log, "Topology future failed: " + e3, e3);
            }
        }
        return false;
    }

    private void sendResponseOnTimeoutOrError(@Nullable IgniteCheckedException e, GridDhtTopologyFuture topFut, ClusterNode node, GridNearTxPrepareRequest req) {
        if (e == null) {
            e = new IgniteTxTimeoutCheckedException("Failed to wait topology version for near prepare [txId=" + req.version() + ", topVer=" + topFut.initialVersion() + ", node=" + node.id() + ", req=" + req + ']');
        }
        GridNearTxPrepareResponse res = new GridNearTxPrepareResponse(req.partition(), req.version(), req.futureId(), req.miniId(), req.version(), req.version(), null, e, null, req.onePhaseCommit(), req.deployInfo() != null);
        try {
            this.ctx.io().send(node.id(), (GridCacheMessage)res, req.policy());
        }
        catch (IgniteCheckedException e0) {
            U.error(this.txPrepareMsgLog, "Failed to send wait topology version response for near prepare [txId=" + req.version() + ", topVer=" + topFut.initialVersion() + ", node=" + node.id() + ", req=" + req + ']', e0);
        }
    }

    private boolean needRemap(AffinityTopologyVersion expVer, AffinityTopologyVersion curVer, GridNearTxPrepareRequest req) {
        if (curVer.equals(expVer)) {
            return false;
        }
        AffinityTopologyVersion lastAffChangedTopVer = this.ctx.exchange().lastAffinityChangedTopologyVersion(expVer);
        if (curVer.compareTo(expVer) <= 0 && curVer.compareTo(lastAffChangedTopVer) >= 0) {
            return false;
        }
        for (IgniteTxEntry e : F.concat(false, req.reads(), req.writes())) {
            Collection<ClusterNode> cacheNodes1;
            GridCacheContext<?, ?> ctx = e.context();
            Collection<ClusterNode> cacheNodes0 = ctx.discovery().cacheGroupAffinityNodes(ctx.groupId(), expVer);
            if (!cacheNodes0.equals(cacheNodes1 = ctx.discovery().cacheGroupAffinityNodes(ctx.groupId(), curVer)) || ctx.affinity().affinityTopologyVersion().compareTo(curVer) < 0) {
                return true;
            }
            try {
                List<List<ClusterNode>> aff2;
                List<List<ClusterNode>> aff1 = ctx.affinity().assignments(expVer);
                if (aff1.equals(aff2 = ctx.affinity().assignments(curVer))) continue;
                return true;
            }
            catch (IllegalStateException ignored) {
                return true;
            }
        }
        return false;
    }

    private void processNearTxPrepareResponse(UUID nodeId, GridNearTxPrepareResponse res) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.TX_NEAR_PREPARE_RESP, MTC.span()));){
            GridNearTxPrepareFutureAdapter fut;
            if (this.txPrepareMsgLog.isDebugEnabled()) {
                this.txPrepareMsgLog.debug("Received near prepare response [txId=" + res.version() + ", node=" + nodeId + ']');
            }
            if ((fut = (GridNearTxPrepareFutureAdapter)this.ctx.mvcc().versionedFuture(res.version(), res.futureId())) == null) {
                U.warn(this.log, "Failed to find future for near prepare response [txId=" + res.version() + ", node=" + nodeId + ", res=" + res + ']');
                return;
            }
            IgniteInternalTx tx = fut.tx();
            assert (tx != null);
            res.txState(tx.txState());
            fut.onResult(nodeId, res);
        }
    }

    private void processNearTxFinishResponse(UUID nodeId, GridNearTxFinishResponse res) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.TX_NEAR_FINISH_RESP, MTC.span()));){
            GridNearTxFinishFuture fut;
            if (this.txFinishMsgLog.isDebugEnabled()) {
                this.txFinishMsgLog.debug("Received near finish response [txId=" + res.xid() + ", node=" + nodeId + ']');
            }
            if ((fut = (GridNearTxFinishFuture)this.ctx.mvcc().future(res.futureId())) == null) {
                if (this.txFinishMsgLog.isDebugEnabled()) {
                    this.txFinishMsgLog.debug("Failed to find future for near finish response [txId=" + res.xid() + ", node=" + nodeId + ", res=" + res + ']');
                }
                return;
            }
            fut.onResult(nodeId, res);
        }
    }

    private void processDhtTxPrepareResponse(UUID nodeId, GridDhtTxPrepareResponse res) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.TX_PROCESS_DHT_PREPARE_RESP, MTC.span()));){
            GridDhtTxPrepareFuture fut = (GridDhtTxPrepareFuture)this.ctx.mvcc().versionedFuture(res.version(), res.futureId());
            if (fut == null) {
                if (this.txPrepareMsgLog.isDebugEnabled()) {
                    this.txPrepareMsgLog.debug("Failed to find future for dht prepare response [txId=null, dhtTxId=" + res.version() + ", node=" + nodeId + ", res=" + res + ']');
                }
                return;
            }
            if (this.txPrepareMsgLog.isDebugEnabled()) {
                this.txPrepareMsgLog.debug("Received dht prepare response [txId=" + fut.tx().nearXidVersion() + ", node=" + nodeId + ']');
            }
            GridDhtTxLocalAdapter tx = fut.tx();
            assert (tx != null);
            res.txState(tx.txState());
            fut.onResult(nodeId, res);
        }
    }

    private void processDhtTxFinishResponse(UUID nodeId, GridDhtTxFinishResponse res) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.TX_PROCESS_DHT_FINISH_RESP, MTC.span()));){
            GridCacheCompoundIdentityFuture fut;
            assert (nodeId != null);
            assert (res != null);
            if (res.checkCommitted()) {
                fut = (GridNearTxFinishFuture)this.ctx.mvcc().future(res.futureId());
                if (fut == null) {
                    if (this.txFinishMsgLog.isDebugEnabled()) {
                        this.txFinishMsgLog.debug("Failed to find future for dht finish check committed response [txId=null, dhtTxId=" + res.xid() + ", node=" + nodeId + ", res=" + res + ']');
                    }
                    return;
                }
                if (this.txFinishMsgLog.isDebugEnabled()) {
                    this.txFinishMsgLog.debug("Received dht finish check committed response [txId=" + ((GridNearTxFinishFuture)fut).tx().nearXidVersion() + ", dhtTxId=" + res.xid() + ", node=" + nodeId + ']');
                }
                ((GridNearTxFinishFuture)fut).onResult(nodeId, res);
            } else {
                fut = (GridDhtTxFinishFuture)this.ctx.mvcc().future(res.futureId());
                if (fut == null) {
                    if (this.txFinishMsgLog.isDebugEnabled()) {
                        this.txFinishMsgLog.debug("Failed to find future for dht finish response [txId=null, dhtTxId=" + res.xid() + ", node=" + nodeId + ", res=" + res);
                    }
                    return;
                }
                if (this.txFinishMsgLog.isDebugEnabled()) {
                    this.txFinishMsgLog.debug("Received dht finish response [txId=" + ((GridDhtTxFinishFuture)fut).tx().nearXidVersion() + ", dhtTxId=" + res.xid() + ", node=" + nodeId + ']');
                }
                ((GridDhtTxFinishFuture)fut).onResult(nodeId, res);
            }
        }
    }

    @Nullable
    private IgniteInternalFuture<IgniteInternalTx> processNearTxFinishRequest(UUID nodeId, GridNearTxFinishRequest req) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.TX_NEAR_FINISH_REQ, MTC.span()));){
            if (this.txFinishMsgLog.isDebugEnabled()) {
                this.txFinishMsgLog.debug("Received near finish request [txId=" + req.version() + ", node=" + nodeId + ']');
            }
            IgniteInternalFuture<IgniteInternalTx> fut = this.finish(nodeId, null, req);
            assert (req.txState() != null || fut == null || fut.error() != null || this.ctx.tm().tx(req.version()) == null && this.ctx.tm().nearTx(req.version()) == null) : "[req=" + req + ", fut=" + fut + "]";
            IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture = fut;
            return igniteInternalFuture;
        }
    }

    @Nullable
    public IgniteInternalFuture<IgniteInternalTx> finish(UUID nodeId, @Nullable GridNearTxLocal locTx, GridNearTxFinishRequest req) {
        assert (nodeId != null);
        assert (req != null);
        if (locTx != null) {
            req.txState(locTx.txState());
        }
        if (!req.commit()) {
            this.ctx.tm().addRolledbackTx(null, req.version());
        }
        if (locTx != null && !locTx.nearLocallyMapped() && !locTx.colocatedLocallyMapped()) {
            return new GridFinishedFuture<IgniteInternalTx>(locTx);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing near tx finish request [nodeId=" + nodeId + ", req=" + req + "]");
        }
        IgniteInternalFuture<IgniteInternalTx> colocatedFinishFut = null;
        if (locTx != null && locTx.colocatedLocallyMapped()) {
            colocatedFinishFut = this.finishColocatedLocal(req.commit(), locTx);
        }
        IgniteInternalFuture<IgniteInternalTx> nearFinishFut = null;
        if (locTx == null || locTx.nearLocallyMapped()) {
            nearFinishFut = this.finishDhtLocal(nodeId, locTx, req);
        }
        if (colocatedFinishFut != null && nearFinishFut != null) {
            GridCompoundFuture res = new GridCompoundFuture();
            res.add(colocatedFinishFut);
            res.add(nearFinishFut);
            res.markInitialized();
            return res;
        }
        if (colocatedFinishFut != null) {
            return colocatedFinishFut;
        }
        return nearFinishFut;
    }

    /*
     * Exception decompiling
     */
    private IgniteInternalFuture<IgniteInternalTx> finishDhtLocal(UUID nodeId, @Nullable GridNearTxLocal locTx, GridNearTxFinishRequest req) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public IgniteInternalFuture<IgniteInternalTx> finishColocatedLocal(boolean commit, GridNearTxLocal tx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processDhtTxPrepareRequest(final UUID nodeId, final GridDhtTxPrepareRequest req) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.TX_PROCESS_DHT_PREPARE_REQ, MTC.span()));){
            GridDhtTxPrepareResponse res;
            if (this.txPrepareMsgLog.isDebugEnabled()) {
                this.txPrepareMsgLog.debug("Received dht prepare request [txId=" + req.nearXidVersion() + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
            }
            assert (nodeId != null);
            assert (req != null);
            assert (req.transactionNodes() != null);
            GridDhtTxRemote dhtTx = null;
            GridDistributedTxRemoteAdapter nearTx = null;
            try {
                List<IgniteTxKey> writesCacheMissed;
                res = new GridDhtTxPrepareResponse(req.partition(), req.version(), req.futureId(), req.miniId(), req.deployInfo() != null);
                nearTx = !F.isEmpty(req.nearWrites()) ? this.startNearRemoteTx(this.ctx.deploy().globalLoader(), nodeId, req) : null;
                dhtTx = this.startRemoteTx(nodeId, req, res);
                if (nearTx != null) {
                    res.nearEvicted(((GridNearTxRemote)nearTx).evicted());
                }
                if ((writesCacheMissed = req.nearWritesCacheMissed()) != null) {
                    Collection<IgniteTxKey> evicted0 = res.nearEvicted();
                    if (evicted0 != null) {
                        writesCacheMissed.addAll(evicted0);
                    }
                    res.nearEvicted(writesCacheMissed);
                }
                if (dhtTx != null) {
                    req.txState(dhtTx.txState());
                } else if (nearTx != null) {
                    req.txState(nearTx.txState());
                }
                if (dhtTx != null && !F.isEmpty(dhtTx.invalidPartitions())) {
                    res.invalidPartitionsByCacheId(dhtTx.invalidPartitions());
                }
                if (req.onePhaseCommit()) {
                    assert (req.last());
                    if (dhtTx != null) {
                        dhtTx.onePhaseCommit(true);
                        dhtTx.needReturnValue(req.needReturnValue());
                        this.finish(dhtTx, req);
                    }
                    if (nearTx != null) {
                        nearTx.onePhaseCommit(true);
                        this.finish(nearTx, req);
                    }
                }
            }
            catch (IgniteCheckedException e) {
                if (e instanceof IgniteTxRollbackCheckedException) {
                    U.error(this.log, "Transaction was rolled back before prepare completed: " + req, e);
                } else if (e instanceof IgniteTxOptimisticCheckedException) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Optimistic failure for remote transaction (will rollback): " + req);
                    }
                } else {
                    U.error(this.log, "Failed to process prepare request: " + req, e);
                }
                if (nearTx != null) {
                    try {
                        nearTx.rollbackRemoteTx();
                    }
                    catch (Throwable e1) {
                        e.addSuppressed(e1);
                    }
                }
                res = new GridDhtTxPrepareResponse(req.partition(), req.version(), req.futureId(), req.miniId(), e, req.deployInfo() != null);
            }
            if (req.onePhaseCommit()) {
                IgniteInternalFuture<IgniteInternalTx> completeFut;
                IgniteInternalFuture<IgniteInternalTx> nearFin;
                IgniteInternalFuture<IgniteInternalTx> dhtFin;
                IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture = dhtTx == null ? null : (dhtFin = dhtTx.done() ? null : dhtTx.finishFuture());
                IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture2 = nearTx == null ? null : (nearFin = nearTx.done() ? null : nearTx.finishFuture());
                if (dhtFin != null && nearFin != null) {
                    GridCompoundFuture<IgniteInternalTx, IgniteInternalTx> fut = new GridCompoundFuture<IgniteInternalTx, IgniteInternalTx>();
                    fut.add(dhtFin);
                    fut.add(nearFin);
                    fut.markInitialized();
                    completeFut = fut;
                } else {
                    IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture3 = completeFut = dhtFin != null ? dhtFin : nearFin;
                }
                if (completeFut != null) {
                    final GridDhtTxPrepareResponse res0 = res;
                    final GridDhtTxRemote dhtTx0 = dhtTx;
                    GridDistributedTxRemoteAdapter nearTx0 = nearTx;
                    completeFut.listen((IgniteInClosure<IgniteInternalFuture<IgniteInternalTx>>)new CI1<IgniteInternalFuture<IgniteInternalTx>>((GridNearTxRemote)nearTx0){
                        final /* synthetic */ GridNearTxRemote val$nearTx0;
                        {
                            this.val$nearTx0 = gridNearTxRemote;
                        }

                        @Override
                        public void apply(IgniteInternalFuture<IgniteInternalTx> fut) {
                            IgniteTxHandler.this.sendReply(nodeId, req, res0, dhtTx0, this.val$nearTx0);
                        }
                    });
                } else {
                    this.sendReply(nodeId, req, res, dhtTx, (GridNearTxRemote)nearTx);
                }
            } else {
                this.sendReply(nodeId, req, res, dhtTx, (GridNearTxRemote)nearTx);
            }
            assert (req.txState() != null || res.error() != null || dhtTx == null && nearTx == null) : req + " tx=" + dhtTx + " nearTx=" + nearTx;
        }
    }

    private void processDhtTxOnePhaseCommitAckRequest(UUID nodeId, GridDhtTxOnePhaseCommitAckRequest req) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.TX_PROCESS_DHT_ONE_PHASE_COMMIT_ACK_REQ, MTC.span()));){
            assert (nodeId != null);
            assert (req != null);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Processing dht tx one phase commit ack request [nodeId=" + nodeId + ", req=" + req + ']');
            }
            for (GridCacheVersion ver : req.versions()) {
                this.ctx.tm().removeTxReturn(ver);
            }
        }
    }

    private void processDhtTxFinishRequest(final UUID nodeId, final GridDhtTxFinishRequest req) {
        try (MTC.TraceSurroundings ignored = MTC.support(this.ctx.kernalContext().tracing().create(SpanType.TX_PROCESS_DHT_FINISH_REQ, MTC.span()));){
            GridCacheVersion nearTxId;
            assert (nodeId != null);
            assert (req != null);
            if (req.checkCommitted()) {
                boolean committed;
                boolean bl = committed = req.waitRemoteTransactions() || !this.ctx.tm().addRolledbackTx(null, req.version());
                if (!committed || req.syncMode() != CacheWriteSynchronizationMode.FULL_SYNC) {
                    this.sendReply(nodeId, req, committed, null);
                } else {
                    IgniteInternalFuture<?> fut = this.ctx.tm().remoteTxFinishFuture(req.version());
                    fut.listen(new CI1<IgniteInternalFuture<?>>(){

                        @Override
                        public void apply(IgniteInternalFuture<?> fut) {
                            IgniteTxHandler.this.sendReply(nodeId, req, true, null);
                        }
                    });
                }
                return;
            }
            if (!req.commit()) {
                this.ctx.tm().addRolledbackTx(null, req.version());
            }
            GridDhtTxRemote dhtTx = (GridDhtTxRemote)this.ctx.tm().tx(req.version());
            GridNearTxRemote nearTx = (GridNearTxRemote)this.ctx.tm().nearTx(req.version());
            IgniteInternalTx anyTx = U.firstNotNull(dhtTx, nearTx);
            GridCacheVersion gridCacheVersion = nearTxId = anyTx != null ? anyTx.nearXidVersion() : null;
            if (this.txFinishMsgLog.isDebugEnabled()) {
                this.txFinishMsgLog.debug("Received dht finish request [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
            }
            if (anyTx == null && req.commit()) {
                this.ctx.tm().addCommittedTx(null, req.version(), null);
            }
            if (dhtTx != null) {
                this.finish(nodeId, dhtTx, req);
            } else {
                try {
                    this.applyPartitionsUpdatesCounters(req.updateCounters(), !req.commit(), false);
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            }
            if (nearTx != null) {
                this.finish(nodeId, nearTx, req);
            }
            if (req.replyRequired()) {
                IgniteInternalFuture<IgniteInternalTx> completeFut;
                IgniteInternalFuture<IgniteInternalTx> nearFin;
                IgniteInternalFuture<IgniteInternalTx> dhtFin;
                IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture = dhtTx == null ? null : (dhtFin = dhtTx.done() ? null : dhtTx.finishFuture());
                IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture2 = nearTx == null ? null : (nearFin = nearTx.done() ? null : nearTx.finishFuture());
                if (dhtFin != null && nearFin != null) {
                    GridCompoundFuture<IgniteInternalTx, IgniteInternalTx> fut = new GridCompoundFuture<IgniteInternalTx, IgniteInternalTx>();
                    fut.add(dhtFin);
                    fut.add(nearFin);
                    fut.markInitialized();
                    completeFut = fut;
                } else {
                    IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture3 = completeFut = dhtFin != null ? dhtFin : nearFin;
                }
                if (completeFut != null) {
                    completeFut.listen((IgniteInClosure<IgniteInternalFuture<IgniteInternalTx>>)new CI1<IgniteInternalFuture<IgniteInternalTx>>(){

                        @Override
                        public void apply(IgniteInternalFuture<IgniteInternalTx> fut) {
                            IgniteTxHandler.this.sendReply(nodeId, req, true, nearTxId);
                        }
                    });
                } else {
                    this.sendReply(nodeId, req, true, nearTxId);
                }
            } else {
                this.sendReply(nodeId, req, true, null);
            }
            assert (req.txState() != null || dhtTx == null && nearTx == null) : req + " tx=" + dhtTx + " nearTx=" + nearTx;
        }
    }

    protected void finish(UUID nodeId, IgniteTxRemoteEx tx, GridDhtTxFinishRequest req) {
        block11: {
            assert (tx != null);
            req.txState(tx.txState());
            try {
                if (req.commit() || req.isSystemInvalidate()) {
                    tx.commitVersion(req.commitVersion());
                    if (req.isInvalidate()) {
                        tx.invalidate(true);
                    }
                    if (req.isSystemInvalidate()) {
                        tx.systemInvalidate(true);
                    }
                    tx.mvccSnapshot(req.mvccSnapshot());
                    tx.doneRemote(req.baseVersion(), null, null, null);
                    tx.commitRemoteTx();
                } else {
                    if (tx.dht() && req.updateCounters() != null) {
                        tx.txCounters(true).updateCounters(req.updateCounters());
                    }
                    tx.doneRemote(req.baseVersion(), null, null, null);
                    tx.mvccSnapshot(req.mvccSnapshot());
                    tx.rollbackRemoteTx();
                }
            }
            catch (IgniteTxHeuristicCheckedException igniteTxHeuristicCheckedException) {
            }
            catch (Throwable e) {
                tx.invalidate(true);
                tx.systemInvalidate(true);
                try {
                    tx.commitRemoteTx();
                }
                catch (IgniteCheckedException ex) {
                    U.error(this.log, "Failed to invalidate transaction: " + tx, ex);
                }
                if (!(e instanceof Error)) break block11;
                throw (Error)e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finish(GridDistributedTxRemoteAdapter tx, GridDhtTxPrepareRequest req) throws IgniteTxHeuristicCheckedException {
        assert (tx != null) : "No transaction for one-phase commit prepare request: " + req;
        try {
            tx.commitVersion(req.writeVersion());
            tx.invalidate(req.isInvalidate());
            tx.mvccSnapshot(req.mvccSnapshot());
            tx.doneRemote(req.version(), null, null, null);
            tx.commitRemoteTx();
        }
        catch (IgniteTxHeuristicCheckedException e) {
            throw e;
        }
        catch (Throwable e) {
            try {
                tx.invalidate(true);
                tx.systemInvalidate(true);
                try {
                    tx.rollbackRemoteTx();
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                }
                tx.logTxFinishErrorSafe(this.log, true, e);
                if (e instanceof Error) {
                    throw (Error)e;
                }
            }
            finally {
                this.ctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            }
        }
    }

    private void sendReply(UUID nodeId, GridDhtTxPrepareRequest req, GridDhtTxPrepareResponse res, GridDhtTxRemote dhtTx, GridNearTxRemote nearTx) {
        block11: {
            try {
                this.ctx.io().send(nodeId, (GridCacheMessage)res, req.policy());
                if (this.txPrepareMsgLog.isDebugEnabled()) {
                    this.txPrepareMsgLog.debug("Sent dht prepare response [txId=" + req.nearXidVersion() + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
                }
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    if (this.txPrepareMsgLog.isDebugEnabled()) {
                        this.txPrepareMsgLog.debug("Failed to send dht prepare response, node left [txId=" + req.nearXidVersion() + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
                    }
                } else {
                    U.warn(this.log, "Failed to send tx response to remote node (will rollback transaction) [txId=" + req.nearXidVersion() + ", dhtTxId=" + req.version() + ", node=" + nodeId + ", err=" + e.getMessage() + ']');
                }
                if (nearTx != null) {
                    try {
                        nearTx.rollbackRemoteTx();
                    }
                    catch (Throwable e1) {
                        e.addSuppressed(e1);
                    }
                }
                if (dhtTx == null) break block11;
                try {
                    dhtTx.rollbackRemoteTx();
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendReply(UUID nodeId, GridDhtTxFinishRequest req, boolean committed, GridCacheVersion nearTxId) {
        if (req.replyRequired() || req.checkCommitted()) {
            GridDhtTxFinishResponse res = new GridDhtTxFinishResponse(req.partition(), req.version(), req.futureId(), req.miniId());
            if (req.checkCommitted()) {
                res.checkCommitted(true);
                if (committed) {
                    if (req.needReturnValue()) {
                        try {
                            GridCacheReturnCompletableWrapper wrapper = this.ctx.tm().getCommittedTxReturn(req.version());
                            if (wrapper != null) {
                                res.returnValue(wrapper.fut().get());
                            } else assert (!this.ctx.discovery().alive(nodeId)) : nodeId;
                        }
                        catch (IgniteCheckedException ignored) {
                            if (this.txFinishMsgLog.isDebugEnabled()) {
                                this.txFinishMsgLog.debug("Failed to gain entry processor return value. [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
                            }
                        }
                    }
                } else {
                    ClusterTopologyCheckedException cause = new ClusterTopologyCheckedException("Primary node left grid.");
                    res.checkCommittedError(new IgniteTxRollbackCheckedException("Failed to commit transaction (transaction has been rolled back on backup node): " + req.version(), cause));
                }
            }
            try {
                this.ctx.io().send(nodeId, (GridCacheMessage)res, req.policy());
                if (!this.txFinishMsgLog.isDebugEnabled()) return;
                this.txFinishMsgLog.debug("Sent dht tx finish response [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", node=" + nodeId + ", checkCommitted=" + req.checkCommitted() + ']');
                return;
            }
            catch (Throwable e) {
                if (this.ctx.discovery().node(nodeId) == null) {
                    if (this.txFinishMsgLog.isDebugEnabled()) {
                        this.txFinishMsgLog.debug("Node left while send dht tx finish response [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
                    }
                } else {
                    U.error(this.log, "Failed to send finish response to node [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", nodeId=" + nodeId + ", res=" + res + ']', e);
                }
                if (!(e instanceof Error)) return;
                throw (Error)e;
            }
        }
        if (!this.txFinishMsgLog.isDebugEnabled()) return;
        this.txFinishMsgLog.debug("Skip send dht tx finish response [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    GridDhtTxRemote startRemoteTx(UUID nodeId, GridDhtTxPrepareRequest req, GridDhtTxPrepareResponse res) throws IgniteCheckedException {
        if (req.queryUpdate() || !F.isEmpty(req.writes())) {
            GridDhtTxRemote tx = (GridDhtTxRemote)this.ctx.tm().tx(req.version());
            if (tx == null) {
                boolean single = req.last() && req.writes().size() == 1;
                tx = new GridDhtTxRemote(this.ctx, req.nearNodeId(), req.futureId(), nodeId, req.topologyVersion(), req.version(), null, req.system(), req.policy(), req.concurrency(), req.isolation(), req.isInvalidate(), req.timeout(), req.writes() != null ? Math.max(req.writes().size(), req.txSize()) : req.txSize(), req.nearXidVersion(), req.transactionNodes(), req.subjectId(), req.taskNameHash(), single, req.storeWriteThrough(), req.txLabel());
                tx.onePhaseCommit(req.onePhaseCommit());
                tx.writeVersion(req.writeVersion());
                tx = this.ctx.tm().onCreated(null, tx);
                if (tx == null || !this.ctx.tm().onStarted(tx)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Attempt to start a completed transaction (will ignore): " + tx);
                    }
                    this.applyPartitionsUpdatesCounters(req.updateCounters(), true, false);
                    return null;
                }
                if (this.ctx.discovery().node(nodeId) == null) {
                    tx.state(TransactionState.ROLLING_BACK);
                    tx.state(TransactionState.ROLLED_BACK);
                    this.ctx.tm().uncommitTx(tx);
                    this.applyPartitionsUpdatesCounters(req.updateCounters(), true, false);
                    return null;
                }
            } else {
                tx.writeVersion(req.writeVersion());
                tx.transactionNodes(req.transactionNodes());
            }
            TxCounters txCounters = null;
            if (req.updateCounters() != null) {
                txCounters = tx.txCounters(true);
                txCounters.updateCounters(req.updateCounters());
            }
            if (!tx.isSystemInvalidate()) {
                int idx = 0;
                for (IgniteTxEntry entry : req.writes()) {
                    block31: {
                        GridCacheContext<?, ?> cacheCtx = entry.context();
                        int part = cacheCtx.affinity().partition(entry.key());
                        GridDhtLocalPartition locPart = cacheCtx.topology().localPartition(part, req.topologyVersion(), false);
                        if (locPart != null && locPart.reserve()) {
                            try {
                                GridCacheEntryEx cached;
                                Long cntr;
                                tx.addWrite(entry, this.ctx.deploy().globalLoader());
                                if (locPart.state() == GridDhtPartitionState.RENTING) continue;
                                if (txCounters != null && (cntr = txCounters.generateNextCounter(entry.cacheId(), part)) != null) {
                                    entry.updateCounter(cntr);
                                }
                                if (GridCacheUtils.isNearEnabled(cacheCtx) && req.invalidateNearEntry(idx)) {
                                    this.invalidateNearEntry(cacheCtx, entry.key(), req.version());
                                }
                                if (req.needPreloadKey(idx)) {
                                    GridCacheEntryInfo info;
                                    cached = entry.cached();
                                    if (cached == null) {
                                        cached = cacheCtx.cache().entryEx(entry.key(), req.topologyVersion());
                                    }
                                    if ((info = cached.info()) != null && !info.isNew() && !info.isDeleted()) {
                                        res.addPreloadEntry(info);
                                    }
                                }
                                if (!cacheCtx.readThroughConfigured() || entry.skipStore() || entry.op() != GridCacheOperation.TRANSFORM || !entry.oldValueOnPrimary() || entry.hasValue()) break block31;
                                while (true) {
                                    try {
                                        CacheObject val;
                                        cached = entry.cached();
                                        if (cached == null) {
                                            cached = cacheCtx.cache().entryEx(entry.key(), req.topologyVersion());
                                            entry.cached(cached);
                                        }
                                        if ((val = cached.innerGet(null, tx, false, false, false, tx.subjectId(), null, tx.resolveTaskName(), null, true)) == null) {
                                            val = cacheCtx.toCacheObject(cacheCtx.store().load(null, entry.key()));
                                        }
                                        if (val != null) {
                                            entry.readValue(val);
                                        }
                                        break block31;
                                    }
                                    catch (GridCacheEntryRemovedException ignored) {
                                        if (this.log.isDebugEnabled()) {
                                            this.log.debug("Got entry removed exception, will retry: " + entry.txKey());
                                        }
                                        entry.cached(cacheCtx.cache().entryEx(entry.key(), req.topologyVersion()));
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (GridDhtInvalidPartitionException e) {
                                tx.addInvalidPartition(cacheCtx.cacheId(), e.partition());
                                tx.clearEntry(entry.txKey());
                                break block31;
                            }
                            finally {
                                locPart.release();
                                continue;
                            }
                        }
                        tx.addInvalidPartition(cacheCtx.cacheId(), part);
                    }
                    ++idx;
                }
            }
            tx.prepareRemoteTx();
            if (req.last()) {
                assert (!F.isEmpty(req.transactionNodes())) : "Received last prepare request with empty transaction nodes: " + req;
                tx.state(TransactionState.PREPARED);
            }
            res.invalidPartitionsByCacheId(tx.invalidPartitions());
            if (!req.queryUpdate() && tx.empty() && req.last()) {
                tx.skipCompletedVersions(req.skipCompletedVersion());
                tx.rollbackRemoteTx();
                return null;
            }
            return tx;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mvccEnlistBatch(GridDhtTxRemote tx, GridCacheContext ctx, EnlistOperation op, List<KeyCacheObject> keys, List<Message> vals, MvccSnapshot snapshot, IgniteUuid futId, int batchNum) throws IgniteCheckedException {
        assert (keys != null && (vals == null || vals.size() == keys.size()));
        assert (tx != null);
        GridDhtCacheAdapter dht = ctx.dht();
        tx.addActiveCache(ctx, false);
        for (int i = 0; i < keys.size(); ++i) {
            KeyCacheObject key = keys.get(i);
            assert (key != null);
            int part = ctx.affinity().partition(key);
            try {
                GridDhtLocalPartition locPart = ctx.topology().localPartition(part, tx.topologyVersion(), false);
                if (locPart != null && locPart.reserve()) {
                    try {
                        GridCacheUpdateTxResult updRes;
                        CacheEntryInfoCollection entries;
                        if (locPart.state() == GridDhtPartitionState.RENTING) {
                            tx.addInvalidPartition(ctx.cacheId(), part);
                            continue;
                        }
                        CacheObject val = null;
                        EntryProcessor<Object, Object, Object> entryProc = null;
                        Object[] invokeArgs = null;
                        boolean needOldVal = tx.txState().useMvccCaching(ctx.cacheId());
                        Message val0 = vals != null ? vals.get(i) : null;
                        CacheEntryInfoCollection cacheEntryInfoCollection = entries = val0 instanceof CacheEntryInfoCollection ? (CacheEntryInfoCollection)val0 : null;
                        if (entries == null && !op.isDeleteOrLock() && !op.isInvoke()) {
                            CacheObject cacheObject = val = val0 instanceof CacheObject ? (CacheObject)val0 : null;
                        }
                        if (entries == null && op.isInvoke()) {
                            assert (val0 instanceof GridInvokeValue);
                            GridInvokeValue invokeVal = (GridInvokeValue)val0;
                            entryProc = invokeVal.entryProcessor();
                            invokeArgs = invokeVal.invokeArgs();
                        }
                        assert (entries != null || entryProc != null || !op.isInvoke()) : "entryProc=" + entryProc + ", op=" + (Object)((Object)op);
                        GridDhtCacheEntry entry = dht.entryExx(key, tx.topologyVersion());
                        block16: while (true) {
                            ctx.shared().database().checkpointReadLock();
                            try {
                                if (entries == null) {
                                    switch (op) {
                                        case DELETE: {
                                            updRes = entry.mvccRemove(tx, ctx.localNodeId(), tx.topologyVersion(), snapshot, false, needOldVal, null, false);
                                            break block16;
                                        }
                                        case INSERT: 
                                        case TRANSFORM: 
                                        case UPSERT: 
                                        case UPDATE: {
                                            updRes = entry.mvccSet(tx, ctx.localNodeId(), val, entryProc, invokeArgs, 0L, tx.topologyVersion(), snapshot, op.cacheOperation(), false, false, needOldVal, null, false, false);
                                            break block16;
                                        }
                                        default: {
                                            throw new IgniteSQLException("Cannot acquire lock for operation [op= " + (Object)((Object)op) + "]Operation is unsupported at the moment ", 1002);
                                        }
                                    }
                                }
                                updRes = entry.mvccUpdateRowsWithPreloadInfo(tx, ctx.localNodeId(), tx.topologyVersion(), entries.infos(), op.cacheOperation(), snapshot, futId, batchNum);
                            }
                            catch (GridCacheEntryRemovedException ignore) {
                                entry = dht.entryExx(key);
                                continue;
                            }
                            finally {
                                ctx.shared().database().checkpointReadUnlock();
                                continue;
                            }
                            break;
                        }
                        if (!updRes.filtered()) {
                            ctx.shared().mvccCaching().addEnlisted(key, updRes.newValue(), 0L, 0L, tx.xidVersion(), updRes.oldValue(), tx.local(), tx.topologyVersion(), snapshot, ctx.cacheId(), tx, futId, batchNum);
                        }
                        if ($assertionsDisabled || updRes.updateFuture() == null) continue;
                        throw new AssertionError((Object)"Entry should not be locked on the backup");
                    }
                    finally {
                        locPart.release();
                    }
                }
                tx.addInvalidPartition(ctx.cacheId(), part);
                continue;
            }
            catch (GridDhtInvalidPartitionException e) {
                tx.addInvalidPartition(ctx.cacheId(), e.partition());
            }
        }
    }

    private void invalidateNearEntry(GridCacheContext cacheCtx, KeyCacheObject key, GridCacheVersion ver) throws IgniteCheckedException {
        GridNearCacheAdapter near = cacheCtx.isNear() ? cacheCtx.near() : cacheCtx.dht().near();
        GridCacheEntryEx nearEntry = near.peekEx(key);
        if (nearEntry != null) {
            nearEntry.invalidate(ver);
        }
    }

    @Nullable
    private GridNearTxRemote startNearRemoteTx(ClassLoader ldr, UUID nodeId, GridDhtTxPrepareRequest req) throws IgniteCheckedException {
        if (!F.isEmpty(req.nearWrites())) {
            GridNearTxRemote tx = (GridNearTxRemote)this.ctx.tm().nearTx(req.version());
            if (tx == null) {
                tx = new GridNearTxRemote(this.ctx, req.topologyVersion(), ldr, nodeId, req.nearNodeId(), req.version(), null, req.system(), req.policy(), req.concurrency(), req.isolation(), req.isInvalidate(), req.timeout(), req.nearWrites(), req.txSize(), req.subjectId(), req.taskNameHash(), req.txLabel());
                tx.writeVersion(req.writeVersion());
                if (!(tx.empty() || (tx = this.ctx.tm().onCreated(null, tx)) != null && this.ctx.tm().onStarted(tx))) {
                    throw new IgniteTxRollbackCheckedException("Attempt to start a completed transaction: " + tx);
                }
            } else {
                tx.addEntries(ldr, req.nearWrites());
            }
            tx.ownedVersions(req.owned());
            tx.prepareRemoteTx();
            if (req.last()) {
                tx.state(TransactionState.PREPARED);
            }
            return tx;
        }
        return null;
    }

    private void processCheckPreparedTxRequest(final UUID nodeId, final GridCacheTxRecoveryRequest req) {
        IgniteInternalFuture<Boolean> fut;
        if (this.txRecoveryMsgLog.isDebugEnabled()) {
            this.txRecoveryMsgLog.debug("Received tx recovery request [txId=" + req.nearXidVersion() + ", node=" + nodeId + ']');
        }
        IgniteInternalFuture<Boolean> igniteInternalFuture = fut = req.nearTxCheck() ? this.ctx.tm().txCommitted(req.nearXidVersion()) : this.ctx.tm().txsPreparedOrCommitted(req.nearXidVersion(), req.transactions());
        if (fut == null || fut.isDone()) {
            boolean prepared;
            try {
                prepared = fut == null ? true : fut.get();
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Check prepared transaction future failed [req=" + req + ']', e);
                prepared = false;
            }
            this.sendCheckPreparedResponse(nodeId, req, prepared);
        } else {
            fut.listen((IgniteInClosure<IgniteInternalFuture<Boolean>>)new CI1<IgniteInternalFuture<Boolean>>(){

                @Override
                public void apply(IgniteInternalFuture<Boolean> fut) {
                    boolean prepared;
                    try {
                        prepared = fut.get();
                    }
                    catch (IgniteCheckedException e) {
                        U.error(IgniteTxHandler.this.log, "Check prepared transaction future failed [req=" + req + ']', e);
                        prepared = false;
                    }
                    IgniteTxHandler.this.sendCheckPreparedResponse(nodeId, req, prepared);
                }
            });
        }
    }

    private void sendCheckPreparedResponse(UUID nodeId, GridCacheTxRecoveryRequest req, boolean prepared) {
        GridCacheTxRecoveryResponse res = new GridCacheTxRecoveryResponse(req.version(), req.futureId(), req.miniId(), prepared, req.deployInfo() != null);
        try {
            this.ctx.io().send(nodeId, (GridCacheMessage)res, req.system() ? (byte)5 : 2);
            if (this.txRecoveryMsgLog.isDebugEnabled()) {
                this.txRecoveryMsgLog.debug("Sent tx recovery response [txId=" + req.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ']');
            }
        }
        catch (ClusterTopologyCheckedException ignored) {
            if (this.txRecoveryMsgLog.isDebugEnabled()) {
                this.txRecoveryMsgLog.debug("Failed to send tx recovery response, node failed [, txId=" + req.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.txRecoveryMsgLog, "Failed to send tx recovery response [txId=" + req.nearXidVersion() + ", node=" + nodeId + ", req=" + req + ", res=" + res + ']', e);
        }
    }

    protected void processCheckPreparedTxResponse(UUID nodeId, GridCacheTxRecoveryResponse res) {
        GridCacheTxRecoveryFuture fut;
        if (this.txRecoveryMsgLog.isInfoEnabled()) {
            this.txRecoveryMsgLog.info("Received tx recovery response [txId=" + res.version() + ", node=" + nodeId + ", res=" + res + ']');
        }
        if ((fut = (GridCacheTxRecoveryFuture)this.ctx.mvcc().future(res.futureId())) == null) {
            if (this.txRecoveryMsgLog.isInfoEnabled()) {
                this.txRecoveryMsgLog.info("Failed to find future for tx recovery response [txId=" + res.version() + ", node=" + nodeId + ", res=" + res + ']');
            }
            return;
        }
        res.txState(fut.tx().txState());
        fut.onResult(nodeId, res);
    }

    private void processPartitionCountersRequest(UUID nodeId, PartitionCountersNeighborcastRequest req) {
        try {
            this.applyPartitionsUpdatesCounters(req.updateCounters(), true, false);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        try {
            this.ctx.io().send(nodeId, (GridCacheMessage)new PartitionCountersNeighborcastResponse(req.futId(), req.topologyVersion()), (byte)2);
        }
        catch (ClusterTopologyCheckedException ignored) {
            if (this.txRecoveryMsgLog.isDebugEnabled()) {
                this.txRecoveryMsgLog.debug("Failed to send partition counters response, node left [node=" + nodeId + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.txRecoveryMsgLog, "Failed to send partition counters response [node=" + nodeId + ']', e);
        }
    }

    private void processPartitionCountersResponse(UUID nodeId, PartitionCountersNeighborcastResponse res) {
        PartitionCountersNeighborcastFuture fut = (PartitionCountersNeighborcastFuture)this.ctx.mvcc().future(res.futId());
        if (fut == null) {
            this.log.warning("Failed to find future for partition counters response [futId=" + res.futId() + ", node=" + nodeId + ']');
            return;
        }
        fut.onResult(nodeId);
    }

    public void applyPartitionsUpdatesCounters(Iterable<PartitionUpdateCountersMessage> counters) throws IgniteCheckedException {
        this.applyPartitionsUpdatesCounters(counters, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyPartitionsUpdatesCounters(Iterable<PartitionUpdateCountersMessage> counters, boolean rollback, boolean rollbackOnPrimary) throws IgniteCheckedException {
        if (counters == null) {
            return;
        }
        WALPointer ptr = null;
        try {
            for (PartitionUpdateCountersMessage counter : counters) {
                GridCacheContext<?, ?> ctx0 = this.ctx.cacheContext(counter.cacheId());
                GridDhtPartitionTopology top = ctx0.topology();
                AffinityTopologyVersion topVer = top.readyTopologyVersion();
                assert (top != null);
                for (int i = 0; i < counter.size(); ++i) {
                    boolean invalid;
                    block19: {
                        invalid = false;
                        try {
                            GridDhtLocalPartition part = top.localPartition(counter.partition(i));
                            if (part != null && part.reserve()) {
                                try {
                                    if (part.state() != GridDhtPartitionState.RENTING) {
                                        long delta;
                                        long start = counter.initialCounter(i);
                                        boolean updated = part.updateCounter(start, delta = counter.updatesCount(i));
                                        if (updated && rollback) {
                                            CacheGroupContext grpCtx = part.group();
                                            if (grpCtx.persistenceEnabled() && grpCtx.walEnabled() && !grpCtx.mvccEnabled()) {
                                                RollbackRecord rec = new RollbackRecord(grpCtx.groupId(), part.id(), start, delta);
                                                ptr = this.ctx.wal().log(rec);
                                            }
                                            int cntr = 1;
                                            while ((long)cntr <= delta) {
                                                ctx0.continuousQueries().skipUpdateCounter(null, part.id(), start + (long)cntr, topVer, rollbackOnPrimary);
                                                ++cntr;
                                            }
                                        }
                                    } else {
                                        invalid = true;
                                    }
                                    break block19;
                                }
                                finally {
                                    part.release();
                                }
                            }
                            invalid = true;
                        }
                        catch (GridDhtInvalidPartitionException e) {
                            invalid = true;
                        }
                    }
                    if (!this.log.isDebugEnabled() || !invalid) continue;
                    this.log.debug("Received partition update counters message for invalid partition, ignoring: [cacheId=" + counter.cacheId() + ", part=" + counter.partition(i) + ']');
                }
            }
        }
        finally {
            if (ptr != null) {
                this.ctx.wal().flush(ptr, false);
            }
        }
    }

    @Nullable
    public List<PartitionUpdateCountersMessage> filterUpdateCountersForBackupNode(IgniteInternalTx tx, ClusterNode node) {
        Collection<PartitionUpdateCountersMessage> updCntrs;
        TxCounters txCntrs = tx.txCounters(false);
        if (txCntrs == null || F.isEmpty(updCntrs = txCntrs.updateCounters())) {
            return null;
        }
        ArrayList<PartitionUpdateCountersMessage> res = new ArrayList<PartitionUpdateCountersMessage>(updCntrs.size());
        AffinityTopologyVersion top = tx.topologyVersionSnapshot();
        for (PartitionUpdateCountersMessage partCntrs : updCntrs) {
            GridDhtPartitionTopology topology = this.ctx.cacheContext(partCntrs.cacheId()).topology();
            PartitionUpdateCountersMessage resCntrs = new PartitionUpdateCountersMessage(partCntrs.cacheId(), partCntrs.size());
            for (int i = 0; i < partCntrs.size(); ++i) {
                int part = partCntrs.partition(i);
                if (topology.nodes(part, top).indexOf(node) <= 0) continue;
                resCntrs.add(part, partCntrs.initialCounter(i), partCntrs.updatesCount(i));
            }
            if (resCntrs.size() <= 0) continue;
            res.add(resCntrs);
        }
        return res;
    }
}

