/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.aware;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentArchivedStorage;

public class SegmentCompressStorage {
    private volatile boolean interrupted;
    private final SegmentArchivedStorage segmentArchivedStorage;
    private final boolean compactionEnabled;
    private volatile long lastCompressedIdx = -1L;
    private long lastEnqueuedToCompressIdx = -1L;
    private final Queue<Long> segmentsToCompress = new ArrayDeque<Long>();
    private final List<Long> compressingSegments = new ArrayList<Long>();
    private long lastMaxCompressedIdx = -1L;
    private volatile long minUncompressedIdxToKeep = -1L;

    private SegmentCompressStorage(SegmentArchivedStorage segmentArchivedStorage, boolean compactionEnabled) {
        this.segmentArchivedStorage = segmentArchivedStorage;
        this.compactionEnabled = compactionEnabled;
    }

    static SegmentCompressStorage buildCompressStorage(SegmentArchivedStorage segmentArchivedStorage, boolean compactionEnabled) {
        SegmentCompressStorage storage = new SegmentCompressStorage(segmentArchivedStorage, compactionEnabled);
        segmentArchivedStorage.addObserver(storage::onSegmentArchived);
        return storage;
    }

    synchronized void onSegmentCompressed(long compressedIdx) {
        if (compressedIdx > this.lastMaxCompressedIdx) {
            this.lastMaxCompressedIdx = compressedIdx;
        }
        this.compressingSegments.remove(compressedIdx);
        this.lastCompressedIdx = !this.compressingSegments.isEmpty() ? Math.min(this.lastMaxCompressedIdx, this.compressingSegments.get(0) - 1L) : this.lastMaxCompressedIdx;
        if (compressedIdx > this.lastEnqueuedToCompressIdx) {
            this.lastEnqueuedToCompressIdx = compressedIdx;
        }
    }

    long lastCompressedIdx() {
        return this.lastCompressedIdx;
    }

    synchronized long nextSegmentToCompressOrWait() throws IgniteInterruptedCheckedException {
        try {
            while (this.segmentsToCompress.peek() == null && !this.interrupted) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedCheckedException(e);
        }
        this.checkInterrupted();
        Long idx = this.segmentsToCompress.poll();
        assert (idx != null);
        this.compressingSegments.add(idx);
        return idx;
    }

    synchronized void interrupt() {
        this.interrupted = true;
        this.notifyAll();
    }

    private void checkInterrupted() throws IgniteInterruptedCheckedException {
        if (this.interrupted) {
            throw new IgniteInterruptedCheckedException("Interrupt waiting of change compressed idx");
        }
    }

    private synchronized void onSegmentArchived(long lastAbsArchivedIdx) {
        while (this.lastEnqueuedToCompressIdx < lastAbsArchivedIdx && this.compactionEnabled) {
            this.segmentsToCompress.add(++this.lastEnqueuedToCompressIdx);
        }
        this.notifyAll();
    }

    void keepUncompressedIdxFrom(long idx) {
        this.minUncompressedIdxToKeep = idx;
    }

    long keepUncompressedIdxFrom() {
        return this.minUncompressedIdxToKeep;
    }

    public void reset() {
        this.interrupted = false;
    }
}

