/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedBaseMessage;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridDistributedLockResponse
extends GridDistributedBaseMessage {
    private static final long serialVersionUID = 0L;
    private IgniteUuid futId;
    @GridDirectTransient
    private Throwable err;
    private byte[] errBytes;
    @GridToStringInclude
    @GridDirectCollection(value=CacheObject.class)
    private List<CacheObject> vals;

    public GridDistributedLockResponse() {
    }

    public GridDistributedLockResponse(int cacheId, GridCacheVersion lockVer, IgniteUuid futId, int cnt, boolean addDepInfo) {
        super(lockVer, cnt, addDepInfo);
        assert (futId != null);
        this.cacheId = cacheId;
        this.futId = futId;
        this.vals = new ArrayList<CacheObject>(cnt);
    }

    public GridDistributedLockResponse(int cacheId, GridCacheVersion lockVer, IgniteUuid futId, Throwable err, boolean addDepInfo) {
        super(lockVer, 0, addDepInfo);
        assert (futId != null);
        this.cacheId = cacheId;
        this.futId = futId;
        this.err = err;
    }

    public GridDistributedLockResponse(int cacheId, GridCacheVersion lockVer, IgniteUuid futId, int cnt, Throwable err, boolean addDepInfo) {
        super(lockVer, cnt, addDepInfo);
        assert (futId != null);
        this.cacheId = cacheId;
        this.futId = futId;
        this.err = err;
        this.vals = new ArrayList<CacheObject>(cnt);
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public Throwable error() {
        return this.err;
    }

    public void error(Throwable err) {
        this.err = err;
    }

    public void addValue(CacheObject val) {
        this.vals.add(val);
    }

    protected int valuesSize() {
        return this.vals.size();
    }

    @Nullable
    public CacheObject value(int idx) {
        if (!F.isEmpty(this.vals)) {
            return this.vals.get(idx);
        }
        return null;
    }

    @Override
    public IgniteLogger messageLogger(GridCacheSharedContext ctx) {
        return ctx.txLockMessageLogger();
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        this.prepareMarshalCacheObjects(this.vals, ctx.cacheContext(this.cacheId));
        if (this.err != null && this.errBytes == null) {
            this.errBytes = U.marshal(ctx.marshaller(), (Object)this.err);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        this.finishUnmarshalCacheObjects(this.vals, ctx.cacheContext(this.cacheId), ldr);
        if (this.errBytes != null) {
            this.err = (Throwable)U.unmarshal(ctx, this.errBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 8: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeCollection("vals", this.vals, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 8: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.vals = (List)reader.readCollection("vals", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDistributedLockResponse.class);
    }

    @Override
    public short directType() {
        return 22;
    }

    @Override
    public byte fieldsCount() {
        return 11;
    }

    @Override
    public String toString() {
        return S.toString(GridDistributedLockResponse.class, this, "super", super.toString());
    }
}

