/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MetaPageUpdateLastAllocatedIndex
extends PageDeltaRecord {
    private final int lastAllocatedIdx;

    public MetaPageUpdateLastAllocatedIndex(int grpId, long pageId, int lastAllocatedIdx) {
        super(grpId, pageId);
        this.lastAllocatedIdx = lastAllocatedIdx;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        int type = PageIO.getType(pageAddr);
        assert (type == 11 || type == 14);
        PageMetaIO io = (PageMetaIO)PageIO.getPageIO(type, PageIO.getVersion(pageAddr));
        io.setLastAllocatedPageCount(pageAddr, this.lastAllocatedIdx);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.META_PAGE_UPDATE_LAST_ALLOCATED_INDEX;
    }

    public int lastAllocatedIndex() {
        return this.lastAllocatedIdx;
    }

    @Override
    public String toString() {
        return S.toString(MetaPageUpdateLastAllocatedIndex.class, this, "super", super.toString());
    }
}

