/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.communication;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.managers.communication.TransmissionMeta;
import org.apache.ignite.internal.managers.communication.TransmissionReceiver;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

class FileReceiver
extends TransmissionReceiver {
    private final Consumer<File> hnd;
    private File file;
    @GridToStringExclude
    private FileIO fileIo;

    public FileReceiver(TransmissionMeta meta, int chunkSize, BooleanSupplier stopChecker, FileIOFactory factory, Consumer<File> hnd, String path, IgniteLogger log) {
        super(meta, stopChecker, log, chunkSize);
        A.notNull(hnd, "FileHandler must be provided by transmission handler");
        A.notNull(path, "File absolute path cannot be null");
        A.ensure(!path.trim().isEmpty(), "File absolute path cannot be empty ");
        this.hnd = hnd;
        this.file = new File(path);
        try {
            this.fileIo = factory.create(this.file);
            this.fileIo.position(meta.offset());
        }
        catch (IOException e) {
            throw new IgniteException("Unable to open destination file. Receiver will will be stopped", e);
        }
    }

    @Override
    public void receive(ReadableByteChannel ch) throws IOException, InterruptedException {
        super.receive(ch);
        if (this.transferred == this.meta.count()) {
            this.hnd.accept(this.file);
        }
    }

    @Override
    protected void readChunk(ReadableByteChannel ch) throws IOException {
        assert (this.fileIo != null);
        long batchSize = Math.min((long)this.chunkSize, this.meta.count() - this.transferred);
        long read = this.fileIo.transferFrom(ch, this.meta.offset() + this.transferred, batchSize);
        if (read == 0L) {
            throw new IOException("Channel is reached the end of stream. Probably, channel is closed on the remote node");
        }
        if (read > 0L) {
            this.transferred += read;
        }
    }

    @Override
    public void close() {
        U.closeQuiet(this.fileIo);
        try {
            if (this.transferred != this.meta.count()) {
                Files.delete(this.file.toPath());
            }
        }
        catch (IOException e) {
            U.error(this.log, "Error deleting not fully loaded file: " + this.file, e);
        }
    }

    @Override
    public String toString() {
        return S.toString(FileReceiver.class, this, "super", super.toString());
    }
}

