/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.query.KillSubcommand;
import org.apache.ignite.internal.sql.command.SqlKillQueryCommand;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.visor.compute.VisorComputeCancelSessionTask;
import org.apache.ignite.internal.visor.compute.VisorComputeCancelSessionTaskArg;
import org.apache.ignite.internal.visor.query.VisorContinuousQueryCancelTask;
import org.apache.ignite.internal.visor.query.VisorContinuousQueryCancelTaskArg;
import org.apache.ignite.internal.visor.query.VisorQueryCancelOnInitiatorTask;
import org.apache.ignite.internal.visor.query.VisorQueryCancelOnInitiatorTaskArg;
import org.apache.ignite.internal.visor.query.VisorScanQueryCancelTask;
import org.apache.ignite.internal.visor.query.VisorScanQueryCancelTaskArg;
import org.apache.ignite.internal.visor.service.VisorCancelServiceTask;
import org.apache.ignite.internal.visor.service.VisorCancelServiceTaskArg;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotCancelTask;
import org.apache.ignite.internal.visor.tx.VisorTxOperation;
import org.apache.ignite.internal.visor.tx.VisorTxTask;
import org.apache.ignite.internal.visor.tx.VisorTxTaskArg;
import org.apache.ignite.lang.IgniteUuid;

public class KillCommand
implements Command<Object> {
    private Object taskArgs;
    private String taskName;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            Object r = TaskExecutor.executeTaskByNameOnNode(client, this.taskName, this.taskArgs, null, clientCfg);
            return r;
        }
        catch (Throwable e) {
            log.severe("Failed to perform operation.");
            log.severe(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    @Override
    public Object arg() {
        return this.taskArgs;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        KillSubcommand cmd;
        try {
            cmd = KillSubcommand.valueOf(argIter.nextArg("Expected type of resource to kill.").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Expected type of resource to kill.");
        }
        switch (cmd) {
            case COMPUTE: {
                this.taskArgs = new VisorComputeCancelSessionTaskArg(IgniteUuid.fromString(argIter.nextArg("Expected compute task id.")));
                this.taskName = VisorComputeCancelSessionTask.class.getName();
                break;
            }
            case SERVICE: {
                this.taskArgs = new VisorCancelServiceTaskArg(argIter.nextArg("Expected service name."));
                this.taskName = VisorCancelServiceTask.class.getName();
                break;
            }
            case TRANSACTION: {
                String xid = argIter.nextArg("Expected transaction id.");
                this.taskArgs = new VisorTxTaskArg(VisorTxOperation.KILL, null, null, null, null, null, null, xid, null, null, null);
                this.taskName = VisorTxTask.class.getName();
                break;
            }
            case SQL: {
                T2<UUID, Long> ids = SqlKillQueryCommand.parseGlobalQueryId(argIter.nextArg("Expected SQL query id."));
                if (ids == null) {
                    throw new IllegalArgumentException("Expected global query id. Global query id should have format '{node_id}_{query_id}', e.g. '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321'");
                }
                this.taskArgs = new VisorQueryCancelOnInitiatorTaskArg((UUID)ids.get1(), (Long)ids.get2());
                this.taskName = VisorQueryCancelOnInitiatorTask.class.getName();
                break;
            }
            case SCAN: {
                String originNodeIsStr = argIter.nextArg("Expected query originating node id.");
                UUID originNodeId = UUID.fromString(originNodeIsStr);
                String cacheName = argIter.nextArg("Expected cache name.");
                long qryId = Long.parseLong(argIter.nextArg("Expected query identifier."));
                this.taskArgs = new VisorScanQueryCancelTaskArg(originNodeId, cacheName, qryId);
                this.taskName = VisorScanQueryCancelTask.class.getName();
                break;
            }
            case CONTINUOUS: {
                this.taskArgs = new VisorContinuousQueryCancelTaskArg(UUID.fromString(argIter.nextArg("Expected query originating node id.")), UUID.fromString(argIter.nextArg("Expected continuous query id.")));
                this.taskName = VisorContinuousQueryCancelTask.class.getName();
                break;
            }
            case SNAPSHOT: {
                this.taskArgs = argIter.nextArg("Expected snapshot name.");
                this.taskName = VisorSnapshotCancelTask.class.getName();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown kill subcommand: " + (Object)((Object)cmd));
            }
        }
    }

    @Override
    public void printUsage(Logger log) {
        Command.usage(log, "Kill compute task by session id:", CommandList.KILL, Collections.singletonMap("session_id", "Session identifier."), KillSubcommand.COMPUTE.toString(), "session_id");
        Command.usage(log, "Kill service by name:", CommandList.KILL, Collections.singletonMap("name", "Service name."), KillSubcommand.SERVICE.toString(), "name");
        Command.usage(log, "Kill transaction by xid:", CommandList.KILL, Collections.singletonMap("xid", "Transaction identifier."), KillSubcommand.TRANSACTION.toString(), "xid");
        Command.usage(log, "Kill sql query by query id:", CommandList.KILL, Collections.singletonMap("query_id", "Query identifier."), KillSubcommand.SQL.toString(), "query_id");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("origin_node_id", "Originating node id.");
        params.put("cache_name", "Cache name.");
        params.put("query_id", "Query identifier.");
        Command.usage(log, "Kill scan query by node id, cache name and query id:", CommandList.KILL, params, KillSubcommand.SCAN.toString(), "origin_node_id", "cache_name", "query_id");
        params.clear();
        params.put("origin_node_id", "Originating node id.");
        params.put("routine_id", "Routine identifier.");
        Command.usage(log, "Kill continuous query by routine id:", CommandList.KILL, params, KillSubcommand.CONTINUOUS.toString(), "origin_node_id", "routine_id");
        Command.usage(log, "Kill running snapshot by snapshot name:", CommandList.KILL, Collections.singletonMap("snapshot_name", "Snapshot name."), KillSubcommand.SNAPSHOT.toString(), "snapshot_name");
    }

    @Override
    public String name() {
        return CommandList.KILL.toCommandName();
    }
}

