/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.UUID;
import java.util.logging.Logger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientClusterState;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.commandline.CommandList;

public class StateCommand
implements Command<Void> {
    @Override
    public void printUsage(Logger logger) {
        Command.usage(logger, "Print current cluster state:", CommandList.STATE, new String[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            GridClientClusterState state = client.state();
            UUID id = state.id();
            String tag = state.tag();
            log.info("Cluster  ID: " + id);
            log.info("Cluster tag: " + tag);
            log.info("--------------------------------------------------------------------------------");
            ClusterState clusterState = state.state();
            switch (clusterState) {
                case ACTIVE: {
                    log.info("Cluster is active");
                    return null;
                }
                case INACTIVE: {
                    log.info("Cluster is inactive");
                    return null;
                }
                case ACTIVE_READ_ONLY: {
                    log.info("Cluster is active (read-only)");
                    return null;
                }
                default: {
                    throw new IllegalStateException("Unknown state: " + (Object)((Object)clusterState));
                }
            }
        }
        catch (Throwable e) {
            if (CommandHandler.isAuthError(e)) throw e;
            log.severe("Failed to get cluster state.");
            throw e;
        }
    }

    @Override
    public Void arg() {
        return null;
    }

    @Override
    public String name() {
        return CommandList.STATE.toCommandName();
    }
}

