/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;

public class SqlConfiguration {
    public static final int DFLT_SQL_QUERY_HISTORY_SIZE = 1000;
    public static final long DFLT_QRY_TIMEOUT = 0L;
    public static final long DFLT_LONG_QRY_WARN_TIMEOUT = 3000L;
    private long longQryWarnTimeout = 3000L;
    private long dfltQryTimeout = 0L;
    private String[] sqlSchemas;
    private int sqlQryHistSize = 1000;
    private boolean validationEnabled;

    public long getDefaultQueryTimeout() {
        return this.dfltQryTimeout;
    }

    public SqlConfiguration setDefaultQueryTimeout(long dfltQryTimeout) {
        A.ensure(dfltQryTimeout >= 0L && dfltQryTimeout <= Integer.MAX_VALUE, "default query timeout value should be valid Integer.");
        this.dfltQryTimeout = dfltQryTimeout;
        return this;
    }

    public int getSqlQueryHistorySize() {
        return this.sqlQryHistSize;
    }

    public SqlConfiguration setSqlQueryHistorySize(int size) {
        this.sqlQryHistSize = size;
        return this;
    }

    public String[] getSqlSchemas() {
        return this.sqlSchemas;
    }

    public SqlConfiguration setSqlSchemas(String ... sqlSchemas) {
        this.sqlSchemas = sqlSchemas;
        return this;
    }

    public long getLongQueryWarningTimeout() {
        return this.longQryWarnTimeout;
    }

    public SqlConfiguration setLongQueryWarningTimeout(long longQryWarnTimeout) {
        this.longQryWarnTimeout = longQryWarnTimeout;
        return this;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public SqlConfiguration setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
        return this;
    }

    public String toString() {
        return S.toString(SqlConfiguration.class, this);
    }
}

