/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.ignite.internal.jdbc.JdbcDriverPropertyInfo;
import org.apache.ignite.internal.jdbc2.JdbcConnection;

public class IgniteJdbcDriver
implements Driver {
    private static final String PROP_PREFIX = "ignite.jdbc.";
    private static final String PARAM_NODE_ID = "nodeId";
    private static final String PARAM_CACHE = "cache";
    private static final String PARAM_LOCAL = "local";
    private static final String PARAM_COLLOCATED = "collocated";
    private static final String PARAM_DISTRIBUTED_JOINS = "distributedJoins";
    private static final String PARAM_TX_ALLOWED = "transactionsAllowed";
    private static final String PARAM_STREAMING = "streaming";
    private static final String PARAM_STREAMING_FLUSH_FREQ = "streamingFlushFrequency";
    private static final String PARAM_STREAMING_PER_NODE_BUF_SIZE = "streamingPerNodeBufferSize";
    private static final String PARAM_STREAMING_PER_NODE_PAR_OPS = "streamingPerNodeParallelOperations";
    private static final String PARAM_STREAMING_ALLOW_OVERWRITE = "streamingAllowOverwrite";
    private static final String PARAM_MULTIPLE_STMTS = "multipleStatementsAllowed";
    private static final String PARAM_SKIP_REDUCER_ON_UPDATE = "skipReducerOnUpdate";
    public static final String PARAM_ENFORCE_JOIN_ORDER = "enforceJoinOrder";
    public static final String PARAM_LAZY = "lazy";
    public static final String PARAM_SCHEMA = "schema";
    public static final String PROP_HOST = "ignite.jdbc.host";
    public static final String PROP_PORT = "ignite.jdbc.port";
    public static final String PROP_CACHE = "ignite.jdbc.cache";
    public static final String PROP_NODE_ID = "ignite.jdbc.nodeId";
    public static final String PROP_LOCAL = "ignite.jdbc.local";
    public static final String PROP_COLLOCATED = "ignite.jdbc.collocated";
    public static final String PROP_DISTRIBUTED_JOINS = "ignite.jdbc.distributedJoins";
    public static final String PROP_TX_ALLOWED = "ignite.jdbc.transactionsAllowed";
    public static final String PROP_STREAMING = "ignite.jdbc.streaming";
    public static final String PROP_STREAMING_FLUSH_FREQ = "ignite.jdbc.streamingFlushFrequency";
    public static final String PROP_STREAMING_PER_NODE_BUF_SIZE = "ignite.jdbc.streamingPerNodeBufferSize";
    public static final String PROP_STREAMING_PER_NODE_PAR_OPS = "ignite.jdbc.streamingPerNodeParallelOperations";
    public static final String PROP_STREAMING_ALLOW_OVERWRITE = "ignite.jdbc.streamingAllowOverwrite";
    public static final String PROP_MULTIPLE_STMTS = "ignite.jdbc.multipleStatementsAllowed";
    public static final String PROP_SKIP_REDUCER_ON_UPDATE = "ignite.jdbc.skipReducerOnUpdate";
    public static final String PROP_ENFORCE_JOIN_ORDER = "ignite.jdbc.enforceJoinOrder";
    public static final String PROP_LAZY = "ignite.jdbc.lazy";
    public static final String PROP_SCHEMA = "ignite.jdbc.schema";
    public static final String PROP_CFG = "ignite.jdbc.cfg";
    public static final String URL_PREFIX = "jdbc:ignite://";
    public static final String CFG_URL_PREFIX = "jdbc:ignite:cfg://";
    public static final int DFLT_PORT = 11211;
    private static final int MAJOR_VER = 1;
    private static final int MINOR_VER = 0;
    private static final Logger LOG = Logger.getLogger(IgniteJdbcDriver.class.getName());

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        if (!this.parseUrl(url, props)) {
            throw new SQLException("URL is invalid: " + url);
        }
        if (url.startsWith(URL_PREFIX)) {
            if (props.getProperty(PROP_CFG) != null) {
                LOG.warning("ignite.jdbc.cfg property is not applicable for this URL.");
            }
            return new org.apache.ignite.internal.jdbc.JdbcConnection(url, props);
        }
        return new JdbcConnection(url, props);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(URL_PREFIX) || url.startsWith(CFG_URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (!this.parseUrl(url, info)) {
            throw new SQLException("URL is invalid: " + url);
        }
        List<DriverPropertyInfo> props = Arrays.asList(new JdbcDriverPropertyInfo("Hostname", info.getProperty(PROP_HOST), ""), new JdbcDriverPropertyInfo("Port number", info.getProperty(PROP_PORT), ""), new JdbcDriverPropertyInfo("Cache name", info.getProperty(PROP_CACHE), ""), new JdbcDriverPropertyInfo("Node ID", info.getProperty(PROP_NODE_ID), ""), new JdbcDriverPropertyInfo("Local", info.getProperty(PROP_LOCAL), ""), new JdbcDriverPropertyInfo("Collocated", info.getProperty(PROP_COLLOCATED), ""), new JdbcDriverPropertyInfo("Distributed Joins", info.getProperty(PROP_DISTRIBUTED_JOINS), ""), new JdbcDriverPropertyInfo("Enforce Join Order", info.getProperty(PROP_ENFORCE_JOIN_ORDER), ""), new JdbcDriverPropertyInfo("Lazy query execution", info.getProperty(PROP_LAZY), ""), new JdbcDriverPropertyInfo("Transactions Allowed", info.getProperty(PROP_TX_ALLOWED), ""), new JdbcDriverPropertyInfo("Queries with multiple statements allowed", info.getProperty(PROP_MULTIPLE_STMTS), ""), new JdbcDriverPropertyInfo("Skip reducer on update", info.getProperty(PROP_SKIP_REDUCER_ON_UPDATE), ""), new JdbcDriverPropertyInfo("Schema name", info.getProperty(PROP_SCHEMA), ""));
        if (info.getProperty(PROP_CFG) != null) {
            props.add(new JdbcDriverPropertyInfo("Configuration path", info.getProperty(PROP_CFG), ""));
        } else {
            props.addAll(Arrays.asList(new JdbcDriverPropertyInfo("ignite.client.protocol", info.getProperty("ignite.client.protocol", "TCP"), "Communication protocol (TCP or HTTP)."), new JdbcDriverPropertyInfo("ignite.client.connectTimeout", info.getProperty("ignite.client.connectTimeout", "0"), "Socket connection timeout."), new JdbcDriverPropertyInfo("ignite.client.tcp.noDelay", info.getProperty("ignite.client.tcp.noDelay", "true"), "Flag indicating whether TCP_NODELAY flag should be enabled for outgoing connections."), new JdbcDriverPropertyInfo("ignite.client.ssl.enabled", info.getProperty("ignite.client.ssl.enabled", "false"), "Flag indicating that SSL is needed for connection."), new JdbcDriverPropertyInfo("ignite.client.ssl.protocol", info.getProperty("ignite.client.ssl.protocol", "TLS"), "SSL protocol."), new JdbcDriverPropertyInfo("ignite.client.ssl.key.algorithm", info.getProperty("ignite.client.ssl.key.algorithm", "SunX509"), "Key manager algorithm."), new JdbcDriverPropertyInfo("ignite.client.ssl.keystore.location", info.getProperty("ignite.client.ssl.keystore.location", ""), "Key store to be used by client to connect with Ignite topology."), new JdbcDriverPropertyInfo("ignite.client.ssl.keystore.password", info.getProperty("ignite.client.ssl.keystore.password", ""), "Key store password."), new JdbcDriverPropertyInfo("ignite.client.ssl.keystore.type", info.getProperty("ignite.client.ssl.keystore.type", "jks"), "Key store type."), new JdbcDriverPropertyInfo("ignite.client.ssl.truststore.location", info.getProperty("ignite.client.ssl.truststore.location", ""), "Trust store to be used by client to connect with Ignite topology."), new JdbcDriverPropertyInfo("ignite.client.ssl.keystore.password", info.getProperty("ignite.client.ssl.truststore.password", ""), "Trust store password."), new JdbcDriverPropertyInfo("ignite.client.ssl.truststore.type", info.getProperty("ignite.client.ssl.truststore.type", "jks"), "Trust store type."), new JdbcDriverPropertyInfo("ignite.client.credentials", info.getProperty("ignite.client.credentials", ""), "Client credentials used in authentication process."), new JdbcDriverPropertyInfo("ignite.client.cache.top", info.getProperty("ignite.client.cache.top", "false"), "Flag indicating that topology is cached internally. Cache will be refreshed in the background with interval defined by topologyRefreshFrequency property (see below)."), new JdbcDriverPropertyInfo("ignite.client.topology.refresh", info.getProperty("ignite.client.topology.refresh", "2000"), "Topology cache refresh frequency (ms)."), new JdbcDriverPropertyInfo("ignite.client.idleTimeout", info.getProperty("ignite.client.idleTimeout", "30000"), "Maximum amount of time that connection can be idle before it is closed (ms).")));
        }
        return props.toArray(new DriverPropertyInfo[0]);
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("java.util.logging is not used.");
    }

    private boolean parseUrl(String url, Properties props) {
        if (url == null) {
            return false;
        }
        if (url.startsWith(URL_PREFIX) && url.length() > URL_PREFIX.length()) {
            return this.parseJdbcUrl(url, props);
        }
        if (url.startsWith(CFG_URL_PREFIX) && url.length() >= CFG_URL_PREFIX.length()) {
            return this.parseJdbcConfigUrl(url, props);
        }
        return false;
    }

    private boolean parseJdbcConfigUrl(String url, Properties props) {
        String[] parts = (url = url.substring(CFG_URL_PREFIX.length())).split("@");
        if (parts.length > 2) {
            return false;
        }
        if (parts.length == 2 && !this.parseParameters(parts[0], ":", props)) {
            return false;
        }
        props.setProperty(PROP_CFG, parts[parts.length - 1]);
        return true;
    }

    private boolean parseJdbcUrl(String url, Properties props) {
        String[] parts = (url = url.substring(URL_PREFIX.length())).split("\\?");
        if (parts.length > 2) {
            return false;
        }
        if (parts.length == 2 && !this.parseParameters(parts[1], "&", props)) {
            return false;
        }
        parts = parts[0].split("/");
        assert (parts.length > 0);
        if (parts.length > 2) {
            return false;
        }
        if (parts.length == 2 && !parts[1].isEmpty()) {
            props.setProperty(PROP_CACHE, parts[1]);
        }
        url = parts[0];
        parts = url.split(":");
        assert (parts.length > 0);
        if (parts.length > 2) {
            return false;
        }
        props.setProperty(PROP_HOST, parts[0]);
        try {
            props.setProperty(PROP_PORT, String.valueOf(parts.length == 2 ? Integer.valueOf(parts[1]) : 11211));
        }
        catch (NumberFormatException ignored) {
            return false;
        }
        return true;
    }

    private boolean parseParameters(String val, String delim, Properties props) {
        String[] params;
        for (String param : params = val.split(delim)) {
            String[] pair = param.split("=");
            if (pair.length != 2 || pair[0].isEmpty() || pair[1].isEmpty()) {
                return false;
            }
            props.setProperty(PROP_PREFIX + pair[0], pair[1]);
        }
        return true;
    }

    static {
        try {
            DriverManager.registerDriver(new IgniteJdbcDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to register Ignite JDBC driver.", e);
        }
    }
}

