/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.IgniteSpiTimeoutObject;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.zk.internal.ZkClusterNodes;
import org.apache.ignite.spi.discovery.zk.internal.ZkCommunicationErrorNodeState;
import org.apache.ignite.spi.discovery.zk.internal.ZkCommunicationErrorResolveStartMessage;
import org.apache.ignite.spi.discovery.zk.internal.ZkDistributedCollectDataFuture;
import org.apache.ignite.spi.discovery.zk.internal.ZkRunnable;
import org.apache.ignite.spi.discovery.zk.internal.ZkRuntimeState;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoveryImpl;
import org.jetbrains.annotations.Nullable;

class ZkCommunicationErrorProcessFuture
extends GridFutureAdapter<Void>
implements IgniteSpiTimeoutObject,
Runnable {
    private final ZookeeperDiscoveryImpl impl;
    private final IgniteLogger log;
    private final Map<Long, GridFutureAdapter<Boolean>> nodeFuts = new ConcurrentHashMap<Long, GridFutureAdapter<Boolean>>();
    private final long endTime;
    private final IgniteUuid id;
    private State state;
    private long resolveTopVer;
    private Set<Long> resFailedNodes;
    private Exception resErr;
    private ZkDistributedCollectDataFuture collectResFut;

    static ZkCommunicationErrorProcessFuture createOnCommunicationError(ZookeeperDiscoveryImpl impl, long timeout) {
        return new ZkCommunicationErrorProcessFuture(impl, State.WAIT_TIMEOUT, timeout);
    }

    static ZkCommunicationErrorProcessFuture createOnStartResolveRequest(ZookeeperDiscoveryImpl impl) {
        return new ZkCommunicationErrorProcessFuture(impl, State.RESOLVE_STARTED, 0L);
    }

    private ZkCommunicationErrorProcessFuture(ZookeeperDiscoveryImpl impl, State state, long timeout) {
        assert (state != State.DONE);
        this.impl = impl;
        this.log = impl.log();
        if (state == State.WAIT_TIMEOUT) {
            assert (timeout > 0L) : timeout;
            this.id = IgniteUuid.fromUuid((UUID)impl.localNode().id());
            this.endTime = System.currentTimeMillis() + timeout;
        } else {
            this.id = null;
            this.endTime = 0L;
        }
        this.state = state;
    }

    @Nullable
    public IgniteLogger logger() {
        return this.log;
    }

    void nodeResultCollectFuture(ZkDistributedCollectDataFuture collectResFut) {
        assert (this.collectResFut == null) : collectResFut;
        this.collectResFut = collectResFut;
    }

    void onTopologyChange(ZkClusterNodes top) throws Exception {
        for (Map.Entry<Long, GridFutureAdapter<Boolean>> e : this.nodeFuts.entrySet()) {
            if (top.nodesByOrder.containsKey(e.getKey())) continue;
            e.getValue().onDone((Object)false);
        }
        if (this.collectResFut != null) {
            this.collectResFut.onTopologyChange(top);
        }
    }

    void checkConnection(final ZkRuntimeState rtState, final String futPath, List<ClusterNode> nodes) {
        TcpCommunicationSpi spi = (TcpCommunicationSpi)this.impl.spi.ignite().configuration().getCommunicationSpi();
        IgniteFuture fut = spi.checkConnection(nodes);
        fut.listen((IgniteInClosure)new IgniteInClosure<IgniteFuture<BitSet>>(){

            public void apply(final IgniteFuture<BitSet> fut) {
                ZkCommunicationErrorProcessFuture.this.impl.runInWorkerThread(new ZkRunnable(rtState, ZkCommunicationErrorProcessFuture.this.impl){

                    @Override
                    public void run0() throws Exception {
                        BitSet commState = null;
                        Exception err = null;
                        try {
                            commState = (BitSet)fut.get();
                        }
                        catch (Exception e) {
                            err = e;
                        }
                        ZkCommunicationErrorNodeState state = new ZkCommunicationErrorNodeState(commState, err);
                        ZkDistributedCollectDataFuture.saveNodeResult(futPath, this.rtState.zkClient, this.impl.localNode().order(), this.impl.marshalZip(state));
                    }

                    @Override
                    void onStartFailed() {
                        ZkCommunicationErrorProcessFuture.this.onError(this.rtState.errForClose);
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleCheckOnTimeout() {
        ZkCommunicationErrorProcessFuture zkCommunicationErrorProcessFuture = this;
        synchronized (zkCommunicationErrorProcessFuture) {
            if (this.state == State.WAIT_TIMEOUT) {
                this.impl.spi.getSpiContext().addTimeoutObject((IgniteSpiTimeoutObject)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onStartResolveRequest(long topVer) {
        ZkCommunicationErrorProcessFuture zkCommunicationErrorProcessFuture = this;
        synchronized (zkCommunicationErrorProcessFuture) {
            if (this.state == State.DONE) {
                return false;
            }
            if (this.state == State.WAIT_TIMEOUT) {
                this.impl.spi.getSpiContext().removeTimeoutObject((IgniteSpiTimeoutObject)this);
            }
            assert (this.resolveTopVer == 0L) : this.resolveTopVer;
            this.resolveTopVer = topVer;
            this.state = State.RESOLVE_STARTED;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onError(Exception err) {
        Map<Long, GridFutureAdapter<Boolean>> futs;
        assert (err != null);
        ZkCommunicationErrorProcessFuture zkCommunicationErrorProcessFuture = this;
        synchronized (zkCommunicationErrorProcessFuture) {
            if (this.state == State.DONE) {
                assert (this.resErr != null);
                return;
            }
            this.state = State.DONE;
            this.resErr = err;
            futs = this.nodeFuts;
        }
        for (Map.Entry entry : futs.entrySet()) {
            ((GridFutureAdapter)entry.getValue()).onDone((Throwable)err);
        }
        this.onDone(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFinishResolve(Set<Long> failedNodes) {
        Map<Long, GridFutureAdapter<Boolean>> futs;
        ZkCommunicationErrorProcessFuture zkCommunicationErrorProcessFuture = this;
        synchronized (zkCommunicationErrorProcessFuture) {
            if (this.state == State.DONE) {
                assert (this.resErr != null);
                return;
            }
            assert (this.state == State.RESOLVE_STARTED) : this.state;
            this.state = State.DONE;
            this.resFailedNodes = failedNodes;
            futs = this.nodeFuts;
        }
        for (Map.Entry entry : futs.entrySet()) {
            Boolean res = !F.contains(this.resFailedNodes, entry.getKey());
            ((GridFutureAdapter)entry.getValue()).onDone((Object)res);
        }
        this.onDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    IgniteInternalFuture<Boolean> nodeStatusFuture(ClusterNode node) {
        GridFutureAdapter fut;
        ZkCommunicationErrorProcessFuture zkCommunicationErrorProcessFuture = this;
        synchronized (zkCommunicationErrorProcessFuture) {
            if (this.state == State.DONE) {
                if (this.resolveTopVer != 0L && node.order() <= this.resolveTopVer) {
                    Boolean res = !F.contains(this.resFailedNodes, (Object)node.order());
                    return new GridFinishedFuture((Object)res);
                }
                return null;
            }
            fut = this.nodeFuts.get(node.order());
            if (fut == null) {
                fut = new GridFutureAdapter();
                this.nodeFuts.put(node.order(), (GridFutureAdapter<Boolean>)fut);
            }
        }
        if (this.impl.node(node.order()) == null) {
            fut.onDone((Object)false);
        }
        return fut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.needProcessTimeout()) {
            try {
                UUID reqId = UUID.randomUUID();
                if (this.log.isInfoEnabled()) {
                    this.log.info("Initiate cluster-wide communication error resolve process [reqId=" + reqId + ", errNodes=" + this.nodeFuts.size() + ']');
                }
                this.impl.sendCustomMessage(new ZkCommunicationErrorResolveStartMessage(reqId));
            }
            catch (Exception e) {
                Collection<GridFutureAdapter<Boolean>> futs;
                ZkCommunicationErrorProcessFuture zkCommunicationErrorProcessFuture = this;
                synchronized (zkCommunicationErrorProcessFuture) {
                    if (this.state != State.WAIT_TIMEOUT) {
                        return;
                    }
                    this.state = State.DONE;
                    this.resErr = e;
                    futs = this.nodeFuts.values();
                }
                for (GridFutureAdapter gridFutureAdapter : futs) {
                    gridFutureAdapter.onDone((Throwable)e);
                }
                this.onDone(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needProcessTimeout() {
        ZkCommunicationErrorProcessFuture zkCommunicationErrorProcessFuture = this;
        synchronized (zkCommunicationErrorProcessFuture) {
            if (this.state != State.WAIT_TIMEOUT) {
                return false;
            }
            for (GridFutureAdapter<Boolean> fut : this.nodeFuts.values()) {
                if (fut.isDone()) continue;
                return true;
            }
            this.state = State.DONE;
        }
        this.onDone(null, null);
        return false;
    }

    public IgniteUuid id() {
        return this.id;
    }

    public long endTime() {
        return this.endTime;
    }

    public void onTimeout() {
        if (this.needProcessTimeout()) {
            this.impl.runInWorkerThread(this);
        }
    }

    public boolean onDone(@Nullable Void res, @Nullable Throwable err) {
        if (super.onDone((Object)res, err)) {
            this.impl.clearCommunicationErrorProcessFuture(this);
            return true;
        }
        return false;
    }

    public String toString() {
        return S.toString(ZkCommunicationErrorProcessFuture.class, (Object)this);
    }

    static enum State {
        DONE,
        WAIT_TIMEOUT,
        RESOLVE_STARTED;

    }
}

