/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.deployment.uri.scanners.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.deployment.uri.scanners.UriDeploymentScanner;
import org.apache.ignite.spi.deployment.uri.scanners.UriDeploymentScannerContext;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

public class UriDeploymentHttpScanner
implements UriDeploymentScanner {
    public static final int DFLT_SCAN_FREQ = 300000;
    private static final String PROTOCOL = "TLS";
    private final ConcurrentHashMap<URI, URIContext> uriCtxs = new ConcurrentHashMap();

    @Override
    public boolean acceptsURI(URI uri) {
        String proto = uri.getScheme().toLowerCase();
        return "http".equals(proto) || "https".equals(proto);
    }

    @Override
    public void scan(UriDeploymentScannerContext scanCtx) {
        URIContext oldUriCtx;
        URI uri = scanCtx.getUri();
        URIContext uriCtx = this.uriCtxs.get(uri);
        if (uriCtx == null && (oldUriCtx = this.uriCtxs.putIfAbsent(uri, uriCtx = this.createUriContext(uri, scanCtx))) != null) {
            uriCtx = oldUriCtx;
        }
        uriCtx.scan(scanCtx);
    }

    private URIContext createUriContext(URI uri, UriDeploymentScannerContext scanCtx) {
        URL scanDir;
        assert ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme()));
        try {
            scanDir = new URL(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath());
        }
        catch (MalformedURLException e) {
            throw new IgniteSpiException("Wrong value for scanned HTTP directory with URI: " + uri, (Throwable)e);
        }
        SSLSocketFactory sockFactory = null;
        try {
            if ("https".equals(uri.getScheme())) {
                SSLContext ctx = SSLContext.getInstance(PROTOCOL);
                ctx.init(null, UriDeploymentHttpScanner.getTrustManagers(scanCtx), null);
                sockFactory = ctx.getSocketFactory();
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IgniteSpiException("Failed to initialize SSL context. URI: " + uri, (Throwable)e);
        }
        catch (KeyManagementException e) {
            throw new IgniteSpiException("Failed to initialize SSL context. URI:" + uri, (Throwable)e);
        }
        return new URIContext(scanDir, sockFactory);
    }

    @Override
    public long getDefaultScanFrequency() {
        return 300000L;
    }

    private static TrustManager[] getTrustManagers(final UriDeploymentScannerContext scanCtx) {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            @Nullable
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
                StringBuilder buf = new StringBuilder();
                buf.append("Trust manager handle client certificates [authType=");
                buf.append(authType);
                buf.append(", certificates=");
                for (X509Certificate cert : certs) {
                    buf.append("{type=");
                    buf.append(cert.getType());
                    buf.append(", principalName=");
                    buf.append(cert.getSubjectX500Principal().getName());
                    buf.append('}');
                }
                buf.append(']');
                if (scanCtx.getLogger().isDebugEnabled()) {
                    scanCtx.getLogger().debug(buf.toString());
                }
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
                StringBuilder buf = new StringBuilder();
                buf.append("Trust manager handle server certificates [authType=");
                buf.append(authType);
                buf.append(", certificates=");
                for (X509Certificate cert : certs) {
                    buf.append("{type=");
                    buf.append(cert.getType());
                    buf.append(", principalName=");
                    buf.append(cert.getSubjectX500Principal().getName());
                    buf.append('}');
                }
                buf.append(']');
                if (scanCtx.getLogger().isDebugEnabled()) {
                    scanCtx.getLogger().debug(buf.toString());
                }
            }
        }};
    }

    private static class DeploymentHostnameVerifier
    implements HostnameVerifier {
        private DeploymentHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession ses) {
            return true;
        }
    }

    private class URIContext {
        private final URL scanDir;
        private final SSLSocketFactory sockFactory;
        private final Tidy tidy;
        private final Map<String, Long> tstampCache = new HashMap<String, Long>();

        public URIContext(URL scanDir, SSLSocketFactory sockFactory) {
            this.scanDir = scanDir;
            this.sockFactory = sockFactory;
            this.tidy = new Tidy();
            this.tidy.setQuiet(true);
            this.tidy.setOnlyErrors(true);
            this.tidy.setShowWarnings(false);
            this.tidy.setInputEncoding("UTF8");
            this.tidy.setOutputEncoding("UTF8");
        }

        private void scan(UriDeploymentScannerContext scanCtx) {
            HashSet foundFiles = U.newHashSet((int)this.tstampCache.size());
            long start = U.currentTimeMillis();
            this.processHttp(foundFiles, scanCtx);
            if (scanCtx.getLogger().isDebugEnabled()) {
                scanCtx.getLogger().debug("HTTP scanner time in ms: " + (U.currentTimeMillis() - start));
            }
            if (!scanCtx.isFirstScan()) {
                HashSet<String> deletedFiles = new HashSet<String>(this.tstampCache.keySet());
                deletedFiles.removeAll(foundFiles);
                if (!deletedFiles.isEmpty()) {
                    ArrayList<String> uris = new ArrayList<String>();
                    for (String file : deletedFiles) {
                        uris.add(this.getFileUri(this.fileName(file), scanCtx));
                    }
                    this.tstampCache.keySet().removeAll(deletedFiles);
                    scanCtx.getListener().onDeletedFiles(uris);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void processHttp(Collection<String> files, UriDeploymentScannerContext scanCtx) {
            Set<String> urls = this.getUrls(this.scanDir, scanCtx);
            Iterator<String> iterator = urls.iterator();
            while (iterator.hasNext()) {
                File file;
                Long lastModified;
                String fileName;
                block17: {
                    FileOutputStream out;
                    InputStream in;
                    block16: {
                        block15: {
                            String url = iterator.next();
                            fileName = this.fileName(url);
                            if (!scanCtx.getFilter().accept(null, fileName)) continue;
                            files.add(url);
                            lastModified = this.tstampCache.get(url);
                            in = null;
                            out = null;
                            file = null;
                            try {
                                URLConnection conn = new URL(url).openConnection();
                                if (conn instanceof HttpsURLConnection) {
                                    HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
                                    httpsConn.setHostnameVerifier(new DeploymentHostnameVerifier());
                                    assert (this.sockFactory != null);
                                    httpsConn.setSSLSocketFactory(this.sockFactory);
                                }
                                if (lastModified != null) {
                                    conn.setIfModifiedSince(lastModified);
                                }
                                in = conn.getInputStream();
                                long rcvLastModified = conn.getLastModified();
                                if (in == null || lastModified != null && (lastModified == rcvLastModified || conn instanceof HttpURLConnection && ((HttpURLConnection)conn).getResponseCode() == 304)) {
                                    U.closeQuiet((AutoCloseable)in);
                                    break block15;
                                }
                                this.tstampCache.put(url, rcvLastModified);
                                lastModified = rcvLastModified;
                                if (scanCtx.getLogger().isDebugEnabled()) {
                                    scanCtx.getLogger().debug("Discovered deployment file or directory: " + U.hidePassword((String)url));
                                }
                                file = scanCtx.createTempFile(fileName, scanCtx.getDeployDirectory());
                                file.deleteOnExit();
                                out = new FileOutputStream(file);
                                U.copy((InputStream)in, (OutputStream)out);
                                U.closeQuiet((AutoCloseable)in);
                                break block16;
                            }
                            catch (IOException e) {
                                if (scanCtx.isCancelled()) break block17;
                                if (X.hasCause((Throwable)e, (Class[])new Class[]{ConnectException.class})) {
                                    LT.error((IgniteLogger)scanCtx.getLogger(), (Throwable)e, (String)("Failed to connect to HTTP server (connection refused): " + U.hidePassword((String)url)));
                                    break block17;
                                }
                                if (X.hasCause((Throwable)e, (Class[])new Class[]{UnknownHostException.class})) {
                                    LT.error((IgniteLogger)scanCtx.getLogger(), (Throwable)e, (String)("Failed to connect to HTTP server (host is unknown): " + U.hidePassword((String)url)));
                                    break block17;
                                } else {
                                    U.error((IgniteLogger)scanCtx.getLogger(), (Object)("Failed to save file: " + fileName), (Throwable)e);
                                }
                                break block17;
                            }
                        }
                        U.closeQuiet(out);
                        continue;
                    }
                    U.closeQuiet((AutoCloseable)out);
                    break block17;
                    finally {
                        U.closeQuiet(in);
                        U.closeQuiet(out);
                    }
                }
                if (file == null || !file.exists() || file.length() <= 0L) continue;
                scanCtx.getListener().onNewOrUpdatedFile(file, this.getFileUri(fileName, scanCtx), lastModified);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> getUrls(URL url, UriDeploymentScannerContext scanCtx) {
            assert (url != null);
            InputStream in = null;
            HashSet<String> urls = new HashSet<String>();
            Document dom = null;
            try {
                URLConnection conn = url.openConnection();
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
                    httpsConn.setHostnameVerifier(new DeploymentHostnameVerifier());
                    assert (this.sockFactory != null);
                    httpsConn.setSSLSocketFactory(this.sockFactory);
                }
                if ((in = conn.getInputStream()) == null) {
                    throw new IOException("Failed to open connection: " + U.hidePassword((String)url.toString()));
                }
                dom = this.tidy.parseDOM(in, null);
                U.closeQuiet((AutoCloseable)in);
            }
            catch (IOException e) {
                if (!scanCtx.isCancelled()) {
                    if (X.hasCause((Throwable)e, (Class[])new Class[]{ConnectException.class})) {
                        LT.error((IgniteLogger)scanCtx.getLogger(), (Throwable)e, (String)("Failed to connect to HTTP server (connection refused): " + U.hidePassword((String)url.toString())));
                    } else if (X.hasCause((Throwable)e, (Class[])new Class[]{UnknownHostException.class})) {
                        LT.error((IgniteLogger)scanCtx.getLogger(), (Throwable)e, (String)("Failed to connect to HTTP server (host is unknown): " + U.hidePassword((String)url.toString())));
                    } else {
                        U.error((IgniteLogger)scanCtx.getLogger(), (Object)("Failed to get HTML page: " + U.hidePassword((String)url.toString())), (Throwable)e);
                    }
                }
            }
            finally {
                U.closeQuiet(in);
            }
            if (dom != null) {
                this.findReferences(dom, urls, url, scanCtx);
            }
            return urls;
        }

        private void findReferences(Node node, Set<String> res, URL baseUrl, UriDeploymentScannerContext scanCtx) {
            Element element;
            String href;
            if (node instanceof Element && "a".equals(node.getNodeName().toLowerCase()) && (href = (element = (Element)node).getAttribute("href")) != null && !href.isEmpty()) {
                URL url = null;
                try {
                    url = new URL(href);
                }
                catch (MalformedURLException e) {
                    try {
                        url = new URL(baseUrl.getProtocol(), baseUrl.getHost(), baseUrl.getPort(), href.charAt(0) == '/' ? href : baseUrl.getFile() + '/' + href);
                    }
                    catch (MalformedURLException e1) {
                        U.error((IgniteLogger)scanCtx.getLogger(), (Object)("Skipping bad URL: " + href), (Throwable)e1);
                    }
                }
                if (url != null) {
                    res.add(url.toString());
                }
            }
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                this.findReferences(childNodes.item(i), res, baseUrl, scanCtx);
            }
        }

        private String fileName(String url) {
            assert (url != null);
            return url.substring(url.lastIndexOf(47) + 1);
        }

        private String getFileUri(String name, UriDeploymentScannerContext scanCtx) {
            assert (name != null);
            String fileUri = scanCtx.getUri().toString();
            fileUri = fileUri.length() > 0 && fileUri.charAt(fileUri.length() - 1) == '/' ? fileUri + name : fileUri + '/' + name;
            return fileUri;
        }
    }
}

