/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.AfterDomainEventPublication;
import org.springframework.data.domain.DomainEvents;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.data.util.AnnotationDetectionMethodCallback;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public class EventPublishingRepositoryProxyPostProcessor
implements RepositoryProxyPostProcessor {
    private final ApplicationEventPublisher publisher;

    @Override
    public void postProcess(ProxyFactory factory, RepositoryInformation repositoryInformation) {
        EventPublishingMethod method = EventPublishingMethod.of(repositoryInformation.getDomainType());
        if (method == null) {
            return;
        }
        factory.addAdvice((Advice)new EventPublishingMethodInterceptor(method, this.publisher));
    }

    @Generated
    public EventPublishingRepositoryProxyPostProcessor(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    static class EventPublishingMethod {
        private static Map<Class<?>, EventPublishingMethod> CACHE = new ConcurrentReferenceHashMap();
        private static EventPublishingMethod NONE = new EventPublishingMethod(null, null);
        private final Method publishingMethod;
        private final Method clearingMethod;

        public static EventPublishingMethod of(Class<?> type) {
            Assert.notNull(type, (String)"Type must not be null!");
            EventPublishingMethod eventPublishingMethod = CACHE.get(type);
            if (eventPublishingMethod != null) {
                return eventPublishingMethod.orNull();
            }
            AnnotationDetectionMethodCallback<DomainEvents> publishing = new AnnotationDetectionMethodCallback<DomainEvents>(DomainEvents.class);
            ReflectionUtils.doWithMethods(type, publishing);
            AnnotationDetectionMethodCallback<AfterDomainEventPublication> clearing = new AnnotationDetectionMethodCallback<AfterDomainEventPublication>(AfterDomainEventPublication.class);
            ReflectionUtils.doWithMethods(type, clearing);
            EventPublishingMethod result = EventPublishingMethod.from(publishing, clearing);
            CACHE.put(type, result);
            return result.orNull();
        }

        public void publishEventsFrom(Object object, ApplicationEventPublisher publisher) {
            if (object == null) {
                return;
            }
            for (Object aggregateRoot : EventPublishingMethod.asCollection(object)) {
                for (Object event : EventPublishingMethod.asCollection(ReflectionUtils.invokeMethod((Method)this.publishingMethod, (Object)aggregateRoot))) {
                    publisher.publishEvent(event);
                }
                if (this.clearingMethod == null) continue;
                ReflectionUtils.invokeMethod((Method)this.clearingMethod, (Object)aggregateRoot);
            }
        }

        private EventPublishingMethod orNull() {
            return this == NONE ? null : this;
        }

        private static EventPublishingMethod from(AnnotationDetectionMethodCallback<?> publishing, AnnotationDetectionMethodCallback<?> clearing) {
            if (!publishing.hasFoundAnnotation()) {
                return NONE;
            }
            Method eventMethod = publishing.getMethod();
            ReflectionUtils.makeAccessible((Method)eventMethod);
            return new EventPublishingMethod(eventMethod, EventPublishingMethod.getClearingMethod(clearing));
        }

        private static Method getClearingMethod(AnnotationDetectionMethodCallback<?> clearing) {
            if (!clearing.hasFoundAnnotation()) {
                return null;
            }
            Method method = clearing.getMethod();
            ReflectionUtils.makeAccessible((Method)method);
            return method;
        }

        private static Collection<Object> asCollection(Object source) {
            if (source == null) {
                return Collections.emptyList();
            }
            if (Collection.class.isInstance(source)) {
                return (Collection)source;
            }
            return Arrays.asList(source);
        }

        @Generated
        public EventPublishingMethod(Method publishingMethod, Method clearingMethod) {
            this.publishingMethod = publishingMethod;
            this.clearingMethod = clearingMethod;
        }
    }

    static class EventPublishingMethodInterceptor
    implements MethodInterceptor {
        private final EventPublishingMethod eventMethod;
        private final ApplicationEventPublisher publisher;

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Object[] arguments = invocation.getArguments();
            Object result = invocation.proceed();
            if (!invocation.getMethod().getName().startsWith("save")) {
                return result;
            }
            Object eventSource = arguments.length == 1 ? arguments[0] : result;
            this.eventMethod.publishEventsFrom(eventSource, this.publisher);
            return result;
        }

        @Generated
        private EventPublishingMethodInterceptor(EventPublishingMethod eventMethod, ApplicationEventPublisher publisher) {
            this.eventMethod = eventMethod;
            this.publisher = publisher;
        }

        @Generated
        public static EventPublishingMethodInterceptor of(EventPublishingMethod eventMethod, ApplicationEventPublisher publisher) {
            return new EventPublishingMethodInterceptor(eventMethod, publisher);
        }
    }
}

