/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.maxabsscaling;

import org.apache.ignite.ml.dataset.Dataset;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.dataset.primitive.context.EmptyContext;
import org.apache.ignite.ml.environment.LearningEnvironmentBuilder;
import org.apache.ignite.ml.preprocessing.PreprocessingTrainer;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.preprocessing.maxabsscaling.MaxAbsScalerPartitionData;
import org.apache.ignite.ml.preprocessing.maxabsscaling.MaxAbsScalerPreprocessor;
import org.apache.ignite.ml.structures.LabeledVector;

public class MaxAbsScalerTrainer<K, V>
implements PreprocessingTrainer<K, V> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MaxAbsScalerPreprocessor<K, V> fit(LearningEnvironmentBuilder envBuilder, DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> basePreprocessor) {
        try (Dataset<EmptyContext, MaxAbsScalerPartitionData> dataset = datasetBuilder.build(envBuilder, (env, upstream, upstreamSize) -> new EmptyContext(), (env, upstream, upstreamSize, ctx) -> {
            double[] maxAbs = null;
            while (upstream.hasNext()) {
                int i;
                UpstreamEntry entity = (UpstreamEntry)upstream.next();
                LabeledVector row = (LabeledVector)basePreprocessor.apply(entity.getKey(), entity.getValue());
                if (maxAbs == null) {
                    maxAbs = new double[row.size()];
                    for (i = 0; i < maxAbs.length; ++i) {
                        maxAbs[i] = 0.0;
                    }
                } else assert (maxAbs.length == row.size()) : "Base preprocessor must return exactly " + maxAbs.length + " features";
                for (i = 0; i < row.size(); ++i) {
                    if (!(Math.abs(row.get(i)) > Math.abs(maxAbs[i]))) continue;
                    maxAbs[i] = Math.abs(row.get(i));
                }
            }
            return new MaxAbsScalerPartitionData(maxAbs);
        }, this.learningEnvironment(basePreprocessor));){
            double[] maxAbs = (double[])dataset.compute(MaxAbsScalerPartitionData::getMaxAbs, (a, b) -> {
                if (a == null) {
                    return b;
                }
                if (b == null) {
                    return a;
                }
                double[] res = new double[((double[])a).length];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = Math.max(Math.abs(a[i]), Math.abs(b[i]));
                }
                return res;
            });
            MaxAbsScalerPreprocessor<K, V> maxAbsScalerPreprocessor = new MaxAbsScalerPreprocessor<K, V>(maxAbs, basePreprocessor);
            return maxAbsScalerPreprocessor;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

