/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.vector.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.ml.math.exceptions.math.IndexException;
import org.apache.ignite.ml.math.primitives.matrix.Matrix;
import org.apache.ignite.ml.math.primitives.vector.AbstractVector;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.storage.VectorizedViewMatrixStorage;

public class VectorizedViewMatrix
extends AbstractVector {
    private Matrix parent;
    private int row;
    private int col;
    private int rowStride;
    private int colStride;

    public VectorizedViewMatrix() {
    }

    public VectorizedViewMatrix(Matrix parent, int row, int col, int rowStride, int colStride) {
        assert (parent != null);
        if (row < 0 || row >= parent.rowSize()) {
            throw new IndexException(row);
        }
        if (col < 0 || col >= parent.columnSize()) {
            throw new IndexException(col);
        }
        this.parent = parent;
        this.row = row;
        this.col = col;
        this.rowStride = rowStride;
        this.colStride = colStride;
        this.setStorage(new VectorizedViewMatrixStorage(parent, row, col, rowStride, colStride));
    }

    @Override
    public Vector copy() {
        return new VectorizedViewMatrix(this.parent, this.row, this.col, this.rowStride, this.colStride);
    }

    @Override
    public Vector like(int crd) {
        return this.parent.likeVector(crd);
    }

    @Override
    public Matrix likeMatrix(int rows, int cols) {
        return this.parent.like(rows, cols);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.parent);
        out.writeInt(this.row);
        out.writeInt(this.col);
        out.writeInt(this.rowStride);
        out.writeInt(this.colStride);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.parent = (Matrix)in.readObject();
        this.row = in.readInt();
        this.col = in.readInt();
        this.rowStride = in.readInt();
        this.colStride = in.readInt();
    }

    @Override
    public int hashCode() {
        int res = 1;
        res = res * 37 + (this.parent == null ? 0 : this.parent.hashCode());
        res = res * 37 + this.row;
        res = res * 37 + this.col;
        res = res * 37 + this.rowStride;
        res = res * 37 + this.colStride;
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VectorizedViewMatrix that = (VectorizedViewMatrix)o;
        return (this.parent != null ? this.parent.equals(that.parent) : that.parent == null) && this.row == that.row && this.col == that.col && this.rowStride == that.rowStride && this.colStride == that.colStride;
    }
}

