/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.inference.storage.model;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.ml.inference.storage.model.FileOrDirectory;
import org.apache.ignite.ml.inference.storage.model.ModelStorageProvider;

public class LocalModelStorageProvider
implements ModelStorageProvider {
    private final ConcurrentMap<String, FileOrDirectory> storage = new ConcurrentHashMap<String, FileOrDirectory>();
    private final Map<String, WeakReferenceWithCleanUp> locks = new HashMap<String, WeakReferenceWithCleanUp>();
    private final ReferenceQueue<Lock> refQueue = new ReferenceQueue();

    @Override
    public FileOrDirectory get(String key) {
        return (FileOrDirectory)this.storage.get(key);
    }

    @Override
    public void put(String key, FileOrDirectory file) {
        this.storage.put(key, file);
    }

    @Override
    public void remove(String key) {
        this.storage.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Lock lock(String key) {
        WeakReferenceWithCleanUp ref = this.locks.get(key);
        try {
            Lock lockInRef;
            if (ref != null && (lockInRef = (Lock)ref.get()) != null) {
                Lock lock = lockInRef;
                return lock;
            }
            ReentrantLock lock = new ReentrantLock();
            this.locks.put(key, new WeakReferenceWithCleanUp(key, lock));
            ReentrantLock reentrantLock = lock;
            return reentrantLock;
        }
        finally {
            while ((ref = (WeakReferenceWithCleanUp)this.refQueue.poll()) != null) {
                this.locks.remove(ref.key, ref);
            }
        }
    }

    private class WeakReferenceWithCleanUp
    extends WeakReference<Lock> {
        private final String key;

        public WeakReferenceWithCleanUp(String key, Lock referent) {
            super(referent, LocalModelStorageProvider.this.refQueue);
            this.key = key;
        }
    }
}

