/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset;

import java.io.Serializable;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.ml.dataset.Dataset;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.PartitionContextBuilder;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.impl.cache.CacheBasedDatasetBuilder;
import org.apache.ignite.ml.dataset.impl.local.LocalDatasetBuilder;
import org.apache.ignite.ml.dataset.primitive.SimpleDataset;
import org.apache.ignite.ml.dataset.primitive.SimpleLabeledDataset;
import org.apache.ignite.ml.dataset.primitive.builder.context.EmptyContextBuilder;
import org.apache.ignite.ml.dataset.primitive.builder.data.SimpleDatasetDataBuilder;
import org.apache.ignite.ml.dataset.primitive.builder.data.SimpleLabeledDatasetDataBuilder;
import org.apache.ignite.ml.dataset.primitive.context.EmptyContext;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.environment.LearningEnvironmentBuilder;
import org.apache.ignite.ml.preprocessing.Preprocessor;

public class DatasetFactory {
    public static <K, V, C extends Serializable, D extends AutoCloseable> Dataset<C, D> create(DatasetBuilder<K, V> datasetBuilder, LearningEnvironmentBuilder envBuilder, PartitionContextBuilder<K, V, C> partCtxBuilder, PartitionDataBuilder<K, V, C, D> partDataBuilder, LearningEnvironment environment) {
        return datasetBuilder.build(envBuilder, partCtxBuilder, partDataBuilder, environment);
    }

    public static <K, V, C extends Serializable, D extends AutoCloseable> Dataset<C, D> create(DatasetBuilder<K, V> datasetBuilder, PartitionContextBuilder<K, V, C> partCtxBuilder, PartitionDataBuilder<K, V, C, D> partDataBuilder) {
        LearningEnvironment environment = LearningEnvironmentBuilder.defaultBuilder().buildForTrainer();
        environment.deployingContext().initByClientObject(partDataBuilder);
        return datasetBuilder.build(LearningEnvironmentBuilder.defaultBuilder(), partCtxBuilder, partDataBuilder, environment);
    }

    public static <K, V, C extends Serializable, D extends AutoCloseable> Dataset<C, D> create(Ignite ignite, IgniteCache<K, V> upstreamCache, LearningEnvironmentBuilder envBuilder, PartitionContextBuilder<K, V, C> partCtxBuilder, PartitionDataBuilder<K, V, C, D> partDataBuilder, LearningEnvironment environment) {
        return DatasetFactory.create(new CacheBasedDatasetBuilder<K, V>(ignite, upstreamCache), envBuilder, partCtxBuilder, partDataBuilder, environment);
    }

    public static <K, V, C extends Serializable, D extends AutoCloseable> Dataset<C, D> create(Ignite ignite, IgniteCache<K, V> upstreamCache, PartitionContextBuilder<K, V, C> partCtxBuilder, PartitionDataBuilder<K, V, C, D> partDataBuilder) {
        return DatasetFactory.create(new CacheBasedDatasetBuilder<K, V>(ignite, upstreamCache), partCtxBuilder, partDataBuilder);
    }

    public static <K, V, C extends Serializable, CO extends Serializable> SimpleDataset<C> createSimpleDataset(DatasetBuilder<K, V> datasetBuilder, LearningEnvironmentBuilder envBuilder, PartitionContextBuilder<K, V, C> partCtxBuilder, Preprocessor<K, V> featureExtractor) {
        LearningEnvironment environment = LearningEnvironmentBuilder.defaultBuilder().buildForTrainer();
        environment.initDeployingContext(featureExtractor);
        return (SimpleDataset)DatasetFactory.create(datasetBuilder, envBuilder, partCtxBuilder, new SimpleDatasetDataBuilder(featureExtractor), environment).wrap(SimpleDataset::new);
    }

    public static <K, V, C extends Serializable, CO extends Serializable> SimpleDataset<C> createSimpleDataset(Ignite ignite, IgniteCache<K, V> upstreamCache, LearningEnvironmentBuilder envBuilder, PartitionContextBuilder<K, V, C> partCtxBuilder, Preprocessor<K, V> featureExtractor) {
        return DatasetFactory.createSimpleDataset(new CacheBasedDatasetBuilder<K, V>(ignite, upstreamCache), envBuilder, partCtxBuilder, featureExtractor);
    }

    public static <K, V, C extends Serializable, CO extends Serializable> SimpleLabeledDataset<C> createSimpleLabeledDataset(DatasetBuilder<K, V> datasetBuilder, LearningEnvironmentBuilder envBuilder, PartitionContextBuilder<K, V, C> partCtxBuilder, Preprocessor<K, V> vectorizer) {
        LearningEnvironment environment = LearningEnvironmentBuilder.defaultBuilder().buildForTrainer();
        environment.initDeployingContext(vectorizer);
        return (SimpleLabeledDataset)DatasetFactory.create(datasetBuilder, envBuilder, partCtxBuilder, new SimpleLabeledDatasetDataBuilder(vectorizer), environment).wrap(SimpleLabeledDataset::new);
    }

    public static <K, V, C extends Serializable, CO extends Serializable> SimpleLabeledDataset<C> createSimpleLabeledDataset(Ignite ignite, IgniteCache<K, V> upstreamCache, LearningEnvironmentBuilder envBuilder, PartitionContextBuilder<K, V, C> partCtxBuilder, Preprocessor<K, V> vectorizer) {
        return DatasetFactory.createSimpleLabeledDataset(new CacheBasedDatasetBuilder<K, V>(ignite, upstreamCache), envBuilder, partCtxBuilder, vectorizer);
    }

    public static <K, V, CO extends Serializable> SimpleDataset<EmptyContext> createSimpleDataset(DatasetBuilder<K, V> datasetBuilder, LearningEnvironmentBuilder envBuilder, Preprocessor<K, V> featureExtractor) {
        return DatasetFactory.createSimpleDataset(datasetBuilder, envBuilder, new EmptyContextBuilder(), featureExtractor);
    }

    public static <K, V, CO extends Serializable> SimpleDataset<EmptyContext> createSimpleDataset(Ignite ignite, IgniteCache<K, V> upstreamCache, LearningEnvironmentBuilder envBuilder, Preprocessor<K, V> featureExtractor) {
        return DatasetFactory.createSimpleDataset(new CacheBasedDatasetBuilder<K, V>(ignite, upstreamCache), envBuilder, featureExtractor);
    }

    public static <K, V, CO extends Serializable> SimpleDataset<EmptyContext> createSimpleDataset(Ignite ignite, IgniteCache<K, V> upstreamCache, Preprocessor<K, V> featureExtractor) {
        return DatasetFactory.createSimpleDataset(new CacheBasedDatasetBuilder<K, V>(ignite, upstreamCache), LearningEnvironmentBuilder.defaultBuilder(), featureExtractor);
    }

    public static <K, V, CO extends Serializable> SimpleLabeledDataset<EmptyContext> createSimpleLabeledDataset(DatasetBuilder<K, V> datasetBuilder, LearningEnvironmentBuilder envBuilder, Preprocessor<K, V> vectorizer) {
        return DatasetFactory.createSimpleLabeledDataset(datasetBuilder, envBuilder, new EmptyContextBuilder(), vectorizer);
    }

    public static <K, V, CO extends Serializable> SimpleLabeledDataset<EmptyContext> createSimpleLabeledDataset(Ignite ignite, LearningEnvironmentBuilder envBuilder, IgniteCache<K, V> upstreamCache, Preprocessor<K, V> vectorizer) {
        return DatasetFactory.createSimpleLabeledDataset(new CacheBasedDatasetBuilder<K, V>(ignite, upstreamCache), envBuilder, vectorizer);
    }

    public static <K, V, C extends Serializable, D extends AutoCloseable> Dataset<C, D> create(Map<K, V> upstreamMap, LearningEnvironmentBuilder envBuilder, int partitions, PartitionContextBuilder<K, V, C> partCtxBuilder, PartitionDataBuilder<K, V, C, D> partDataBuilder, LearningEnvironment environment) {
        return DatasetFactory.create(new LocalDatasetBuilder<K, V>(upstreamMap, partitions), envBuilder, partCtxBuilder, partDataBuilder, environment);
    }

    public static <K, V, C extends Serializable, CO extends Serializable> SimpleDataset<C> createSimpleDataset(Map<K, V> upstreamMap, int partitions, LearningEnvironmentBuilder envBuilder, PartitionContextBuilder<K, V, C> partCtxBuilder, Preprocessor<K, V> featureExtractor) {
        return DatasetFactory.createSimpleDataset(new LocalDatasetBuilder<K, V>(upstreamMap, partitions), envBuilder, partCtxBuilder, featureExtractor);
    }

    public static <K, V, C extends Serializable, CO extends Serializable> SimpleLabeledDataset<C> createSimpleLabeledDataset(Map<K, V> upstreamMap, int partitions, LearningEnvironmentBuilder envBuilder, PartitionContextBuilder<K, V, C> partCtxBuilder, Preprocessor<K, V> vectorizer) {
        return DatasetFactory.createSimpleLabeledDataset(new LocalDatasetBuilder<K, V>(upstreamMap, partitions), envBuilder, partCtxBuilder, vectorizer);
    }

    public static <K, V, CO extends Serializable> SimpleDataset<EmptyContext> createSimpleDataset(Map<K, V> upstreamMap, int partitions, LearningEnvironmentBuilder envBuilder, Preprocessor<K, V> featureExtractor) {
        return DatasetFactory.createSimpleDataset(new LocalDatasetBuilder<K, V>(upstreamMap, partitions), envBuilder, featureExtractor);
    }

    public static <K, V, CO extends Serializable> SimpleLabeledDataset<EmptyContext> createSimpleLabeledDataset(Map<K, V> upstreamMap, LearningEnvironmentBuilder envBuilder, int partitions, Preprocessor<K, V> vectorizer) {
        return DatasetFactory.createSimpleLabeledDataset(new LocalDatasetBuilder<K, V>(upstreamMap, partitions), envBuilder, vectorizer);
    }
}

