/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.inlinecolumn;

import java.util.Arrays;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.AbstractInlineIndexColumn;
import org.apache.ignite.internal.util.GridUnsafe;
import org.h2.table.Column;
import org.h2.value.Value;
import org.h2.value.ValueBytes;

public class BytesInlineIndexColumn
extends AbstractInlineIndexColumn {
    private final boolean compareBinaryUnsigned;

    public BytesInlineIndexColumn(Column col, boolean compareBinaryUnsigned) {
        this(col, 12, compareBinaryUnsigned);
    }

    BytesInlineIndexColumn(Column col, int type, boolean compareBinaryUnsigned) {
        super(col, type, (short)-1);
        this.compareBinaryUnsigned = compareBinaryUnsigned;
    }

    @Override
    protected int compare0(long pageAddr, int off, Value v, int type) {
        int i;
        if (this.type() != type) {
            return Integer.MIN_VALUE;
        }
        byte[] bytes = v.getBytesNoCopy();
        long addr = pageAddr + (long)off + 1L;
        int len1 = PageUtils.getShort((long)pageAddr, (int)(off + 1)) & Short.MAX_VALUE;
        addr += 2L;
        int len2 = bytes.length;
        int len = Math.min(len1, len2);
        if (this.compareBinaryUnsigned) {
            for (i = 0; i < len; ++i) {
                int b2;
                int b1 = GridUnsafe.getByte((long)(addr + (long)i)) & 0xFF;
                if (b1 == (b2 = bytes[i] & 0xFF)) continue;
                return Integer.signum(b1 - b2);
            }
        } else {
            for (i = 0; i < len; ++i) {
                byte b2;
                byte b1 = GridUnsafe.getByte((long)(addr + (long)i));
                if (b1 == (b2 = bytes[i])) continue;
                return Integer.signum(b1 - b2);
            }
        }
        int res = Integer.signum(len1 - len2);
        if (this.isValueFull(pageAddr, off)) {
            return res;
        }
        if (res >= 0) {
            return 1;
        }
        return -2;
    }

    @Override
    protected int put0(long pageAddr, int off, Value val, int maxSize) {
        assert (this.type() == val.getType());
        PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
        byte[] bytes = val.getBytes();
        if (bytes.length + 3 <= maxSize) {
            short size = (short)bytes.length;
            PageUtils.putShort((long)pageAddr, (int)(off + 1), (short)size);
            PageUtils.putBytes((long)pageAddr, (int)(off + 3), (byte[])bytes);
            return size + 3;
        }
        short size = (short)(maxSize - 3 | 0x8000);
        PageUtils.putShort((long)pageAddr, (int)(off + 1), (short)size);
        PageUtils.putBytes((long)pageAddr, (int)(off + 3), (byte[])Arrays.copyOfRange(bytes, 0, maxSize - 3));
        return maxSize;
    }

    @Override
    protected Value get0(long pageAddr, int off) {
        return ValueBytes.get((byte[])this.readBytes(pageAddr, off));
    }

    @Override
    protected int inlineSizeOf0(Value val) {
        assert (val.getType() == this.type());
        return val.getBytes().length + 3;
    }

    private boolean isValueFull(long pageAddr, int off) {
        return (PageUtils.getShort((long)pageAddr, (int)(off + 1)) & 0x8000) == 0;
    }
}

