/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.attributes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.attributes.SerializedName;
import hex.genmodel.attributes.Table;
import hex.genmodel.attributes.parameters.ColumnSpecifier;
import hex.genmodel.attributes.parameters.ParameterKey;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModelJsonReader {
    public static final String MODEL_DETAILS_FILE = "experimental/modelDetails.json";
    private static final Pattern ARRAY_PATTERN = Pattern.compile("\\[\\]");
    private static final Pattern JSON_PATH_PATTERN = Pattern.compile("\\.|\\[|\\]");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject parseModelJson(MojoReaderBackend mojoReaderBackend) {
        try (BufferedReader fileReader = mojoReaderBackend.getTextFile(MODEL_DETAILS_FILE);){
            Gson gson = new GsonBuilder().create();
            JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)fileReader, JsonObject.class);
            return jsonObject;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Table readTable(JsonObject modelJson, String tablePath) {
        Objects.requireNonNull(modelJson);
        JsonElement potentialTableJson = ModelJsonReader.findInJson((JsonElement)modelJson, tablePath);
        if (potentialTableJson.isJsonNull()) {
            System.out.println(String.format("Failed to extract element '%s' MojoModel dump.", tablePath));
            return null;
        }
        JsonObject tableJson = potentialTableJson.getAsJsonObject();
        int rowCount = tableJson.get("rowcount").getAsInt();
        JsonArray columns = ModelJsonReader.findInJson((JsonElement)tableJson, "columns").getAsJsonArray();
        int columnCount = columns.size();
        String[] columnHeaders = new String[columnCount];
        Table.ColumnType[] columnTypes = new Table.ColumnType[columnCount];
        String[] columnFormats = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            JsonObject column = columns.get(i).getAsJsonObject();
            columnHeaders[i] = column.get("description").getAsString();
            columnTypes[i] = Table.ColumnType.extractType(column.get("type").getAsString());
            columnFormats[i] = column.get("format").getAsString();
        }
        JsonArray dataColumns = ModelJsonReader.findInJson((JsonElement)tableJson, "data").getAsJsonArray();
        Object[][] data = new Object[columnCount][rowCount];
        for (int i = 0; i < columnCount; ++i) {
            JsonArray column = dataColumns.get(i).getAsJsonArray();
            block9: for (int j = 0; j < rowCount; ++j) {
                JsonElement cellValue = column.get(j);
                if (cellValue == null || !cellValue.isJsonPrimitive()) {
                    data[i][j] = null;
                    continue;
                }
                JsonPrimitive primitiveValue = cellValue.getAsJsonPrimitive();
                switch (columnTypes[i]) {
                    case LONG: {
                        if (primitiveValue.isNumber()) {
                            data[i][j] = primitiveValue.getAsLong();
                            continue block9;
                        }
                        data[i][j] = null;
                        continue block9;
                    }
                    case DOUBLE: {
                        if (!primitiveValue.isJsonNull()) {
                            data[i][j] = primitiveValue.getAsDouble();
                            continue block9;
                        }
                        data[i][j] = null;
                        continue block9;
                    }
                    case FLOAT: {
                        data[i][j] = !primitiveValue.isJsonNull() ? Float.valueOf(primitiveValue.getAsFloat()) : null;
                    }
                    case INT: {
                        data[i][j] = primitiveValue.isNumber() ? Integer.valueOf(primitiveValue.getAsInt()) : null;
                    }
                    case STRING: {
                        data[i][j] = primitiveValue.getAsString();
                    }
                }
            }
        }
        return new Table(tableJson.get("name").getAsString(), tableJson.get("description").getAsString(), new String[rowCount], columnHeaders, columnTypes, null, columnFormats, data);
    }

    public static <T> void fillObjects(List<T> objects, JsonArray from) {
        for (int i = 0; i < from.size(); ++i) {
            JsonElement jsonElement = from.get(i);
            ModelJsonReader.fillObject(objects.get(i), jsonElement, "");
        }
    }

    public static void fillObject(Object object, JsonElement from, String elementPath) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(elementPath);
        JsonElement jsonSourceObject = ModelJsonReader.findInJson(from, elementPath);
        if (jsonSourceObject instanceof JsonNull) {
            System.out.println(String.format("Element '%s' not found in JSON. Skipping. Object '%s' is not populated by values.", elementPath, object.getClass().getName()));
            return;
        }
        JsonObject jsonSourceObj = jsonSourceObject.getAsJsonObject();
        Class<?> aClass = object.getClass();
        Field[] declaredFields = aClass.getFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            String name;
            Field field = declaredFields[i];
            if (Modifier.isTransient(field.getModifiers())) continue;
            Class<Object> type = field.getType();
            SerializedName serializedName = field.getAnnotation(SerializedName.class);
            String fieldName = serializedName == null ? ((name = field.getName()).charAt(0) == '_' ? name.substring(1) : name) : serializedName.value();
            try {
                JsonElement jsonElement;
                field.setAccessible(true);
                assert (field.isAccessible());
                Object value = null;
                if (type.isAssignableFrom(Object.class)) {
                    jsonElement = jsonSourceObj.get(fieldName);
                    if (jsonElement != null) {
                        JsonElement typeElement = jsonSourceObj.get("type");
                        TypeHint typeHint = type != null && !typeElement.isJsonNull() ? TypeHint.fromStringIgnoreCase(typeElement.getAsString()) : null;
                        value = ModelJsonReader.convertBasedOnJsonType(jsonElement, typeHint);
                    }
                } else if (type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Double.class)) {
                    jsonElement = jsonSourceObj.get(fieldName);
                    if (jsonElement != null && !jsonElement.isJsonNull()) {
                        value = jsonElement.getAsDouble();
                    }
                } else if (type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class)) {
                    jsonElement = jsonSourceObj.get(fieldName);
                    if (jsonElement != null && !jsonElement.isJsonNull()) {
                        value = jsonElement.getAsInt();
                    }
                } else if (type.isAssignableFrom(Long.TYPE) || type.isAssignableFrom(Long.class)) {
                    jsonElement = jsonSourceObj.get(fieldName);
                    if (jsonElement != null && !jsonElement.isJsonNull()) {
                        value = jsonElement.getAsLong();
                    }
                } else if (type.isAssignableFrom(String.class)) {
                    jsonElement = jsonSourceObj.get(fieldName);
                    if (jsonElement != null && !jsonElement.isJsonNull()) {
                        value = jsonElement.getAsString();
                    }
                } else if (type.isAssignableFrom(Table.class) && (jsonElement = jsonSourceObj.get(fieldName)) != null && !jsonElement.isJsonNull()) {
                    value = ModelJsonReader.readTable(jsonElement.getAsJsonObject(), serializedName != null ? serializedName.insideElementPath() : "");
                }
                if (value == null) continue;
                field.set(object, value);
                continue;
            }
            catch (IllegalAccessException e) {
                System.out.println(String.format("Field '%s' could not be accessed. Ignoring.", fieldName));
                continue;
            }
            catch (ClassCastException | UnsupportedOperationException e) {
                System.out.println(String.format("Field '%s' could not be casted to '%s'. Ignoring.", fieldName, type.toString()));
            }
        }
    }

    private static Object convertBasedOnJsonType(JsonElement convertFrom, TypeHint typeHint) {
        Object convertTo;
        if (convertFrom.isJsonNull()) {
            convertTo = null;
        } else if (convertFrom.isJsonArray()) {
            JsonArray array = convertFrom.getAsJsonArray();
            if (typeHint == null) {
                convertTo = null;
            } else {
                switch (typeHint) {
                    case DOUBLE_ARR: {
                        double[] arrD = new double[array.size()];
                        for (int i = 0; i < array.size(); ++i) {
                            arrD[i] = array.get(i).getAsDouble();
                        }
                        convertTo = arrD;
                        break;
                    }
                    case FLOAT_ARR: {
                        double[] arrF = new double[array.size()];
                        for (int i = 0; i < array.size(); ++i) {
                            arrF[i] = array.get(i).getAsDouble();
                        }
                        convertTo = arrF;
                        break;
                    }
                    case STRING_ARR: {
                        String[] arrS = new String[array.size()];
                        for (int i = 0; i < array.size(); ++i) {
                            arrS[i] = array.get(i).getAsString();
                        }
                        convertTo = arrS;
                        break;
                    }
                    default: {
                        convertTo = null;
                    }
                }
            }
        } else if (convertFrom.isJsonPrimitive()) {
            JsonPrimitive convertedPrimitive = convertFrom.getAsJsonPrimitive();
            if (convertedPrimitive.isBoolean()) {
                convertTo = convertedPrimitive.getAsBoolean();
            } else if (convertedPrimitive.isString()) {
                convertTo = convertedPrimitive.getAsString();
            } else if (convertedPrimitive.isNumber()) {
                if (typeHint == null) {
                    convertTo = convertedPrimitive.getAsDouble();
                } else {
                    switch (typeHint) {
                        case INT: {
                            convertTo = convertedPrimitive.getAsInt();
                            break;
                        }
                        case FLOAT: {
                            convertTo = Float.valueOf(convertedPrimitive.getAsFloat());
                            break;
                        }
                        case DOUBLE: {
                            convertTo = convertedPrimitive.getAsDouble();
                            break;
                        }
                        case LONG: {
                            convertTo = convertedPrimitive.getAsLong();
                            break;
                        }
                        default: {
                            convertTo = convertedPrimitive.getAsDouble();
                            break;
                        }
                    }
                }
            } else {
                convertTo = null;
            }
        } else {
            convertTo = convertFrom.isJsonObject() ? ModelJsonReader.convertJsonObject(convertFrom.getAsJsonObject()) : null;
        }
        return convertTo;
    }

    private static Object convertJsonObject(JsonObject convertFrom) {
        JsonElement meta = convertFrom.get("__meta");
        if (meta == null || meta.isJsonNull()) {
            return null;
        }
        String schemaName = ModelJsonReader.findInJson(meta, "schema_name").getAsString();
        if ("FrameKeyV3".equals(schemaName) || "ModelKeyV3".equals(schemaName)) {
            String name = convertFrom.get("name").getAsString();
            String type = convertFrom.get("type").getAsString();
            ParameterKey.Type convertedType = ModelJsonReader.convertKeyType(type);
            String url = convertFrom.get("URL").getAsString();
            return new ParameterKey(name, convertedType, url);
        }
        if ("ColSpecifierV3".equals(schemaName)) {
            String columnName = convertFrom.get("column_name").getAsString();
            JsonElement is_member_of_frames = convertFrom.get("is_member_of_frames");
            String[] memberOfFrames = is_member_of_frames.isJsonArray() ? ModelJsonReader.convertStringJsonArray(convertFrom.get("is_member_of_frames").getAsJsonArray()) : null;
            return new ColumnSpecifier(columnName, memberOfFrames);
        }
        throw new UnsupportedOperationException(String.format("Object not supported: \n %s ", convertFrom.toString()));
    }

    private static String[] convertStringJsonArray(JsonArray jsonArray) {
        Objects.requireNonNull(jsonArray);
        if (jsonArray.isJsonNull()) {
            return null;
        }
        String[] strings = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonElement potentialStringMember = jsonArray.get(i);
            if (potentialStringMember.isJsonNull()) continue;
            strings[i] = jsonArray.get(i).getAsString();
        }
        return strings;
    }

    private static final ParameterKey.Type convertKeyType(String type) {
        if ("Key<Frame>".equals(type)) {
            return ParameterKey.Type.FRAME;
        }
        if ("Key<Model>".equals(type)) {
            return ParameterKey.Type.MODEL;
        }
        return ParameterKey.Type.GENERIC;
    }

    protected static JsonElement findInJson(JsonElement jsonElement, String jsonPath) {
        String[] route = JSON_PATH_PATTERN.split(jsonPath);
        JsonElement result = jsonElement;
        for (String key : route) {
            if ((key = key.trim()).isEmpty()) continue;
            if (result == null) {
                result = JsonNull.INSTANCE;
                break;
            }
            if (result.isJsonObject()) {
                result = ((JsonObject)result).get(key);
                continue;
            }
            if (!result.isJsonArray()) break;
            int value = Integer.valueOf(key) - 1;
            result = ((JsonArray)result).get(value);
        }
        return result;
    }

    public static boolean elementExists(JsonElement jsonElement, String jsonPath) {
        boolean isEmpty = ModelJsonReader.findInJson(jsonElement, jsonPath) instanceof JsonNull;
        return !isEmpty;
    }

    private static enum TypeHint {
        INT,
        FLOAT,
        DOUBLE,
        LONG,
        DOUBLE_ARR,
        FLOAT_ARR,
        STRING_ARR;


        private static TypeHint fromStringIgnoreCase(String from) {
            try {
                Matcher matcher = ARRAY_PATTERN.matcher(from);
                String transformedType = matcher.replaceAll("_ARR");
                return TypeHint.valueOf(transformedType.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

