/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.thin.cache;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.yardstickframework.BenchmarkConfiguration;

public class IgniteThinBenchmarkUtils {
    public static String getLocalIp(BenchmarkConfiguration cfg) throws SocketException {
        List<String> hostList = IgniteThinBenchmarkUtils.drvHostList(cfg);
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface n = e.nextElement();
            Enumeration<InetAddress> ee = n.getInetAddresses();
            while (ee.hasMoreElements()) {
                InetAddress i = ee.nextElement();
                if (!hostList.contains(i.getHostAddress())) continue;
                return i.getHostAddress();
            }
        }
        return null;
    }

    public static List<String> drvHostList(BenchmarkConfiguration cfg) {
        String driverHosts = (String)cfg.customProperties().get("DRIVER_HOSTS");
        String[] hostArr = driverHosts.split(",");
        ArrayList<String> res = new ArrayList<String>(hostArr.length);
        for (String host : hostArr) {
            if (host.equals("localhost")) {
                res.add("127.0.0.1");
                continue;
            }
            res.add(host);
        }
        return res;
    }

    public static String[] servHostArr(BenchmarkConfiguration cfg) {
        String servHosts = (String)cfg.customProperties().get("SERVER_HOSTS");
        return servHosts.split(",");
    }
}

