/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.events.Event;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgnitePutGetWithPageReplacements
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    private static final String CACHE_NAME = "CacheWithReplacement";
    private volatile int replCntr = 0x3FFFFFFF;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        int progress = 0;
        final AtomicBoolean replacement = new AtomicBoolean();
        this.ignite().events().remoteListen((IgniteBiPredicate)new IgniteBiPredicate<UUID, Event>(){

            public boolean apply(UUID uuid, Event evt) {
                if (evt.type() == 142) {
                    replacement.set(true);
                    return false;
                }
                return true;
            }
        }, null, new int[]{142});
        int portion = 100;
        HashMap<Integer, TestValue> putMap = new HashMap<Integer, TestValue>(portion, 1.0f);
        while (progress < 2 * this.replCntr) {
            putMap.clear();
            for (int i = 0; i < portion; ++i) {
                putMap.put(progress + i, new TestValue(progress + i));
            }
            this.cache().putAll(putMap);
            if ((progress += portion) % 1000 == 0) {
                BenchmarkUtils.println((String)("progress=" + progress));
            }
            if (!replacement.compareAndSet(true, false)) continue;
            if (this.replCntr != 0x3FFFFFFF) {
                throw new Exception("Invalid expected val: " + this.replCntr);
            }
            this.replCntr = progress;
            BenchmarkUtils.println((String)("replCntr=" + this.replCntr));
        }
        BenchmarkUtils.println((String)("DataRegion fullfill complete. progress=" + progress + " replCntr=" + this.replCntr + "."));
        int cacheSize = 0;
        try (QueryCursor cursor = this.cache.query((Query)new ScanQuery());){
            for (Object o : cursor) {
                ++cacheSize;
            }
        }
        BenchmarkUtils.println((String)("cache size=" + cacheSize));
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().getOrCreateCache(CACHE_NAME);
    }

    public boolean test(Map<Object, Object> map) throws Exception {
        int portion = 100;
        HashMap<Integer, TestValue> putMap = new HashMap<Integer, TestValue>(portion, 1.0f);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        for (int i = 0; i < portion; ++i) {
            int val = rnd.nextInt(this.replCntr / 2);
            putMap.put(val, new TestValue(val));
        }
        this.cache().putAll(putMap);
        return true;
    }

    private static class TestValue
    implements Serializable {
        private int id;
        @QuerySqlField(index=true)
        private final byte[] payload = new byte[64];

        private TestValue(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public boolean hasPayload() {
            return this.payload != null;
        }
    }
}

