/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.model.Person8NotIndexed;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteCreateIndexBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    private static final String CACHE_NAME = "Person8NotIndexed";
    private CacheConfiguration<Integer, Object> personCacheCfg = this.getCfg();

    public boolean test(Map<Object, Object> map) throws Exception {
        BenchmarkUtils.println((String)("IgniteCreateIndexBenchmark started creating index over the cache [size=" + this.cache().size(new CachePeekMode[0]) + ']'));
        SqlFieldsQuery qry = new SqlFieldsQuery("CREATE INDEX idx_person8 ON Person8NotIndexed (val2)");
        long start = System.currentTimeMillis();
        this.cache().query(qry).getAll();
        long stop = System.currentTimeMillis();
        BenchmarkUtils.println((String)"IgniteCreateIndexBenchmark ==========================================");
        BenchmarkUtils.println((String)("IgniteCreateIndexBenchmark created index in " + (stop - start) + " ms"));
        BenchmarkUtils.println((String)"IgniteCreateIndexBenchmark ==========================================");
        return false;
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().getOrCreateCache(this.personCacheCfg);
    }

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        int quantity = this.args.preloadAmount();
        if (quantity < 1) {
            throw new IllegalArgumentException("Invalid number of entries: " + quantity);
        }
        BenchmarkUtils.println((String)("Preload entries [quantity=" + quantity + ']'));
        int testThreads = cfg.threads();
        if (testThreads != 1) {
            throw new IllegalArgumentException("Invalid number of threads. IgniteCreateIndexBenchmark should be run with a single thread. [threads=" + testThreads + ']');
        }
        int threads = Runtime.getRuntime().availableProcessors();
        BenchmarkUtils.println((String)("Preloader thread pool size [threads=" + threads + ']'));
        BenchmarkUtils.println((String)("Local node: " + this.ignite().cluster().localNode()));
        BenchmarkUtils.println((String)("Cluster nodes: " + this.ignite().cluster().nodes()));
        try (final IgniteDataStreamer streamer = this.ignite().dataStreamer(CACHE_NAME);){
            ExecutorService executor = Executors.newFixedThreadPool(threads);
            ArrayList<Future<Void>> futs = new ArrayList<Future<Void>>();
            final LongAdder cntr = new LongAdder();
            long start = System.currentTimeMillis();
            int batchSize = 1000;
            final int[] ranges = IgniteCreateIndexBenchmark.getRanges(quantity, threads, 1000);
            int i = 0;
            while (i < threads) {
                final int n = i++;
                futs.add(executor.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        if (ranges[n] < ranges[n + 1]) {
                            HashMap<Integer, Person8NotIndexed> batch = new HashMap<Integer, Person8NotIndexed>();
                            for (int val = ranges[n]; val < ranges[n + 1]; ++val) {
                                Person8NotIndexed person = IgniteCreateIndexBenchmark.createFromValue(val);
                                batch.put(val, person);
                                cntr.increment();
                            }
                            streamer.addData(batch);
                        }
                        return null;
                    }
                }));
            }
            for (Future future : futs) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    BenchmarkUtils.println((String)("Exception on node [id=" + this.ignite().cluster().localNode().id() + ", exc=" + e + ']'));
                }
            }
            streamer.flush();
            long stop = System.currentTimeMillis();
            BenchmarkUtils.println((String)("Node [id=" + this.ignite().cluster().localNode().id() + "] populated cache with [cntr=" + cntr.sum() + "]  entries in " + (stop - start) + "ms"));
        }
        BenchmarkUtils.println((String)("Total cache size after preloading [size=" + this.cache().size(new CachePeekMode[0]) + ']'));
    }

    private static int[] getRanges(int range, int parts, int batchSize) {
        assert (range > 0) : "range > 0 ";
        assert (parts > 0) : "parts > 0 ";
        assert (batchSize > 0) : "batchSize > 0 ";
        int[] ranges = new int[parts + 1];
        ranges[0] = 0;
        int rangesSize = Math.max(range / parts, batchSize);
        for (int i = 1; i <= parts; ++i) {
            int nextVal = ranges[i - 1] + rangesSize;
            ranges[i] = nextVal < range ? nextVal : range;
        }
        ranges[parts] = range;
        return ranges;
    }

    private CacheConfiguration<Integer, Object> getCfg() {
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(Integer.class.getName());
        entity.setValueType(Person8NotIndexed.class.getName());
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("val1", Integer.class.getName());
        fields.put("val2", Integer.class.getName());
        fields.put("val3", Integer.class.getName());
        fields.put("val4", Integer.class.getName());
        fields.put("val5", Integer.class.getName());
        fields.put("val6", Integer.class.getName());
        fields.put("val7", Integer.class.getName());
        fields.put("val8", Integer.class.getName());
        entity.setFields(fields);
        entity.setKeyFieldName("val1");
        this.personCacheCfg = new CacheConfiguration(CACHE_NAME);
        this.personCacheCfg.setSqlSchema("PUBLIC").setQueryEntities(Collections.singleton(entity));
        return this.personCacheCfg;
    }

    private static Person8NotIndexed createFromValue(int val) {
        Person8NotIndexed person = new Person8NotIndexed();
        person.setVal1(val);
        person.setVal2(val % 5);
        person.setVal3(val % 11);
        person.setVal4(val % 51);
        person.setVal5(val % 101);
        person.setVal6(val % 503);
        person.setVal7(val % 1001);
        person.setVal8(val % 5003);
        return person;
    }
}

