/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.session.pool;

import com.datastax.driver.core.Session;
import org.apache.ignite.cache.store.cassandra.common.CassandraHelper;

public class IdleSession {
    private Session ses;
    private long expirationTimeout;
    private long time;

    public IdleSession(Session session, long l) {
        this.ses = session;
        this.expirationTimeout = l;
        this.time = System.currentTimeMillis();
    }

    public boolean expired() {
        return this.expirationTimeout > 0L && System.currentTimeMillis() - this.time > this.expirationTimeout;
    }

    public Session driverSession() {
        return this.ses;
    }

    public void release() {
        CassandraHelper.closeSession(this.ses);
        this.ses = null;
    }
}

