/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.persistence;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.apache.ignite.IgniteException;

public class PojoFieldAccessor {
    private PropertyDescriptor desc;
    private Field descField;
    private Field field;

    public PojoFieldAccessor(PropertyDescriptor propertyDescriptor, Field field) {
        if (propertyDescriptor.getReadMethod() == null) {
            throw new IllegalArgumentException("Field '" + propertyDescriptor.getName() + "' of the class instance '" + propertyDescriptor.getPropertyType().getName() + "' doesn't provide getter method");
        }
        propertyDescriptor.getReadMethod().setAccessible(true);
        if (propertyDescriptor.getWriteMethod() != null) {
            propertyDescriptor.getWriteMethod().setAccessible(true);
        }
        this.desc = propertyDescriptor;
        this.descField = field;
    }

    public PojoFieldAccessor(Field field) {
        field.setAccessible(true);
        this.field = field;
    }

    public String getName() {
        return this.desc != null ? this.desc.getName() : this.field.getName();
    }

    public boolean isReadOnly() {
        return this.desc != null && this.desc.getWriteMethod() == null;
    }

    public Annotation getAnnotation(Class clazz) {
        if (this.field != null) {
            return this.field.getAnnotation(clazz);
        }
        Object t = this.desc.getReadMethod().getAnnotation(clazz);
        if (t != null) {
            return t;
        }
        t = this.desc.getWriteMethod() == null ? null : this.desc.getWriteMethod().getAnnotation(clazz);
        Object v0 = t;
        if (t != null) {
            return t;
        }
        return this.descField == null ? null : (Annotation)this.descField.getAnnotation(clazz);
    }

    public Object getValue(Object object) {
        try {
            return this.desc != null ? this.desc.getReadMethod().invoke(object, new Object[0]) : this.field.get(object);
        }
        catch (Throwable throwable) {
            throw new IgniteException("Failed to get value of the field '" + this.getName() + "' from the instance  of '" + object.getClass().toString() + "' class", throwable);
        }
    }

    public void setValue(Object object, Object object2) {
        if (this.isReadOnly()) {
            throw new IgniteException("Can't assign value to read-only field '" + this.getName() + "' of the instance  of '" + object.getClass().toString() + "' class");
        }
        try {
            if (this.desc != null) {
                this.desc.getWriteMethod().invoke(object, object2);
            } else {
                this.field.set(object, object2);
            }
        }
        catch (Throwable throwable) {
            throw new IgniteException("Failed to set value of the field '" + this.getName() + "' of the instance  of '" + object.getClass().toString() + "' class", throwable);
        }
    }

    public Class getFieldType() {
        return this.desc != null ? this.desc.getPropertyType() : this.field.getType();
    }
}

