/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.common;

import java.util.Random;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;

public class RandomSleeper {
    private int min;
    private int max;
    private int incr;
    private IgniteLogger log;
    private Random random = new Random(System.currentTimeMillis());
    private int summary;

    public RandomSleeper(int n, int n2, int n3, IgniteLogger igniteLogger) {
        if (n <= 0) {
            throw new IllegalArgumentException("Incorrect min time specified: " + n);
        }
        if (n2 <= n) {
            throw new IllegalArgumentException("Incorrect max time specified: " + n2);
        }
        if (n3 < 10) {
            throw new IllegalArgumentException("Incorrect increment specified: " + n3);
        }
        this.min = n;
        this.max = n2;
        this.incr = n3;
        this.log = igniteLogger;
    }

    public void sleep() {
        try {
            int n = this.random.nextInt(this.max - this.min + 1) + this.min;
            if (this.log != null) {
                this.log.info("Sleeping for " + n + "ms");
            }
            Thread.sleep(n);
            this.summary += n;
            if (this.log != null) {
                this.log.info("Sleep completed");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IgniteException("Random sleep interrupted", (Throwable)interruptedException);
        }
        this.min += this.incr;
        this.max += this.incr;
    }

    public int getSleepSummary() {
        return this.summary;
    }
}

