/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.auditing;

import java.time.temporal.TemporalAccessor;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.auditing.AuditableBeanWrapper;
import org.springframework.data.auditing.DefaultAuditableBeanWrapperFactory;
import org.springframework.data.domain.Auditable;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.util.Optionals;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public class MappingAuditableBeanWrapperFactory
extends DefaultAuditableBeanWrapperFactory {
    private final PersistentEntities entities;
    private final Map<Class<?>, MappingAuditingMetadata> metadataCache;

    public MappingAuditableBeanWrapperFactory(PersistentEntities entities) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        this.entities = entities;
        this.metadataCache = new ConcurrentReferenceHashMap();
    }

    @Override
    public Optional<AuditableBeanWrapper> getBeanWrapperFor(Object source) {
        return Optional.of(source).flatMap(it -> {
            if (it instanceof Auditable) {
                return super.getBeanWrapperFor(source);
            }
            Class<?> type = it.getClass();
            return this.entities.getPersistentEntity(type).map(entity -> {
                MappingAuditingMetadata metadata = this.metadataCache.computeIfAbsent(type, key -> new MappingAuditingMetadata((PersistentEntity<?, ? extends PersistentProperty<?>>)entity));
                return Optional.ofNullable(metadata.isAuditable() ? new MappingMetadataAuditableBeanWrapper(entity.getPropertyAccessor(it), metadata) : null);
            }).orElseGet(() -> super.getBeanWrapperFor(source));
        });
    }

    static class MappingMetadataAuditableBeanWrapper
    extends DefaultAuditableBeanWrapperFactory.DateConvertingAuditableBeanWrapper {
        private final PersistentPropertyAccessor accessor;
        private final MappingAuditingMetadata metadata;

        public MappingMetadataAuditableBeanWrapper(PersistentPropertyAccessor accessor, MappingAuditingMetadata metadata) {
            Assert.notNull((Object)accessor, (String)"PersistentPropertyAccessor must not be null!");
            Assert.notNull((Object)metadata, (String)"Auditing metadata must not be null!");
            this.accessor = accessor;
            this.metadata = metadata;
        }

        @Override
        public Object setCreatedBy(Object value) {
            this.metadata.createdByProperty.ifPresent(it -> this.accessor.setProperty((PersistentProperty<?>)it, value));
            return value;
        }

        @Override
        public TemporalAccessor setCreatedDate(TemporalAccessor value) {
            return this.setDateProperty(this.metadata.createdDateProperty, value);
        }

        @Override
        public Object setLastModifiedBy(Object value) {
            return this.setProperty(this.metadata.lastModifiedByProperty, value);
        }

        @Override
        public Optional<TemporalAccessor> getLastModifiedDate() {
            return this.getAsTemporalAccessor(this.metadata.lastModifiedDateProperty.map(this.accessor::getProperty), TemporalAccessor.class);
        }

        @Override
        public TemporalAccessor setLastModifiedDate(TemporalAccessor value) {
            return this.setDateProperty(this.metadata.lastModifiedDateProperty, value);
        }

        private <T, P extends PersistentProperty<?>> T setProperty(Optional<P> property, T value) {
            property.ifPresent(it -> this.accessor.setProperty((PersistentProperty<?>)it, value));
            return value;
        }

        private <P extends PersistentProperty<?>> TemporalAccessor setDateProperty(Optional<P> property, TemporalAccessor value) {
            property.ifPresent(it -> this.accessor.setProperty((PersistentProperty<?>)it, this.getDateValueToSet(value, it.getType(), this.accessor.getBean())));
            return value;
        }
    }

    static class MappingAuditingMetadata {
        private final Optional<? extends PersistentProperty<?>> createdByProperty;
        private final Optional<? extends PersistentProperty<?>> createdDateProperty;
        private final Optional<? extends PersistentProperty<?>> lastModifiedByProperty;
        private final Optional<? extends PersistentProperty<?>> lastModifiedDateProperty;

        public MappingAuditingMetadata(PersistentEntity<?, ? extends PersistentProperty<?>> entity) {
            Assert.notNull(entity, (String)"PersistentEntity must not be null!");
            this.createdByProperty = Optional.ofNullable(entity.getPersistentProperty(CreatedBy.class));
            this.createdDateProperty = Optional.ofNullable(entity.getPersistentProperty(CreatedDate.class));
            this.lastModifiedByProperty = Optional.ofNullable(entity.getPersistentProperty(LastModifiedBy.class));
            this.lastModifiedDateProperty = Optional.ofNullable(entity.getPersistentProperty(LastModifiedDate.class));
        }

        public boolean isAuditable() {
            return Optionals.isAnyPresent(this.createdByProperty, this.createdDateProperty, this.lastModifiedByProperty, this.lastModifiedDateProperty);
        }
    }
}

