/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.tracing;

import java.util.Collections;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.lang.IgniteExperimental;
import org.apache.ignite.spi.tracing.Scope;
import org.apache.ignite.spi.tracing.TracingConfigurationCoordinates;
import org.apache.ignite.spi.tracing.TracingConfigurationParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IgniteExperimental
public interface TracingConfigurationManager {
    public static final TracingConfigurationParameters DEFAULT_TX_CONFIGURATION = new TracingConfigurationParameters.Builder().withSamplingRate(0.0).withIncludedScopes(Collections.emptySet()).build();
    public static final TracingConfigurationParameters DEFAULT_EXCHANGE_CONFIGURATION = new TracingConfigurationParameters.Builder().withSamplingRate(0.0).withIncludedScopes(Collections.emptySet()).build();
    public static final TracingConfigurationParameters DEFAULT_DISCOVERY_CONFIGURATION = new TracingConfigurationParameters.Builder().withSamplingRate(0.0).withIncludedScopes(Collections.emptySet()).build();
    public static final TracingConfigurationParameters DEFAULT_COMMUNICATION_CONFIGURATION = new TracingConfigurationParameters.Builder().withSamplingRate(0.0).withIncludedScopes(Collections.emptySet()).build();
    public static final TracingConfigurationParameters NOOP_CONFIGURATION = new TracingConfigurationParameters.Builder().withSamplingRate(0.0).withIncludedScopes(Collections.emptySet()).build();

    public void set(@NotNull TracingConfigurationCoordinates var1, @NotNull TracingConfigurationParameters var2) throws IgniteException;

    @NotNull
    default public TracingConfigurationParameters get(@NotNull TracingConfigurationCoordinates coordinates) throws IgniteException {
        switch (coordinates.scope()) {
            case TX: {
                return DEFAULT_TX_CONFIGURATION;
            }
            case EXCHANGE: {
                return DEFAULT_EXCHANGE_CONFIGURATION;
            }
            case DISCOVERY: {
                return DEFAULT_DISCOVERY_CONFIGURATION;
            }
            case COMMUNICATION: {
                return DEFAULT_COMMUNICATION_CONFIGURATION;
            }
        }
        return NOOP_CONFIGURATION;
    }

    @NotNull
    public Map<TracingConfigurationCoordinates, TracingConfigurationParameters> getAll(@Nullable Scope var1) throws IgniteException;

    public void reset(@NotNull TracingConfigurationCoordinates var1) throws IgniteException;

    public void resetAll(@Nullable Scope var1) throws IgniteException;
}

