/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.compute;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;

public class VisorComputeMonitoringHolder {
    public static final String COMPUTE_MONITORING_HOLDER_KEY = "VISOR_COMPUTE_MONITORING_KEY";
    private final Map<String, Boolean> listenVisor = new HashMap<String, Boolean>();
    private boolean cleanupStopped = true;
    protected static final int CLEANUP_TIMEOUT = 120000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCollect(IgniteEx ignite, String visorKey) {
        Map<String, Boolean> map = this.listenVisor;
        synchronized (map) {
            if (this.cleanupStopped) {
                this.scheduleCleanupJob(ignite);
                this.cleanupStopped = false;
            }
            this.listenVisor.put(visorKey, Boolean.TRUE);
            ignite.events().enableLocal(VisorTaskUtils.VISOR_TASK_EVTS);
        }
    }

    private boolean tryDisableEvents(IgniteEx ignite) {
        if (!this.listenVisor.values().contains(Boolean.TRUE)) {
            this.listenVisor.clear();
            ignite.events().disableLocal(VisorTaskUtils.VISOR_TASK_EVTS);
        }
        return ignite.allEventsUserRecordable(VisorTaskUtils.VISOR_TASK_EVTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCollect(IgniteEx g, String visorKey) {
        Map<String, Boolean> map = this.listenVisor;
        synchronized (map) {
            this.listenVisor.remove(visorKey);
            this.tryDisableEvents(g);
        }
    }

    private void scheduleCleanupJob(final IgniteEx ignite) {
        ignite.context().timeout().addTimeoutObject(new GridTimeoutObjectAdapter(120000L){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTimeout() {
                Map map = VisorComputeMonitoringHolder.this.listenVisor;
                synchronized (map) {
                    if (VisorComputeMonitoringHolder.this.tryDisableEvents(ignite)) {
                        for (String visorKey : VisorComputeMonitoringHolder.this.listenVisor.keySet()) {
                            VisorComputeMonitoringHolder.this.listenVisor.put(visorKey, Boolean.FALSE);
                        }
                        VisorComputeMonitoringHolder.this.scheduleCleanupJob(ignite);
                    } else {
                        VisorComputeMonitoringHolder.this.cleanupStopped = true;
                    }
                }
            }
        });
    }

    public String toString() {
        return S.toString(VisorComputeMonitoringHolder.class, this);
    }
}

