/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.schema;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryIndexing;
import org.apache.ignite.internal.processors.query.QueryTypeDescriptorImpl;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCachePartitionWorker;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheStat;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitor;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexOperationCancellationToken;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorkerFuture;
import org.jetbrains.annotations.Nullable;

public class SchemaIndexCacheVisitorImpl
implements SchemaIndexCacheVisitor {
    private final boolean collectStat = IgniteSystemProperties.getBoolean("IGNITE_ENABLE_EXTRA_INDEX_REBUILD_LOGGING", false);
    private final GridCacheContext cctx;
    private final SchemaIndexOperationCancellationToken cancel;
    protected final GridFutureAdapter<Void> buildIdxFut;
    protected IgniteLogger log;

    public SchemaIndexCacheVisitorImpl(GridCacheContext cctx, @Nullable SchemaIndexOperationCancellationToken cancel, GridFutureAdapter<Void> buildIdxFut) {
        assert (Objects.nonNull(cctx));
        assert (Objects.nonNull(buildIdxFut));
        if (cctx.isNear()) {
            cctx = ((GridNearCacheAdapter)cctx.cache()).dht().context();
        }
        this.cctx = cctx;
        this.buildIdxFut = buildIdxFut;
        this.cancel = cancel;
        this.log = cctx.kernalContext().log(this.getClass());
    }

    @Override
    public void visit(SchemaIndexCacheVisitorClosure clo) {
        assert (Objects.nonNull(clo));
        List<GridDhtLocalPartition> locParts = this.cctx.topology().localPartitions();
        if (locParts.isEmpty()) {
            this.buildIdxFut.onDone();
            return;
        }
        this.cctx.group().metrics().addIndexBuildCountPartitionsLeft(locParts.size());
        this.beforeExecute();
        AtomicInteger partsCnt = new AtomicInteger(locParts.size());
        AtomicBoolean stop = new AtomicBoolean();
        GridCompoundFuture buildIdxCompoundFut = new GridCompoundFuture();
        for (GridDhtLocalPartition locPart : locParts) {
            GridWorkerFuture<SchemaIndexCacheStat> workerFut = new GridWorkerFuture<SchemaIndexCacheStat>();
            SchemaIndexCachePartitionWorker worker = new SchemaIndexCachePartitionWorker(this.cctx, locPart, stop, this.cancel, clo, workerFut, partsCnt);
            workerFut.setWorker(worker);
            buildIdxCompoundFut.add(workerFut);
            this.cctx.kernalContext().buildIndexExecutorService().execute(worker);
        }
        buildIdxCompoundFut.listen(fut -> {
            Throwable err = fut.error();
            if (Objects.isNull(err) && this.collectStat && this.log.isInfoEnabled()) {
                try {
                    GridCompoundFuture compoundFut = (GridCompoundFuture)fut;
                    SchemaIndexCacheStat resStat = new SchemaIndexCacheStat();
                    compoundFut.futures().stream().map(IgniteInternalFuture::result).filter(Objects::nonNull).forEach(resStat::accumulate);
                    this.log.info(this.indexStatStr(resStat));
                }
                catch (Exception e) {
                    this.log.error("Error when trying to print index build/rebuild statistics [cacheName=" + this.cctx.cache().name() + ", grpName=" + this.cctx.group().name() + "]", e);
                }
            }
            this.buildIdxFut.onDone(err);
        });
        buildIdxCompoundFut.markInitialized();
    }

    private String indexStatStr(SchemaIndexCacheStat stat) throws IgniteCheckedException {
        SB res = new SB();
        res.a("Details for cache rebuilding [name=" + this.cctx.cache().name() + ", grpName=" + this.cctx.group().name() + ']');
        res.a(U.nl());
        res.a("   Scanned rows " + stat.scannedKeys() + ", visited types " + stat.typeNames());
        res.a(U.nl());
        GridQueryIndexing idx = this.cctx.kernalContext().query().getIndexing();
        for (QueryTypeDescriptorImpl type : stat.types()) {
            res.a("        Type name=" + type.name());
            res.a(U.nl());
            String pk = "_key_PK";
            String tblName = type.tableName();
            res.a("            Index: name=" + pk + ", size=" + idx.indexSize(type.schemaName(), tblName, pk));
            res.a(U.nl());
            for (GridQueryIndexDescriptor descriptor : type.indexes().values()) {
                long size = idx.indexSize(type.schemaName(), tblName, descriptor.name());
                res.a("            Index: name=" + descriptor.name() + ", size=" + size);
                res.a(U.nl());
            }
        }
        return res.toString();
    }

    protected void beforeExecute() {
    }

    public String toString() {
        return S.toString(SchemaIndexCacheVisitorImpl.class, this);
    }
}

