/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.processors.cache.verify.NoMatchingCachesException;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecordV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionKeyV2;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.jetbrains.annotations.Nullable;

public class IdleVerifyResultV2
extends VisorDataTransferObject {
    public static final String IDLE_VERIFY_FILE_PREFIX = (Object)((Object)CacheSubcommands.IDLE_VERIFY) + "-";
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss_SSS");
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private Map<PartitionKeyV2, List<PartitionHashRecordV2>> cntrConflicts;
    @GridToStringInclude
    private Map<PartitionKeyV2, List<PartitionHashRecordV2>> hashConflicts;
    @GridToStringInclude
    private Map<PartitionKeyV2, List<PartitionHashRecordV2>> movingPartitions;
    @GridToStringInclude
    private Map<PartitionKeyV2, List<PartitionHashRecordV2>> lostPartitions;
    @GridToStringInclude
    private Map<ClusterNode, Exception> exceptions;

    public IdleVerifyResultV2(Map<PartitionKeyV2, List<PartitionHashRecordV2>> cntrConflicts, Map<PartitionKeyV2, List<PartitionHashRecordV2>> hashConflicts, Map<PartitionKeyV2, List<PartitionHashRecordV2>> movingPartitions, Map<PartitionKeyV2, List<PartitionHashRecordV2>> lostPartitions, Map<ClusterNode, Exception> exceptions) {
        this.cntrConflicts = cntrConflicts;
        this.hashConflicts = hashConflicts;
        this.movingPartitions = movingPartitions;
        this.lostPartitions = lostPartitions;
        this.exceptions = exceptions;
    }

    public IdleVerifyResultV2() {
    }

    @Override
    public byte getProtocolVersion() {
        return 3;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeMap(out, this.cntrConflicts);
        U.writeMap(out, this.hashConflicts);
        U.writeMap(out, this.movingPartitions);
        U.writeMap(out, this.exceptions);
        U.writeMap(out, this.lostPartitions);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.cntrConflicts = U.readMap(in);
        this.hashConflicts = U.readMap(in);
        this.movingPartitions = U.readMap(in);
        if (protoVer >= 2) {
            this.exceptions = U.readMap(in);
        }
        if (protoVer >= 3) {
            this.lostPartitions = U.readMap(in);
        }
    }

    public Map<PartitionKeyV2, List<PartitionHashRecordV2>> counterConflicts() {
        return this.cntrConflicts;
    }

    public Map<PartitionKeyV2, List<PartitionHashRecordV2>> hashConflicts() {
        return this.hashConflicts;
    }

    public Map<PartitionKeyV2, List<PartitionHashRecordV2>> movingPartitions() {
        return Collections.unmodifiableMap(this.movingPartitions);
    }

    public Map<PartitionKeyV2, List<PartitionHashRecordV2>> lostPartitions() {
        return this.lostPartitions;
    }

    public boolean hasConflicts() {
        return !F.isEmpty(this.hashConflicts()) || !F.isEmpty(this.counterConflicts());
    }

    public Map<ClusterNode, Exception> exceptions() {
        return this.exceptions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String print(Consumer<String> printer) {
        this.print(printer, false);
        if (F.isEmpty(this.exceptions)) return null;
        File wd = null;
        try {
            wd = U.resolveWorkDirectory(U.defaultWorkDirectory(), "", false);
        }
        catch (IgniteCheckedException e) {
            printer.accept("Can't find work directory. " + e.getMessage() + "\n");
            e.printStackTrace();
        }
        File f = new File(wd, IDLE_VERIFY_FILE_PREFIX + LocalDateTime.now().format(TIME_FORMATTER) + ".txt");
        try (PrintWriter pw = new PrintWriter(f);){
            this.print(pw::write, true);
            pw.flush();
            printer.accept("See log for additional information. " + f.getAbsolutePath() + "\n");
            String string = f.getAbsolutePath();
            return string;
        }
        catch (FileNotFoundException e) {
            printer.accept("Can't write exceptions to file " + f.getAbsolutePath() + " " + e.getMessage() + "\n");
            e.printStackTrace();
        }
        return null;
    }

    private void print(Consumer<String> printer, boolean printExceptionMessages) {
        boolean noMatchingCaches = false;
        boolean succeeded = true;
        for (Exception exception : this.exceptions.values()) {
            if (!(exception instanceof NoMatchingCachesException)) continue;
            noMatchingCaches = true;
            succeeded = false;
            break;
        }
        if (succeeded) {
            if (!F.isEmpty(this.exceptions)) {
                int size = this.exceptions.size();
                printer.accept("idle_verify failed on " + size + " node" + (size == 1 ? "" : "s") + ".\n");
            }
            if (!this.hasConflicts()) {
                printer.accept("idle_verify check has finished, no conflicts have been found.\n");
            } else {
                this.printConflicts(printer);
            }
            Map<PartitionKeyV2, List<PartitionHashRecordV2>> moving = this.movingPartitions();
            if (!moving.isEmpty()) {
                printer.accept("Possible results are not full due to rebalance still in progress." + U.nl());
            }
            this.printSkippedPartitions(printer, moving, "MOVING");
            this.printSkippedPartitions(printer, this.lostPartitions(), "LOST");
        } else {
            printer.accept("\nidle_verify failed.\n");
            if (noMatchingCaches) {
                printer.accept("\nThere are no caches matching given filter options.\n");
            }
        }
        if (!F.isEmpty(this.exceptions())) {
            printer.accept("\nIdle verify failed on nodes:\n");
            for (Map.Entry entry : this.exceptions().entrySet()) {
                ClusterNode n = (ClusterNode)entry.getKey();
                printer.accept("\nNode ID: " + n.id() + " " + n.addresses() + "\nConsistent ID: " + n.consistentId() + "\n");
                if (!printExceptionMessages) continue;
                String msg = ((Exception)entry.getValue()).getMessage();
                printer.accept("Exception: " + ((Exception)entry.getValue()).getClass().getCanonicalName() + "\n");
                printer.accept(msg == null ? "" : msg + "\n");
            }
        }
    }

    private void printSkippedPartitions(Consumer<String> printer, Map<PartitionKeyV2, List<PartitionHashRecordV2>> map, String partitionState) {
        if (!F.isEmpty(map)) {
            printer.accept("Verification was skipped for " + map.size() + " " + partitionState + " partitions:\n");
            for (Map.Entry<PartitionKeyV2, List<PartitionHashRecordV2>> entry : map.entrySet()) {
                printer.accept("Skipped partition: " + entry.getKey() + "\n");
                printer.accept("Partition instances: " + entry.getValue() + "\n");
            }
            printer.accept("\n");
        }
    }

    private void printConflicts(Consumer<String> printer) {
        int cntrConflictsSize = this.counterConflicts().size();
        int hashConflictsSize = this.hashConflicts().size();
        printer.accept("idle_verify check has finished, found " + (cntrConflictsSize + hashConflictsSize) + " conflict partitions: [counterConflicts=" + cntrConflictsSize + ", hashConflicts=" + hashConflictsSize + "]\n");
        if (!F.isEmpty(this.counterConflicts())) {
            printer.accept("Update counter conflicts:\n");
            for (Map.Entry<PartitionKeyV2, List<PartitionHashRecordV2>> entry : this.counterConflicts().entrySet()) {
                printer.accept("Conflict partition: " + entry.getKey() + "\n");
                printer.accept("Partition instances: " + entry.getValue() + "\n");
            }
            printer.accept("\n");
        }
        if (!F.isEmpty(this.hashConflicts())) {
            printer.accept("Hash conflicts:\n");
            for (Map.Entry<PartitionKeyV2, List<PartitionHashRecordV2>> entry : this.hashConflicts().entrySet()) {
                printer.accept("Conflict partition: " + entry.getKey() + "\n");
                printer.accept("Partition instances: " + entry.getValue() + "\n");
            }
            printer.accept("\n");
        }
    }

    public String toString() {
        return S.toString(IdleVerifyResultV2.class, this);
    }
}

