/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.encryption;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteEncryption;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.encryption.GenerateEncryptionKeyRequest;
import org.apache.ignite.internal.managers.encryption.GenerateEncryptionKeyResponse;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.MasterKeyChangeRecord;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.util.distributed.DistributedProcess;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteFutureCancelledException;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.jetbrains.annotations.Nullable;

public class GridEncryptionManager
extends GridManagerAdapter<EncryptionSpi>
implements MetastorageLifecycleListener,
IgniteChangeGlobalStateSupport,
IgniteEncryption {
    private static final IgniteProductVersion CACHE_ENCRYPTION_SINCE = IgniteProductVersion.fromString("2.7.0");
    private final Object metaStorageMux = new Object();
    private final Object opsMux = new Object();
    private final ReentrantReadWriteLock masterKeyChangeLock = new ReentrantReadWriteLock();
    private volatile boolean disconnected;
    private volatile boolean stopped;
    private volatile boolean writeToMetaStoreEnabled;
    public static final String ENCRYPTION_KEY_PREFIX = "grp-encryption-key-";
    public static final String MASTER_KEY_NAME_PREFIX = "encryption-master-key-name";
    private final ConcurrentHashMap<Integer, Serializable> grpEncKeys = new ConcurrentHashMap();
    private ConcurrentMap<IgniteUuid, GenerateEncryptionKeyFuture> genEncKeyFuts = new ConcurrentHashMap<IgniteUuid, GenerateEncryptionKeyFuture>();
    private volatile ReadWriteMetastorage metaStorage;
    private GridMessageListener ioLsnr;
    private DiscoveryEventListener discoLsnr;
    private volatile boolean restoredFromWAL;
    private volatile boolean recoveryMasterKeyName;
    private MasterKeyChangeFuture masterKeyChangeFut;
    private volatile MasterKeyChangeRequest masterKeyChangeRequest;
    private volatile byte[] masterKeyDigest;
    private DistributedProcess<MasterKeyChangeRequest, MasterKeyChangeResult> prepareMKChangeProc;
    private DistributedProcess<MasterKeyChangeRequest, MasterKeyChangeResult> performMKChangeProc;

    public GridEncryptionManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])new EncryptionSpi[]{ctx.config().getEncryptionSpi()});
        ctx.internalSubscriptionProcessor().registerMetastorageListener(this);
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.startSpi();
        this.discoLsnr = (evt, discoCache) -> {
            UUID leftNodeId = evt.eventNode().id();
            Object object = this.opsMux;
            synchronized (object) {
                Iterator futsIter = this.genEncKeyFuts.entrySet().iterator();
                while (futsIter.hasNext()) {
                    GenerateEncryptionKeyFuture fut = (GenerateEncryptionKeyFuture)futsIter.next().getValue();
                    if (!F.eq(leftNodeId, fut.nodeId())) {
                        return;
                    }
                    try {
                        futsIter.remove();
                        this.sendGenerateEncryptionKeyRequest(fut);
                        this.genEncKeyFuts.put(fut.id(), fut);
                    }
                    catch (IgniteCheckedException e) {
                        fut.onDone(null, (Throwable)e);
                    }
                }
            }
        };
        this.ctx.event().addDiscoveryEventListener(this.discoLsnr, 11, 12);
        this.ioLsnr = (nodeId, msg, plc) -> {
            Object object = this.opsMux;
            synchronized (object) {
                if (msg instanceof GenerateEncryptionKeyRequest) {
                    GenerateEncryptionKeyRequest req = (GenerateEncryptionKeyRequest)msg;
                    assert (req.keyCount() != 0);
                    ArrayList<byte[]> encKeys = new ArrayList<byte[]>(req.keyCount());
                    byte[] masterKeyDigest = this.withMasterKeyChangeReadLock(() -> {
                        for (int i = 0; i < req.keyCount(); ++i) {
                            encKeys.add(((EncryptionSpi)this.getSpi()).encryptKey(((EncryptionSpi)this.getSpi()).create()));
                        }
                        return ((EncryptionSpi)this.getSpi()).masterKeyDigest();
                    });
                    try {
                        this.ctx.io().sendToGridTopic(nodeId, GridTopic.TOPIC_GEN_ENC_KEY, (Message)new GenerateEncryptionKeyResponse(req.id(), encKeys, masterKeyDigest), (byte)2);
                    }
                    catch (IgniteCheckedException e) {
                        U.error(this.log, "Unable to send generate key response[nodeId=" + nodeId + "]");
                    }
                } else {
                    GenerateEncryptionKeyResponse resp = (GenerateEncryptionKeyResponse)msg;
                    GenerateEncryptionKeyFuture fut = (GenerateEncryptionKeyFuture)this.genEncKeyFuts.get(resp.requestId());
                    if (fut != null) {
                        fut.onDone(new T2<Collection<byte[]>, byte[]>(resp.encryptionKeys(), resp.masterKeyDigest()), (Throwable)null);
                    } else {
                        U.warn(this.log, "Response received for a unknown request.[reqId=" + resp.requestId() + "]");
                    }
                }
            }
        };
        this.ctx.io().addMessageListener(GridTopic.TOPIC_GEN_ENC_KEY, this.ioLsnr);
        this.prepareMKChangeProc = new DistributedProcess(this.ctx, DistributedProcess.DistributedProcessType.MASTER_KEY_CHANGE_PREPARE, this::prepareMasterKeyChange, this::finishPrepareMasterKeyChange);
        this.performMKChangeProc = new DistributedProcess(this.ctx, DistributedProcess.DistributedProcessType.MASTER_KEY_CHANGE_FINISH, this::performMasterKeyChange, this::finishPerformMasterKeyChange);
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.stopSpi();
    }

    @Override
    protected void onKernalStart0() throws IgniteCheckedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onKernalStop0(boolean cancel) {
        Object object = this.opsMux;
        synchronized (object) {
            this.stopped = true;
            if (this.ioLsnr != null) {
                this.ctx.io().removeMessageListener(GridTopic.TOPIC_GEN_ENC_KEY, this.ioLsnr);
            }
            if (this.discoLsnr != null) {
                this.ctx.event().removeDiscoveryEventListener(this.discoLsnr, 11, 12);
            }
            this.cancelFutures("Kernal stopped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        Object object = this.opsMux;
        synchronized (object) {
            assert (!this.disconnected);
            this.disconnected = true;
            this.masterKeyChangeRequest = null;
            this.masterKeyDigest = null;
            this.cancelFutures("Client node was disconnected from topology (operation result is unknown).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) {
        Object object = this.opsMux;
        synchronized (object) {
            assert (this.disconnected);
            this.disconnected = false;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLocalJoin() {
        if (!this.isCoordinator()) {
            return;
        }
        Object object = this.metaStorageMux;
        synchronized (object) {
            HashMap<Integer, byte[]> knownEncKeys = this.knownEncryptionKeys();
            HashMap<Integer, byte[]> newEncKeys = this.newEncryptionKeys(knownEncKeys == null ? Collections.EMPTY_SET : knownEncKeys.keySet());
            if (newEncKeys == null) {
                return;
            }
            for (Map.Entry<Integer, byte[]> entry : newEncKeys.entrySet()) {
                this.groupKey(entry.getKey(), entry.getValue());
                U.quietAndInfo(this.log, "Added encryption key on local join [grpId=" + entry.getKey() + "]");
            }
        }
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node, DiscoveryDataBag.JoiningNodeDiscoveryData discoData) {
        IgniteNodeValidationResult res = super.validateNode(node, discoData);
        if (res != null) {
            return res;
        }
        if (this.isMasterKeyChangeInProgress()) {
            return new IgniteNodeValidationResult(this.ctx.localNodeId(), "Master key change is in progress! Node join is rejected. [node=" + node.id() + "]", "Master key change is in progress! Node join is rejected.");
        }
        if (node.isClient() || node.isDaemon()) {
            return null;
        }
        res = this.validateNode(node);
        if (res != null) {
            return res;
        }
        NodeEncryptionKeys nodeEncKeys = (NodeEncryptionKeys)discoData.joiningNodeData();
        if (!discoData.hasJoiningNodeData() || nodeEncKeys == null) {
            return new IgniteNodeValidationResult(this.ctx.localNodeId(), "Joining node doesn't have encryption data [node=" + node.id() + "]", "Joining node doesn't have encryption data.");
        }
        if (!Arrays.equals(((EncryptionSpi)this.getSpi()).masterKeyDigest(), nodeEncKeys.masterKeyDigest)) {
            return new IgniteNodeValidationResult(this.ctx.localNodeId(), "Master key digest differs! Node join is rejected. [node=" + node.id() + "]", "Master key digest differs! Node join is rejected.");
        }
        if (F.isEmpty(nodeEncKeys.knownKeys)) {
            U.quietAndInfo(this.log, "Joining node doesn't have stored group keys [node=" + node.id() + "]");
            return null;
        }
        for (Map.Entry<Integer, byte[]> entry : nodeEncKeys.knownKeys.entrySet()) {
            Serializable rmtKey;
            Serializable locEncKey = this.grpEncKeys.get(entry.getKey());
            if (locEncKey == null || F.eq(locEncKey, rmtKey = ((EncryptionSpi)this.getSpi()).decryptKey(entry.getValue()))) continue;
            return new IgniteNodeValidationResult(this.ctx.localNodeId(), "Cache key differs! Node join is rejected. [node=" + node.id() + ", grp=" + entry.getKey() + "]", "Cache key differs! Node join is rejected.");
        }
        return null;
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        if (dataBag.isJoiningNodeClient()) {
            return;
        }
        HashMap<Integer, byte[]> knownEncKeys = this.knownEncryptionKeys();
        HashMap<Integer, byte[]> newKeys = this.newEncryptionKeys(knownEncKeys == null ? Collections.EMPTY_SET : knownEncKeys.keySet());
        if (this.log.isInfoEnabled()) {
            String newGrps;
            String knownGrps;
            String string = knownGrps = F.isEmpty(knownEncKeys) ? null : F.concat(knownEncKeys.keySet(), ",");
            if (knownGrps != null) {
                U.quietAndInfo(this.log, "Sending stored group keys to coordinator [grps=" + knownGrps + "]");
            }
            String string2 = newGrps = F.isEmpty(newKeys) ? null : F.concat(newKeys.keySet(), ",");
            if (newGrps != null) {
                U.quietAndInfo(this.log, "Sending new group keys to coordinator [grps=" + newGrps + "]");
            }
        }
        dataBag.addJoiningNodeData(GridComponent.DiscoveryDataExchangeType.ENCRYPTION_MGR.ordinal(), new NodeEncryptionKeys(knownEncKeys, newKeys, ((EncryptionSpi)this.getSpi()).masterKeyDigest()));
    }

    @Override
    public void onJoiningNodeDataReceived(DiscoveryDataBag.JoiningNodeDiscoveryData data) {
        NodeEncryptionKeys nodeEncryptionKeys = (NodeEncryptionKeys)data.joiningNodeData();
        if (nodeEncryptionKeys == null || nodeEncryptionKeys.newKeys == null || this.ctx.clientNode()) {
            return;
        }
        for (Map.Entry<Integer, byte[]> entry : nodeEncryptionKeys.newKeys.entrySet()) {
            if (this.groupKey(entry.getKey()) == null) {
                U.quietAndInfo(this.log, "Store group key received from joining node [node=" + data.joiningNodeId() + ", grp=" + entry.getKey() + "]");
                this.groupKey(entry.getKey(), entry.getValue());
                continue;
            }
            U.quietAndInfo(this.log, "Skip group key received from joining node. Already exists. [node=" + data.joiningNodeId() + ", grp=" + entry.getKey() + "]");
        }
    }

    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        if (dataBag.isJoiningNodeClient() || dataBag.commonDataCollectedFor(GridComponent.DiscoveryDataExchangeType.ENCRYPTION_MGR.ordinal())) {
            return;
        }
        HashMap<Integer, byte[]> knownEncKeys = this.knownEncryptionKeys();
        HashMap<Integer, byte[]> newKeys = this.newEncryptionKeys(knownEncKeys == null ? Collections.EMPTY_SET : knownEncKeys.keySet());
        if (knownEncKeys == null) {
            knownEncKeys = newKeys;
        } else if (newKeys != null) {
            for (Map.Entry<Integer, byte[]> entry : newKeys.entrySet()) {
                byte[] old = knownEncKeys.putIfAbsent(entry.getKey(), entry.getValue());
                assert (old == null);
            }
        }
        dataBag.addGridCommonData(GridComponent.DiscoveryDataExchangeType.ENCRYPTION_MGR.ordinal(), knownEncKeys);
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        if (this.ctx.clientNode()) {
            return;
        }
        Map encKeysFromCluster = (Map)((Object)data.commonData());
        if (F.isEmpty(encKeysFromCluster)) {
            return;
        }
        for (Map.Entry entry : encKeysFromCluster.entrySet()) {
            if (this.groupKey((Integer)entry.getKey()) == null) {
                U.quietAndInfo(this.log, "Store group key received from coordinator [grp=" + entry.getKey() + "]");
                this.groupKey((Integer)entry.getKey(), (byte[])entry.getValue());
                continue;
            }
            U.quietAndInfo(this.log, "Skip group key received from coordinator. Already exists. [grp=" + entry.getKey() + "]");
        }
    }

    @Nullable
    public Serializable groupKey(int grpId) {
        if (this.grpEncKeys.isEmpty()) {
            return null;
        }
        return this.grpEncKeys.get(grpId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void groupKey(int grpId, byte[] encGrpKey) {
        assert (!this.grpEncKeys.containsKey(grpId));
        Serializable encKey = this.withMasterKeyChangeReadLock(() -> ((EncryptionSpi)this.getSpi()).decryptKey(encGrpKey));
        Object object = this.metaStorageMux;
        synchronized (object) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Key added. [grp=" + grpId + "]");
            }
            this.grpEncKeys.put(grpId, encKey);
            this.writeToMetaStore(grpId, encGrpKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Void> changeMasterKey(String masterKeyName) {
        byte[] digest;
        if (this.ctx.clientNode()) {
            return new IgniteFinishedFutureImpl<Void>(new UnsupportedOperationException("Client and daemon nodes can not perform this operation."));
        }
        if (!IgniteFeatures.allNodesSupports(this.ctx.grid().cluster().nodes(), IgniteFeatures.MASTER_KEY_CHANGE)) {
            return new IgniteFinishedFutureImpl<Void>(new IllegalStateException("Not all nodes in the cluster support the master key change process."));
        }
        if (!this.ctx.state().clusterState().active()) {
            return new IgniteFinishedFutureImpl<Void>(new IgniteException("Master key change was rejected. The cluster is inactive."));
        }
        if (masterKeyName.equals(this.getMasterKeyName())) {
            return new IgniteFinishedFutureImpl<Void>(new IgniteException("Master key change was rejected. New name equal to the current."));
        }
        try {
            digest = this.masterKeyDigest(masterKeyName);
        }
        catch (Exception e) {
            return new IgniteFinishedFutureImpl<Void>(new IgniteException("Master key change was rejected. Unable to get the master key digest."));
        }
        MasterKeyChangeRequest request = new MasterKeyChangeRequest(UUID.randomUUID(), this.encryptKeyName(masterKeyName), digest);
        Object object = this.opsMux;
        synchronized (object) {
            if (this.disconnected) {
                return new IgniteFinishedFutureImpl<Void>(new IgniteClientDisconnectedException(this.ctx.cluster().clientReconnectFuture(), "Master key change was rejected. Client node disconnected."));
            }
            if (this.stopped) {
                return new IgniteFinishedFutureImpl<Void>(new IgniteException("Master key change was rejected. Node is stopping."));
            }
            if (this.masterKeyChangeFut != null && !this.masterKeyChangeFut.isDone()) {
                return new IgniteFinishedFutureImpl<Void>(new IgniteException("Master key change was rejected. The previous change was not completed."));
            }
            this.masterKeyChangeFut = new MasterKeyChangeFuture(request.requestId());
            this.prepareMKChangeProc.start(request.requestId(), request);
            return new IgniteFutureImpl<Void>(this.masterKeyChangeFut);
        }
    }

    @Override
    public String getMasterKeyName() {
        if (this.ctx.clientNode()) {
            throw new UnsupportedOperationException("Client and daemon nodes can not perform this operation.");
        }
        return this.withMasterKeyChangeReadLock(() -> ((EncryptionSpi)this.getSpi()).getMasterKeyName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeGroupKey(int grpId) {
        Object object = this.metaStorageMux;
        synchronized (object) {
            this.ctx.cache().context().database().checkpointReadLock();
            try {
                this.grpEncKeys.remove(grpId);
                this.metaStorage.remove(ENCRYPTION_KEY_PREFIX + grpId);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Key removed. [grp=" + grpId + "]");
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to clear meta storage", e);
            }
            finally {
                this.ctx.cache().context().database().checkpointReadUnlock();
            }
        }
    }

    public void beforeCacheGroupStart(int grpId, @Nullable byte[] encKey) {
        if (encKey == null || this.ctx.clientNode()) {
            return;
        }
        this.groupKey(grpId, encKey);
    }

    public void onCacheGroupDestroyed(int grpId) {
        if (this.groupKey(grpId) == null) {
            return;
        }
        this.removeGroupKey(grpId);
    }

    @Override
    public void onReadyForRead(ReadOnlyMetastorage metastorage) {
        try {
            String masterKeyName;
            if (!this.restoredFromWAL && (masterKeyName = (String)((Object)metastorage.read(MASTER_KEY_NAME_PREFIX))) != null) {
                this.log.info("Master key name loaded from metastrore [masterKeyName=" + masterKeyName + ']');
                ((EncryptionSpi)this.getSpi()).setMasterKeyName(masterKeyName);
            }
            metastorage.iterate(ENCRYPTION_KEY_PREFIX, (key, val) -> {
                Integer grpId = Integer.valueOf(key.replace(ENCRYPTION_KEY_PREFIX, ""));
                byte[] encGrpKey = (byte[])val;
                this.grpEncKeys.computeIfAbsent(grpId, k -> ((EncryptionSpi)this.getSpi()).decryptKey(encGrpKey));
            }, true);
            if (!this.grpEncKeys.isEmpty()) {
                U.quietAndInfo(this.log, "Encryption keys loaded from metastore. [grps=" + F.concat(this.grpEncKeys.keySet(), ",") + ", masterKeyName=" + ((EncryptionSpi)this.getSpi()).getMasterKeyName() + ']');
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to read encryption keys state.", e);
        }
        String newMasterKeyName = IgniteSystemProperties.getString("IGNITE_MASTER_KEY_NAME_TO_CHANGE_BEFORE_STARTUP");
        if (newMasterKeyName != null) {
            if (newMasterKeyName.equals(((EncryptionSpi)this.getSpi()).getMasterKeyName())) {
                this.log.info("Restored master key name equals to name from system property IGNITE_MASTER_KEY_NAME_TO_CHANGE_BEFORE_STARTUP. This system property will be ignored and recommended to remove [masterKeyName=" + newMasterKeyName + ']');
                return;
            }
            this.recoveryMasterKeyName = true;
            this.log.info("System property IGNITE_MASTER_KEY_NAME_TO_CHANGE_BEFORE_STARTUP is set. Master key will be changed locally and group keys will be re-encrypted before join to cluster. Result will be saved to MetaStore on activation process. [masterKeyName=" + newMasterKeyName + ']');
            ((EncryptionSpi)this.getSpi()).setMasterKeyName(newMasterKeyName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReadyForReadWrite(ReadWriteMetastorage metaStorage) throws IgniteCheckedException {
        Object object = this.metaStorageMux;
        synchronized (object) {
            this.metaStorage = metaStorage;
            this.writeToMetaStoreEnabled = true;
            if (this.recoveryMasterKeyName) {
                this.writeKeysToWal();
            }
            this.writeKeysToMetaStore(this.restoredFromWAL || this.recoveryMasterKeyName);
            this.restoredFromWAL = false;
            this.recoveryMasterKeyName = false;
        }
    }

    @Override
    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        this.withMasterKeyChangeReadLock(() -> {
            Object object = this.metaStorageMux;
            synchronized (object) {
                boolean bl = this.writeToMetaStoreEnabled = this.metaStorage != null;
                if (this.writeToMetaStoreEnabled) {
                    this.writeKeysToMetaStore(false);
                }
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDeActivate(GridKernalContext kctx) {
        Object object = this.metaStorageMux;
        synchronized (object) {
            this.writeToMetaStoreEnabled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<T2<Collection<byte[]>, byte[]>> generateKeys(int keyCnt) {
        if (keyCnt == 0 || !this.ctx.clientNode()) {
            return new GridFinishedFuture<T2<Collection<byte[]>, byte[]>>(this.createKeys(keyCnt));
        }
        Object object = this.opsMux;
        synchronized (object) {
            if (this.disconnected || this.stopped) {
                return new GridFinishedFuture<T2<Collection<byte[]>, byte[]>>(new IgniteFutureCancelledException("Node " + (this.stopped ? "stopped" : "disconnected")));
            }
            try {
                GenerateEncryptionKeyFuture genEncKeyFut = new GenerateEncryptionKeyFuture(keyCnt);
                this.sendGenerateEncryptionKeyRequest(genEncKeyFut);
                this.genEncKeyFuts.put(genEncKeyFut.id(), genEncKeyFut);
                return genEncKeyFut;
            }
            catch (IgniteCheckedException e) {
                return new GridFinishedFuture<T2<Collection<byte[]>, byte[]>>(e);
            }
        }
    }

    private void sendGenerateEncryptionKeyRequest(GenerateEncryptionKeyFuture fut) throws IgniteCheckedException {
        ClusterNode rndNode = U.randomServerNode(this.ctx);
        if (rndNode == null) {
            throw new IgniteCheckedException("There is no node to send GenerateEncryptionKeyRequest to");
        }
        GenerateEncryptionKeyRequest req = new GenerateEncryptionKeyRequest(fut.keyCount());
        fut.id(req.id());
        fut.nodeId(rndNode.id());
        this.ctx.io().sendToGridTopic(rndNode.id(), GridTopic.TOPIC_GEN_ENC_KEY, (Message)req, (byte)2);
    }

    private void writeKeysToMetaStore(boolean writeAll) throws IgniteCheckedException {
        if (writeAll) {
            this.metaStorage.write(MASTER_KEY_NAME_PREFIX, (Serializable)((Object)((EncryptionSpi)this.getSpi()).getMasterKeyName()));
        }
        for (Map.Entry<Integer, Serializable> entry : this.grpEncKeys.entrySet()) {
            if (!writeAll && this.metaStorage.read(ENCRYPTION_KEY_PREFIX + entry.getKey()) != null) continue;
            this.writeToMetaStore(entry.getKey(), ((EncryptionSpi)this.getSpi()).encryptKey(entry.getValue()));
        }
    }

    public void checkEncryptedCacheSupported() throws IgniteCheckedException {
        Collection<ClusterNode> nodes = this.ctx.grid().cluster().nodes();
        for (ClusterNode node : nodes) {
            if (CACHE_ENCRYPTION_SINCE.compareTo(node.version()) <= 0) continue;
            throw new IgniteCheckedException("All nodes in cluster should be 2.7.0 or greater to create encrypted cache! [nodeId=" + node.id() + "]");
        }
    }

    @Override
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.ENCRYPTION_MGR;
    }

    private void writeToMetaStore(int grpId, byte[] encGrpKey) {
        if (this.metaStorage == null || !this.writeToMetaStoreEnabled) {
            return;
        }
        this.ctx.cache().context().database().checkpointReadLock();
        try {
            this.metaStorage.write(ENCRYPTION_KEY_PREFIX + grpId, (Serializable)encGrpKey);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to write cache group encryption key [grpId=" + grpId + ']', e);
        }
        finally {
            this.ctx.cache().context().database().checkpointReadUnlock();
        }
    }

    @Nullable
    private HashMap<Integer, byte[]> newEncryptionKeys(Set<Integer> knownKeys) {
        assert (!this.isMasterKeyChangeInProgress());
        Map<Integer, CacheGroupDescriptor> grpDescs = this.ctx.cache().cacheGroupDescriptors();
        HashMap<Integer, byte[]> newKeys = null;
        for (CacheGroupDescriptor grpDesc : grpDescs.values()) {
            if (knownKeys.contains(grpDesc.groupId()) || !grpDesc.config().isEncryptionEnabled()) continue;
            if (newKeys == null) {
                newKeys = new HashMap<Integer, byte[]>();
            }
            newKeys.put(grpDesc.groupId(), ((EncryptionSpi)this.getSpi()).encryptKey(((EncryptionSpi)this.getSpi()).create()));
        }
        return newKeys;
    }

    @Nullable
    private HashMap<Integer, byte[]> knownEncryptionKeys() {
        if (F.isEmpty(this.grpEncKeys)) {
            return null;
        }
        HashMap<Integer, byte[]> knownKeys = new HashMap<Integer, byte[]>();
        for (Map.Entry<Integer, Serializable> entry : this.grpEncKeys.entrySet()) {
            knownKeys.put(entry.getKey(), ((EncryptionSpi)this.getSpi()).encryptKey(entry.getValue()));
        }
        return knownKeys;
    }

    private T2<Collection<byte[]>, byte[]> createKeys(int keyCnt) {
        return this.withMasterKeyChangeReadLock(() -> {
            if (keyCnt == 0) {
                return new T2(Collections.emptyList(), ((EncryptionSpi)this.getSpi()).masterKeyDigest());
            }
            ArrayList<byte[]> encKeys = new ArrayList<byte[]>(keyCnt);
            for (int i = 0; i < keyCnt; ++i) {
                encKeys.add(((EncryptionSpi)this.getSpi()).encryptKey(((EncryptionSpi)this.getSpi()).create()));
            }
            return new T2(encKeys, ((EncryptionSpi)this.getSpi()).masterKeyDigest());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChangeMasterKey(String name) {
        this.log.info("Start master key change [masterKeyName=" + name + ']');
        this.masterKeyChangeLock.writeLock().lock();
        try {
            ((EncryptionSpi)this.getSpi()).setMasterKeyName(name);
            this.ctx.cache().context().database().checkpointReadLock();
            try {
                this.writeKeysToWal();
                Object object = this.metaStorageMux;
                synchronized (object) {
                    assert (this.writeToMetaStoreEnabled);
                    this.writeKeysToMetaStore(true);
                }
            }
            finally {
                this.ctx.cache().context().database().checkpointReadUnlock();
            }
            this.log.info("Master key successfully changed [masterKeyName=" + name + ']');
        }
        catch (Exception e) {
            U.error(this.log, "Unable to change master key locally.", e);
            this.ctx.failure().process(new FailureContext(FailureType.CRITICAL_ERROR, new IgniteException("Unable to change master key locally.", e)));
        }
        finally {
            this.masterKeyChangeLock.writeLock().unlock();
        }
    }

    private void writeKeysToWal() throws IgniteCheckedException {
        HashMap<Integer, byte[]> reencryptedKeys = new HashMap<Integer, byte[]>();
        for (Map.Entry<Integer, Serializable> entry : this.grpEncKeys.entrySet()) {
            reencryptedKeys.put(entry.getKey(), ((EncryptionSpi)this.getSpi()).encryptKey(entry.getValue()));
        }
        MasterKeyChangeRecord rec = new MasterKeyChangeRecord(((EncryptionSpi)this.getSpi()).getMasterKeyName(), reencryptedKeys);
        WALPointer ptr = this.ctx.cache().context().wal().log(rec);
        assert (ptr != null);
    }

    public void applyKeys(MasterKeyChangeRecord rec) {
        assert (!this.writeToMetaStoreEnabled && !this.ctx.state().clusterState().active());
        this.log.info("Master key name loaded from WAL [masterKeyName=" + rec.getMasterKeyName() + ']');
        try {
            ((EncryptionSpi)this.getSpi()).setMasterKeyName(rec.getMasterKeyName());
            for (Map.Entry<Integer, byte[]> entry : rec.getGrpKeys().entrySet()) {
                this.grpEncKeys.put(entry.getKey(), ((EncryptionSpi)this.getSpi()).decryptKey(entry.getValue()));
            }
            this.restoredFromWAL = true;
        }
        catch (IgniteSpiException e) {
            this.log.warning("Unable to apply group keys from WAL record [masterKeyName=" + rec.getMasterKeyName() + ']', e);
        }
    }

    private IgniteInternalFuture<MasterKeyChangeResult> prepareMasterKeyChange(MasterKeyChangeRequest req) {
        if (this.masterKeyChangeRequest != null) {
            return new GridFinishedFuture<MasterKeyChangeResult>(new IgniteException("Master key change was rejected. The previous change was not completed."));
        }
        this.masterKeyChangeRequest = req;
        if (this.ctx.clientNode()) {
            return new GridFinishedFuture<MasterKeyChangeResult>();
        }
        try {
            String masterKeyName = this.decryptKeyName(req.encKeyName());
            if (masterKeyName.equals(this.getMasterKeyName())) {
                throw new IgniteException("Master key change was rejected. New name equal to the current.");
            }
            byte[] digest = this.masterKeyDigest(masterKeyName);
            if (!Arrays.equals(req.digest, digest)) {
                return new GridFinishedFuture<MasterKeyChangeResult>(new IgniteException("Master key change was rejected. Master key digest consistency check failed. Make sure that the new master key is the same at all server nodes [nodeId=" + this.ctx.localNodeId() + ']'));
            }
        }
        catch (Exception e) {
            return new GridFinishedFuture<MasterKeyChangeResult>(new IgniteException("Master key change was rejected [nodeId=" + this.ctx.localNodeId() + ']', e));
        }
        return new GridFinishedFuture<MasterKeyChangeResult>(new MasterKeyChangeResult());
    }

    private void finishPrepareMasterKeyChange(UUID id, Map<UUID, MasterKeyChangeResult> res, Map<UUID, Exception> err) {
        if (!err.isEmpty()) {
            if (this.masterKeyChangeRequest != null && this.masterKeyChangeRequest.requestId().equals(id)) {
                this.masterKeyChangeRequest = null;
            }
            this.completeMasterKeyChangeFuture(id, err);
        } else if (this.isCoordinator()) {
            this.performMKChangeProc.start(id, this.masterKeyChangeRequest);
        }
    }

    private IgniteInternalFuture<MasterKeyChangeResult> performMasterKeyChange(MasterKeyChangeRequest req) {
        if (this.masterKeyChangeRequest == null || !this.masterKeyChangeRequest.equals(req)) {
            return new GridFinishedFuture<MasterKeyChangeResult>(new IgniteException("Unknown master key change was rejected."));
        }
        if (!this.ctx.state().clusterState().active()) {
            this.masterKeyChangeRequest = null;
            return new GridFinishedFuture<MasterKeyChangeResult>(new IgniteException("Master key change was rejected. The cluster is inactive."));
        }
        if (!this.ctx.clientNode()) {
            this.doChangeMasterKey(this.decryptKeyName(req.encKeyName()));
        }
        this.masterKeyChangeRequest = null;
        this.masterKeyDigest = req.digest();
        return new GridFinishedFuture<MasterKeyChangeResult>(new MasterKeyChangeResult());
    }

    private void finishPerformMasterKeyChange(UUID id, Map<UUID, MasterKeyChangeResult> res, Map<UUID, Exception> err) {
        this.completeMasterKeyChangeFuture(id, err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeMasterKeyChangeFuture(UUID reqId, Map<UUID, Exception> err) {
        Object object = this.opsMux;
        synchronized (object) {
            boolean isInitiator;
            boolean bl = isInitiator = this.masterKeyChangeFut != null && this.masterKeyChangeFut.id().equals(reqId);
            if (!isInitiator || this.masterKeyChangeFut.isDone()) {
                return;
            }
            if (!F.isEmpty(err)) {
                Exception e = err.values().stream().findFirst().get();
                this.masterKeyChangeFut.onDone(e);
            } else {
                this.masterKeyChangeFut.onDone();
            }
            this.masterKeyChangeFut = null;
        }
    }

    private void cancelFutures(String msg) {
        for (GenerateEncryptionKeyFuture fut : this.genEncKeyFuts.values()) {
            fut.onDone(new IgniteFutureCancelledException(msg));
        }
        if (this.masterKeyChangeFut != null && !this.masterKeyChangeFut.isDone()) {
            this.masterKeyChangeFut.onDone(new IgniteFutureCancelledException(msg));
        }
    }

    private boolean isCoordinator() {
        DiscoverySpi spi = this.ctx.discovery().getInjectedDiscoverySpi();
        if (spi instanceof TcpDiscoverySpi) {
            return ((TcpDiscoverySpi)spi).isLocalNodeCoordinator();
        }
        ClusterNode crd = U.oldest(this.ctx.discovery().aliveServerNodes(), null);
        return crd != null && F.eq(this.ctx.localNodeId(), crd.id());
    }

    public boolean isMasterKeyChangeInProgress() {
        return this.masterKeyChangeRequest != null;
    }

    public byte[] masterKeyDigest() {
        return this.masterKeyDigest;
    }

    private <T> T withMasterKeyChangeReadLock(Callable<T> c) {
        this.masterKeyChangeLock.readLock().lock();
        try {
            T t = c.call();
            return t;
        }
        catch (Exception e) {
            throw new IgniteException(e);
        }
        finally {
            this.masterKeyChangeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] masterKeyDigest(String masterKeyName) {
        byte[] digest;
        this.masterKeyChangeLock.writeLock().lock();
        try {
            String curName = ((EncryptionSpi)this.getSpi()).getMasterKeyName();
            try {
                ((EncryptionSpi)this.getSpi()).setMasterKeyName(masterKeyName);
                digest = ((EncryptionSpi)this.getSpi()).masterKeyDigest();
            }
            catch (Exception e) {
                throw new IgniteException("Unable to set master key locally [masterKeyName=" + masterKeyName + ']', e);
            }
            finally {
                ((EncryptionSpi)this.getSpi()).setMasterKeyName(curName);
            }
        }
        finally {
            this.masterKeyChangeLock.writeLock().unlock();
        }
        return digest;
    }

    private byte[] encryptKeyName(String keyName) {
        return this.withMasterKeyChangeReadLock(() -> {
            Serializable key = ((EncryptionSpi)this.getSpi()).create();
            byte[] encKey = ((EncryptionSpi)this.getSpi()).encryptKey(key);
            byte[] serKeyName = U.toBytes((Serializable)((Object)keyName));
            ByteBuffer res = ByteBuffer.allocate(4 + encKey.length + ((EncryptionSpi)this.getSpi()).encryptedSize(serKeyName.length));
            res.putInt(encKey.length);
            res.put(encKey);
            ((EncryptionSpi)this.getSpi()).encrypt(ByteBuffer.wrap(serKeyName), key, res);
            return res.array();
        });
    }

    private String decryptKeyName(byte[] data) {
        return this.withMasterKeyChangeReadLock(() -> {
            ByteBuffer buf = ByteBuffer.wrap(data);
            int keyLen = buf.getInt();
            byte[] encKey = new byte[keyLen];
            buf.get(encKey);
            byte[] encKeyName = new byte[buf.remaining()];
            buf.get(encKeyName);
            byte[] serKeyName = ((EncryptionSpi)this.getSpi()).decrypt(encKeyName, ((EncryptionSpi)this.getSpi()).decryptKey(encKey));
            return (String)U.fromBytes(serKeyName);
        });
    }

    private static class MasterKeyChangeFuture
    extends GridFutureAdapter<Void> {
        private final UUID id;

        private MasterKeyChangeFuture(UUID id) {
            this.id = id;
        }

        public UUID id() {
            return this.id;
        }

        @Override
        public String toString() {
            return S.toString(MasterKeyChangeFuture.class, this);
        }
    }

    private class GenerateEncryptionKeyFuture
    extends GridFutureAdapter<T2<Collection<byte[]>, byte[]>> {
        private IgniteUuid id;
        private int keyCnt;
        private UUID nodeId;

        private GenerateEncryptionKeyFuture(int keyCnt) {
            this.keyCnt = keyCnt;
        }

        @Override
        public boolean onDone(@Nullable T2<Collection<byte[]>, byte[]> res, @Nullable Throwable err) {
            GridEncryptionManager.this.genEncKeyFuts.remove(this.id, this);
            return super.onDone(res, err);
        }

        public IgniteUuid id() {
            return this.id;
        }

        public void id(IgniteUuid id) {
            this.id = id;
        }

        public UUID nodeId() {
            return this.nodeId;
        }

        public void nodeId(UUID nodeId) {
            this.nodeId = nodeId;
        }

        public int keyCount() {
            return this.keyCnt;
        }

        @Override
        public String toString() {
            return S.toString(GenerateEncryptionKeyFuture.class, this);
        }
    }

    public static class NodeEncryptionKeys
    implements Serializable {
        private static final long serialVersionUID = 0L;
        Map<Integer, byte[]> knownKeys;
        Map<Integer, byte[]> newKeys;
        byte[] masterKeyDigest;

        NodeEncryptionKeys(Map<Integer, byte[]> knownKeys, Map<Integer, byte[]> newKeys, byte[] masterKeyDigest) {
            this.knownKeys = knownKeys;
            this.newKeys = newKeys;
            this.masterKeyDigest = masterKeyDigest;
        }
    }

    private static class MasterKeyChangeResult
    implements Serializable {
        private static final long serialVersionUID = 0L;

        private MasterKeyChangeResult() {
        }
    }

    private static class MasterKeyChangeRequest
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final UUID reqId;
        private final byte[] encKeyName;
        private final byte[] digest;

        private MasterKeyChangeRequest(UUID reqId, byte[] encKeyName, byte[] digest) {
            this.reqId = reqId;
            this.encKeyName = encKeyName;
            this.digest = digest;
        }

        UUID requestId() {
            return this.reqId;
        }

        byte[] encKeyName() {
            return this.encKeyName;
        }

        byte[] digest() {
            return this.digest;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MasterKeyChangeRequest)) {
                return false;
            }
            MasterKeyChangeRequest key = (MasterKeyChangeRequest)o;
            return Arrays.equals(this.encKeyName, key.encKeyName) && Arrays.equals(this.digest, key.digest) && Objects.equals(this.reqId, key.reqId);
        }

        public int hashCode() {
            int res = Objects.hash(this.reqId);
            res = 31 * res + Arrays.hashCode(this.encKeyName);
            res = 31 * res + Arrays.hashCode(this.digest);
            return res;
        }

        public String toString() {
            return S.toString(MasterKeyChangeRequest.class, this);
        }
    }
}

