/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.configuration;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.tracing.Scope;

public class VisorTracingConfigurationItem
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private Scope scope;
    private String lb;
    private Double samplingRate;
    private Set<Scope> includedScopes;

    public VisorTracingConfigurationItem() {
    }

    public VisorTracingConfigurationItem(Scope scope, String lb, Double samplingRate, Set<Scope> includedScopes) {
        this.scope = scope;
        this.lb = lb;
        this.samplingRate = samplingRate;
        this.includedScopes = includedScopes;
    }

    public Scope scope() {
        return this.scope;
    }

    public String label() {
        return this.lb;
    }

    public Double samplingRate() {
        return this.samplingRate;
    }

    public Set<Scope> includedScopes() {
        return this.includedScopes;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.scope != null);
        if (this.scope != null) {
            out.writeShort(this.scope.idx());
        }
        U.writeString(out, this.label());
        out.writeObject(this.samplingRate);
        U.writeCollection(out, this.includedScopes);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            this.scope = Scope.fromIndex(in.readShort());
        }
        this.lb = U.readString(in);
        this.samplingRate = (Double)in.readObject();
        this.includedScopes = U.readSet(in);
    }

    public String toString() {
        return S.toString(VisorTracingConfigurationItem.class, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VisorTracingConfigurationItem that = (VisorTracingConfigurationItem)o;
        if (this.scope != that.scope) {
            return false;
        }
        if (this.lb != null ? !this.lb.equals(that.lb) : that.lb != null) {
            return false;
        }
        if (this.samplingRate != null ? !this.samplingRate.equals(that.samplingRate) : that.samplingRate != null) {
            return false;
        }
        return this.includedScopes != null ? this.includedScopes.equals(that.includedScopes) : that.includedScopes == null;
    }
}

